/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterDescriptor;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterRegistry;
import org.eclipse.emf.compare.ui.viewer.filter.FiltersMenu;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.group.DifferenceGroupingFacilityDescriptor;
import org.eclipse.emf.compare.ui.viewer.group.DifferenceGroupingFacilityRegistry;
import org.eclipse.emf.compare.ui.viewer.group.GroupsMenu;
import org.eclipse.emf.compare.ui.viewer.group.IDifferenceGroupingFacility;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureContentProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedStructureMergeViewer
extends ModelStructureMergeViewer {
    @Deprecated
    private ParameterizedStructureContentProvider mProvider;
    private IPropertyChangeListener orderingSelectionListener;

    public ParameterizedStructureMergeViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(parent, compareConfiguration);
    }

    @Override
    protected ModelStructureContentProvider createContentProvider(CompareConfiguration compareConfiguration) {
        EMFCompareUIPlugin.getDefault().getPreferenceStore().getString("emfcompare.default.filters");
        final ParameterizedStructureContentProvider contentProvider = this.buildContentProvider(compareConfiguration);
        this.orderingSelectionListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("structure.ordering.filters")) {
                    contentProvider.setSelectedFilters((List)event.getNewValue());
                } else if (event.getProperty().equals("structure.ordering.group")) {
                    contentProvider.setSelectedGroup((IDifferenceGroupingFacility)event.getNewValue());
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.orderingSelectionListener);
        this.mProvider = contentProvider;
        return contentProvider;
    }

    protected ParameterizedStructureContentProvider buildContentProvider(CompareConfiguration compareConfiguration) {
        ParameterizedStructureContentProvider contentProvider = new ParameterizedStructureContentProvider(compareConfiguration, this.getDefaultOrdering(), this.getDefaultFilters());
        return contentProvider;
    }

    @Override
    protected void createToolItems() {
        ImageDescriptor imgDesc;
        super.createToolItems();
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent());
        tbm.add((IContributionItem)new Separator("ordering"));
        if (DifferenceFilterRegistry.INSTANCE.getDescriptors().size() > 0) {
            FiltersMenu filtersMenu = new FiltersMenu(this);
            try {
                imgDesc = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.emf.compare.ui").getEntry("icons/full/filter.gif")));
                filtersMenu.setImageDescriptor(imgDesc);
            }
            catch (IOException iOException) {}
            tbm.appendToGroup("ordering", (IAction)filtersMenu);
        }
        if (DifferenceGroupingFacilityRegistry.INSTANCE.getDescriptors().size() > 0) {
            GroupsMenu groupsMenu = new GroupsMenu(this);
            imgDesc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            groupsMenu.setImageDescriptor(imgDesc);
            tbm.appendToGroup("ordering", (IAction)groupsMenu);
        }
        tbm.update(true);
    }

    @Deprecated
    public void fireOrderingChanged(int event, Object descriptor) {
        if (this.mProvider != null) {
            if (event == 0) {
                this.mProvider.addSelectedFilter(((DifferenceFilterDescriptor)descriptor).getExtension());
            } else if (event == 1) {
                this.mProvider.removeSelectedFilter(((DifferenceFilterDescriptor)descriptor).getExtension());
            } else if (event == 2) {
                this.mProvider.setSelectedGroup(((DifferenceGroupingFacilityDescriptor)descriptor).getExtension());
            }
        }
    }

    public IPropertyChangeListener getOrderingSelectionListener() {
        return this.orderingSelectionListener;
    }

    protected List<IDifferenceFilter> getDefaultFilters() {
        String preferenceValue = EMFCompareUIPlugin.getDefault().getPreferenceStore().getString("emfcompare.default.filters");
        return DifferenceFilterRegistry.INSTANCE.getFilters(preferenceValue);
    }

    protected IDifferenceGroupingFacility getDefaultOrdering() {
        return null;
    }
}

