/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.ReferencesCheck;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.uml2.diff.internal.extension.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2DiffEngine
extends GenericDiffEngine {
    private Set<IDiffExtensionFactory> uml2ExtensionFactories;

    public DiffModel doDiff(MatchModel match, boolean threeWay) {
        DiffModel ret = super.doDiff(match, threeWay);
        this.postProcess(ret);
        return ret;
    }

    public DiffModel doDiffResourceSet(MatchModel match, boolean threeWay, EcoreUtil.CrossReferencer crossReferencer) {
        DiffModel ret = super.doDiffResourceSet(match, threeWay, crossReferencer);
        this.postProcess(ret);
        return ret;
    }

    void postProcess(DiffModel dg) {
        EcoreUtil.CrossReferencer diffModelCrossReferencer = new EcoreUtil.CrossReferencer((EObject)dg){
            private static final long serialVersionUID = -7188045763674814697L;
            {
                this.crossReference();
            }
        };
        Map<Class<? extends AbstractDiffExtension>, IDiffExtensionFactory> mapUml2ExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories(this);
        this.uml2ExtensionFactories = new HashSet<IDiffExtensionFactory>(mapUml2ExtensionFactories.values());
        TreeIterator tit = dg.eAllContents();
        while (tit.hasNext()) {
            EObject next = (EObject)tit.next();
            if (!(next instanceof DiffElement)) continue;
            this.applyManagedTypes((DiffElement)next, diffModelCrossReferencer);
        }
        diffModelCrossReferencer = null;
        this.fillRequiredDifferences(dg, mapUml2ExtensionFactories);
    }

    private void fillRequiredDifferences(DiffModel dg, Map<Class<? extends AbstractDiffExtension>, IDiffExtensionFactory> mapUml2ExtensionFactories) {
        EcoreUtil.CrossReferencer diffModelCrossReferencer = new EcoreUtil.CrossReferencer((EObject)dg){
            private static final long serialVersionUID = -5034169206637698601L;
            {
                this.crossReference();
            }
        };
        TreeIterator tit = dg.eAllContents();
        while (tit.hasNext()) {
            EObject next = (EObject)tit.next();
            if (!(next instanceof AbstractDiffExtension)) continue;
            this.fillRequiredDifferences(mapUml2ExtensionFactories, (AbstractDiffExtension)next, diffModelCrossReferencer);
        }
    }

    void fillRequiredDifferences(Map<Class<? extends AbstractDiffExtension>, IDiffExtensionFactory> mapUml2ExtensionFactories, AbstractDiffExtension diff, EcoreUtil.CrossReferencer crossReferencer) {
        Class classDiffElement = diff.eClass().getInstanceClass();
        IDiffExtensionFactory diffFactory = mapUml2ExtensionFactories.get(classDiffElement);
        if (diffFactory != null) {
            diffFactory.fillRequiredDifferences(diff, crossReferencer);
        }
    }

    void applyManagedTypes(DiffElement element, EcoreUtil.CrossReferencer diffModelCrossReferencer) {
        for (IDiffExtensionFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            AbstractDiffExtension extension = factory.create(element, diffModelCrossReferencer);
            DiffElement diffParent = factory.getParentDiff(element, diffModelCrossReferencer);
            if (element.isConflicting()) {
                ConflictingDiffElement conflictingDiffElement = null;
                conflictingDiffElement = element.eContainer() != null && element.eContainer() instanceof ConflictingDiffElement ? (ConflictingDiffElement)element.eContainer() : DiffFactory.eINSTANCE.createConflictingDiffElement();
                conflictingDiffElement.getSubDiffElements().add((Object)((DiffElement)extension));
                diffParent.getSubDiffElements().add((Object)conflictingDiffElement);
                continue;
            }
            diffParent.getSubDiffElements().add((Object)((DiffElement)extension));
        }
    }

    @Deprecated
    public EObject getMatched(EObject from, int side) {
        return this.getMatchedEObject(from, side);
    }

    public EObject getMatched(EObject from, IMatchManager.MatchSide side) {
        return this.getMatchManager().getMatchedEObject(from, side);
    }

    public EObject getMatched(EObject from) {
        return this.getMatchManager().getMatchedEObject(from);
    }

    @Deprecated
    public static int getRightSide() {
        return 2;
    }

    @Deprecated
    public static int getLeftSide() {
        return 1;
    }

    @Deprecated
    public static int getAncestorSide() {
        return 0;
    }

    protected ReferencesCheck getReferencesChecker() {
        return new UML2ReferencesCheck(this.getMatchManager());
    }

    private static final class UML2ReferencesCheck
    extends ReferencesCheck {
        private static final String SUBSETS_OF_CONTAINMENT_PROPERTIES = "/org/eclipse/emf/compare/uml2/diff/internal/subsets.of.containment.properties";
        private static final Properties SUBSETS_OF_CONTAINMENT = new Properties();

        static {
            try {
                SUBSETS_OF_CONTAINMENT.load(UML2DiffEngine.class.getResourceAsStream(SUBSETS_OF_CONTAINMENT_PROPERTIES));
            }
            catch (IOException iOException) {}
        }

        UML2ReferencesCheck(IMatchManager matchManager) {
            super(matchManager);
        }

        protected boolean shouldBeIgnored(EReference reference) {
            String fqn = this.fqn(reference);
            return super.shouldBeIgnored(reference) || SUBSETS_OF_CONTAINMENT.getProperty(fqn) != null;
        }

        private String fqn(EReference reference) {
            StringBuilder fqn = new StringBuilder(reference.getEContainingClass().getName());
            fqn.append('.').append(reference.getName());
            return fqn.toString();
        }
    }
}

