/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiagramLabelChange;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiffExtension;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramDiffExtension;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramLabelChange;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramdiffFactory;
import org.eclipse.emf.compare.diagram.diff.internal.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.diagram.diff.internal.IDiffExtensionFactory;
import org.eclipse.emf.compare.diagram.diff.util.DiffUtil;
import org.eclipse.emf.compare.diagram.provider.IViewLabelProvider;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.AttributesCheck;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramDiffEngine
extends GenericDiffEngine {
    private Set<IDiffExtensionFactory> diagramExtensionFactories;

    protected DiffGroup doDiffThreeWay(MatchModel match) {
        DiffGroup ret = super.doDiffThreeWay(match);
        DiffUtil.clearLabelExtensions();
        this.postProcess(ret, match);
        return ret;
    }

    protected DiffGroup doDiffTwoWay(MatchModel match) {
        DiffGroup ret = super.doDiffTwoWay(match);
        DiffUtil.clearLabelExtensions();
        this.postProcess(ret, match);
        return ret;
    }

    protected void postProcess(DiffGroup dg, MatchModel matchModel) {
        EcoreUtil.CrossReferencer diffModelCrossReferencer = new EcoreUtil.CrossReferencer((EObject)dg){
            private static final long serialVersionUID = -7188045763674814697L;
            {
                this.crossReference();
            }
        };
        this.diagramExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories(diffModelCrossReferencer, matchModel);
        TreeIterator tit = dg.eAllContents();
        while (tit.hasNext()) {
            EObject next = (EObject)tit.next();
            if (!(next instanceof DiffElement)) continue;
            this.applyManagedTypes((DiffElement)next, dg);
        }
    }

    void applyManagedTypes(DiffElement element, DiffGroup root) {
        for (IDiffExtensionFactory factory : this.diagramExtensionFactories) {
            AbstractDiffExtension ext;
            if (!factory.handles(element, root) || !((ext = factory.create(element)) instanceof DiagramDiffExtension)) continue;
            BusinessDiffExtension extension = (BusinessDiffExtension)ext;
            DiffElement diffParent = factory.getParentDiff(element);
            if (this.containsConflictingElement((List<DiffElement>)extension.getHideElements())) {
                ConflictingDiffElement conflict = DiffFactory.eINSTANCE.createConflictingDiffElement();
                EObject origin = this.getMatchManager().getMatchedEObject(extension.getElement(), IMatchManager.MatchSide.ANCESTOR);
                conflict.setOriginElement(origin);
                conflict.setLeftParent(this.getMatchManager().getMatchedEObject(extension.getElement().eContainer(), IMatchManager.MatchSide.LEFT));
                conflict.setRightParent(this.getMatchManager().getMatchedEObject(extension.getElement().eContainer(), IMatchManager.MatchSide.RIGHT));
                conflict.getSubDiffElements().add((Object)extension);
                diffParent.getSubDiffElements().add((Object)conflict);
                continue;
            }
            diffParent.getSubDiffElements().add((Object)extension);
        }
    }

    private boolean containsConflictingElement(List<DiffElement> diffs) {
        int permutationCounter = 0;
        boolean remote = false;
        boolean result = false;
        for (DiffElement diffElement : diffs) {
            if (diffElement.isConflicting()) {
                result = true;
                break;
            }
            if (remote != diffElement.isRemote() && ++permutationCounter == 2) {
                result = true;
                break;
            }
            remote = diffElement.isRemote();
        }
        return result;
    }

    protected AttributesCheck getAttributesChecker() {
        return new DiagramAttributesCheck(this.getMatchManager());
    }

    private static final class DiagramAttributesCheck
    extends AttributesCheck {
        public DiagramAttributesCheck(IMatchManager matchManager) {
            super(matchManager);
        }

        public void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
            super.checkAttributesUpdates(root, mapping);
            this.computeLabelChange(root, mapping.getLeftElement(), mapping.getRightElement());
        }

        public void checkAttributesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
            IViewLabelProvider extensionForType;
            EObject ancestor;
            super.checkAttributesUpdates(root, mapping);
            DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
            DiagramLabelChange diagramLabelChange = this.computeLabelChange(dummyGroup, mapping.getLeftElement(), mapping.getRightElement());
            if (diagramLabelChange instanceof BusinessDiagramLabelChange && (ancestor = mapping.getOriginElement()) instanceof View && DiffUtil.isLabelAvailable(extensionForType = DiffUtil.getExtension((View)ancestor), (View)ancestor)) {
                String ancestorLabel = extensionForType.elementLabel((View)ancestor);
                String leftLabel = ((BusinessDiagramLabelChange)diagramLabelChange).getLeftLabel();
                String rightLabel = ((BusinessDiagramLabelChange)diagramLabelChange).getRightLabel();
                if (ancestorLabel.equals(leftLabel)) {
                    diagramLabelChange.setRemote(true);
                    root.getSubDiffElements().add((Object)diagramLabelChange);
                } else if (!ancestorLabel.equals(rightLabel)) {
                    ConflictingDiffElement conflict = DiffFactory.eINSTANCE.createConflictingDiffElement();
                    conflict.setOriginElement(mapping.getOriginElement());
                    conflict.setLeftParent(mapping.getLeftElement());
                    conflict.setRightParent(mapping.getRightElement());
                    conflict.getSubDiffElements().add((Object)diagramLabelChange);
                    root.getSubDiffElements().add((Object)conflict);
                } else {
                    root.getSubDiffElements().add((Object)diagramLabelChange);
                }
            }
        }

        private DiagramLabelChange computeLabelChange(DiffGroup root, EObject leftElement, EObject rightElement) {
            String rightLabel;
            String leftLabel;
            View view;
            IViewLabelProvider extensionForType;
            DiagramLabelChange diff = null;
            if (leftElement instanceof View && DiffUtil.isLabelAvailable(extensionForType = DiffUtil.getExtension(view = (View)leftElement), view) && DiffUtil.isLabelAvailable(extensionForType, (View)rightElement) && !(leftLabel = extensionForType.elementLabel(view)).equals(rightLabel = extensionForType.elementLabel((View)rightElement))) {
                diff = this.createLabelChange(root, leftElement, rightElement, leftLabel, rightLabel);
            }
            return diff;
        }

        private DiagramLabelChange createLabelChange(DiffGroup root, EObject leftElement, EObject rightElement, String leftLabel, String rightLabel) {
            DiagramLabelChange diff = DiagramdiffFactory.eINSTANCE.createDiagramLabelChange();
            diff.setLeftElement(leftElement);
            diff.setRightElement(rightElement);
            root.getSubDiffElements().add((Object)diff);
            if (diff instanceof BusinessDiagramLabelChange) {
                ((BusinessDiagramLabelChange)diff).setLeftLabel(leftLabel);
                ((BusinessDiagramLabelChange)diff).setRightLabel(rightLabel);
            }
            return diff;
        }
    }
}

