/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.extension;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPatchApplicationResult {
    public final ApplicationStatus status;
    public final Collection<IndepChange> successful;
    public final Collection<IndepChange> bound;
    public final Collection<IndepChange> crossReferences;
    public final Collection<IndepChange> failed;

    public MPatchApplicationResult(ApplicationStatus status, Collection<IndepChange> successful, Collection<IndepChange> bound, Collection<IndepChange> crossReferences, Collection<IndepChange> failed) {
        this.status = status;
        this.successful = Collections.unmodifiableCollection(successful);
        this.bound = Collections.unmodifiableCollection(bound);
        this.crossReferences = Collections.unmodifiableCollection(crossReferences);
        this.failed = Collections.unmodifiableCollection(failed);
    }

    public void showDialog(Shell shell, AdapterFactory adapterFactory) {
        int messageDialogType;
        String msg = this.getMessage(adapterFactory);
        if (ApplicationStatus.SUCCESSFUL.equals((Object)this.status)) {
            messageDialogType = 2;
        } else if (ApplicationStatus.REFERENCES.equals((Object)this.status)) {
            messageDialogType = 4;
        } else if (ApplicationStatus.FAILURE.equals((Object)this.status)) {
            messageDialogType = 1;
        } else {
            throw new IllegalStateException("Unknown result status!");
        }
        MessageDialog.open((int)messageDialogType, (Shell)shell, (String)"MPatch Application results", (String)msg, (int)0);
    }

    public String getMessage(AdapterFactory adapterFactory) {
        StringBuffer msg = new StringBuffer();
        AdapterFactoryLabelProvider labels = new AdapterFactoryLabelProvider(adapterFactory);
        if (ApplicationStatus.SUCCESSFUL.equals((Object)this.status)) {
            msg.append("MPatch Application was successful:\n");
        } else if (ApplicationStatus.REFERENCES.equals((Object)this.status)) {
            msg.append("MPatch Application was partly successful:\n");
        } else if (ApplicationStatus.FAILURE.equals((Object)this.status)) {
            msg.append("MPatch Application was not successful:\n");
        } else {
            throw new IllegalStateException("Unknown result status!");
        }
        msg.append(String.valueOf(this.successful.size()) + " changes were applied successfully.\n");
        if (this.bound.size() > 0) {
            msg.append(String.valueOf(this.bound.size()) + " changes were already applied.\n");
        }
        if (this.crossReferences.size() > 0) {
            msg.append(String.valueOf(this.crossReferences.size()) + " changes with unsufficient cross-reference restoring:\n");
            for (IndepChange change : this.crossReferences) {
                msg.append("    " + labels.getText((Object)change) + "\n");
            }
        }
        if (this.failed.size() > 0) {
            msg.append(String.valueOf(this.failed.size()) + " change applications failed:\n");
            for (IndepChange change : this.failed) {
                msg.append("    " + labels.getText((Object)change) + "\n");
            }
        }
        return msg.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationStatus {
        SUCCESSFUL,
        REFERENCES,
        FAILURE;

    }
}

