/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diagramdiff.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diagram.GMFCompare;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiagramMoveNode;
import org.eclipse.emf.compare.diagram.diagramdiff.impl.DiagramMoveNodeImpl;
import org.eclipse.emf.compare.diagram.diff.util.DiffUtil;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessDiagramMoveNodeImpl
extends DiagramMoveNodeImpl
implements BusinessDiagramMoveNode {
    private List<UpdateAttribute> updateAttributeLocationDiffs;
    private Node leftNode;
    private Node rightNode;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public Object getImage() {
        return null;
    }

    @Override
    public IMerger provideMerger() {
        return null;
    }

    protected void initHiddenDiffElements(DiffElement origin) {
        this.updateAttributeLocationDiffs = this.findHiddenDiffElements(origin);
        this.getHideElements().addAll(this.updateAttributeLocationDiffs);
    }

    protected void initLeftElement(List<UpdateAttribute> diffs) {
        if (diffs.size() > 0) {
            EObject obj = diffs.get(0).getLeftElement().eContainer();
            if (obj instanceof Node) {
                this.leftNode = (Node)obj;
            }
            this.setLeftElement((EObject)this.leftNode);
        }
    }

    protected void initRightElement(List<UpdateAttribute> diffs) {
        if (diffs.size() > 0) {
            EObject obj = diffs.get(0).getRightElement().eContainer();
            if (obj instanceof Node) {
                this.rightNode = (Node)obj;
            }
            this.setRightElement((EObject)this.rightNode);
        }
    }

    public static boolean isConcernedBy(DiffElement diff) {
        return diff instanceof DiffGroup && BusinessDiagramMoveNodeImpl.isNodeLocationComparison((DiffGroup)diff);
    }

    private static int getLocationX(Node node) {
        LayoutConstraint lc = node.getLayoutConstraint();
        if (lc instanceof Bounds) {
            return ((Bounds)lc).getX();
        }
        return -1;
    }

    private static int getLocationY(Node node) {
        LayoutConstraint lc = node.getLayoutConstraint();
        if (lc instanceof Bounds) {
            return ((Bounds)lc).getY();
        }
        return -1;
    }

    private static boolean isNodeLocationComparison(DiffGroup diff) {
        for (DiffElement diffElement : DiffUtil.getSubDiffElements((DiffElement)diff)) {
            if (!BusinessDiagramMoveNodeImpl.isNodeLocationComparison(diffElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNodeLocationComparison(DiffElement diff) {
        return diff instanceof UpdateAttribute && ((UpdateAttribute)diff).getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getLocation()) && DiffUtil.eContainer(((UpdateAttribute)diff).getLeftElement(), Edge.class) == null && BusinessDiagramMoveNodeImpl.isOverThreshold((UpdateAttribute)diff);
    }

    private static boolean isOverThreshold(UpdateAttribute diff) {
        EObject left = diff.getLeftElement();
        EObject right = diff.getRightElement();
        if (left instanceof Bounds && right instanceof Bounds) {
            int threshold;
            int deltaY;
            int leftX = ((Bounds)left).getX();
            int leftY = ((Bounds)left).getY();
            int rightX = ((Bounds)right).getX();
            int rightY = ((Bounds)right).getY();
            int deltaX = Math.abs(leftX - rightX);
            return deltaX + (deltaY = Math.abs(leftY - rightY)) > (threshold = GMFCompare.getDefault().getPreferenceStore().getInt("emfcompare.diagram.move.threshold"));
        }
        return false;
    }

    private List<UpdateAttribute> findHiddenDiffElements(DiffElement origin) {
        ArrayList<UpdateAttribute> result = new ArrayList<UpdateAttribute>();
        for (DiffElement diffElt : DiffUtil.getSubDiffElements(origin)) {
            if (!BusinessDiagramMoveNodeImpl.isNodeLocationComparison(diffElt)) continue;
            result.add((UpdateAttribute)diffElt);
        }
        return result;
    }

    @Override
    public List<UpdateAttribute> getUpdateAttributeLocationDiffs() {
        return this.updateAttributeLocationDiffs;
    }

    @Override
    public Node getLeftNode() {
        return this.leftNode;
    }

    @Override
    public Node getRightNode() {
        return this.rightNode;
    }

    @Override
    public int getLeftLocationX() {
        Node node = this.getLeftNode();
        return BusinessDiagramMoveNodeImpl.getLocationX(node);
    }

    @Override
    public int getLeftLocationY() {
        Node node = this.getLeftNode();
        return BusinessDiagramMoveNodeImpl.getLocationY(node);
    }

    @Override
    public int getRightLocationX() {
        Node node = this.getRightNode();
        return BusinessDiagramMoveNodeImpl.getLocationX(node);
    }

    @Override
    public int getRightLocationY() {
        Node node = this.getRightNode();
        return BusinessDiagramMoveNodeImpl.getLocationY(node);
    }

    @Override
    public void init(DiffElement origin, EcoreUtil.CrossReferencer crossReferencer, MatchModel match) {
        if (origin instanceof DiffGroup) {
            this.initHiddenDiffElements(origin);
            this.getRequires().addAll(this.getHideElements());
            this.initLeftElement(this.updateAttributeLocationDiffs);
            this.initRightElement(this.updateAttributeLocationDiffs);
            this.setRemote(DiffUtil.isRemote(this.getHideElements()));
        }
    }

    @Override
    public EObject getElement() {
        return this.getLeftElement();
    }

    @Override
    public Resource getRightResource() {
        return this.getRightElement().eResource();
    }

    @Override
    public Resource getLeftResource() {
        return this.getLeftElement().eResource();
    }
}

