/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCollectionsHelper {
    private IMatchManager matchManager;

    public DiffCollectionsHelper(IMatchManager manager) {
        this.matchManager = manager;
    }

    public int getNumberOfMissingOccurrence(List<Object> referenceList, List<Object> testedList, Object value) {
        int expectedOccurrences = this.getNumberOfOccurrences(referenceList, value);
        int actualOccurrences = this.getNumberOfOccurrences(testedList, value);
        return expectedOccurrences - actualOccurrences;
    }

    private int getNumberOfOccurrences(List<Object> values, Object value) {
        int i = 0;
        for (Object aValue : values) {
            if (this.areDistinctValues(aValue, value)) continue;
            ++i;
        }
        return i;
    }

    public boolean areDistinctValues(Object left, Object right) {
        boolean distinct;
        if (left instanceof EEnumLiteral && right instanceof EEnumLiteral) {
            StringBuilder value1 = new StringBuilder();
            value1.append(((EEnumLiteral)left).getLiteral()).append(((EEnumLiteral)left).getValue());
            StringBuilder value2 = new StringBuilder();
            value2.append(((EEnumLiteral)right).getLiteral()).append(((EEnumLiteral)right).getValue());
            distinct = !value1.toString().equals(value2.toString());
        } else {
            distinct = left instanceof EObject && right instanceof EObject ? left != this.getMatchManager().getMatchedEObject((EObject)right) : (left != null && left.getClass().isArray() ? this.areDistinctArrays(left, right) : left != null && !left.equals(right) || left == null && left != right);
        }
        return distinct;
    }

    private boolean areDistinctArrays(Object left, Object right) {
        boolean distinct = false;
        if (right == null || !right.getClass().isArray()) {
            distinct = true;
        } else {
            int rightLength;
            int leftLength = Array.getLength(left);
            if (leftLength != (rightLength = Array.getLength(right))) {
                distinct = true;
            } else {
                int i = 0;
                while (i < leftLength) {
                    Object rightElement;
                    Object leftElement = Array.get(left, i);
                    if (this.areDistinctValues(leftElement, rightElement = Array.get(right, i))) {
                        distinct = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return distinct;
    }

    protected IMatchManager getMatchManager() {
        return this.matchManager;
    }
}

