/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.apply.util.ResultAccumulator;
import org.eclipse.emf.compare.mpatch.apply.util.SymRefCheck;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPatchValidator {
    public static List<IndepChange> validateResolutions(ResolvedSymbolicReferences mapping, boolean respectApplied) {
        HashSet<IndepChange> result = new HashSet<IndepChange>();
        MPatchValidator.validateElementStates(mapping, false);
        for (IndepChange change : mapping.getResolutionByChange().keySet()) {
            ResolvedSymbolicReferences.ValidationResult valid = (ResolvedSymbolicReferences.ValidationResult)mapping.getValidation().get(change);
            if (!ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)valid) && !ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)valid)) {
                result.add(change);
                continue;
            }
            if (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)valid) && !respectApplied) {
                result.add(change);
                continue;
            }
            if (mapping.getResolutionByChange().keySet().containsAll((Collection<?>)change.getDependsOn())) continue;
            result.add(change);
        }
        for (IndepChange change : mapping.getResolutionByChange().keySet()) {
            if (result.contains(change)) continue;
            Map symrefs = (Map)mapping.getResolutionByChange().get(change);
            for (IElementReference ref : symrefs.keySet()) {
                IndepChange otherChange;
                if (!(ref instanceof ModelDescriptorReference) || !result.contains(otherChange = (IndepChange)ExtEcoreUtils.getContainerOfType((EObject)((ModelDescriptorReference)ref).getResolvesTo(), (EClass)MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE))) continue;
                result.add(change);
            }
        }
        return new ArrayList<IndepChange>(result);
    }

    public static boolean validateResolution(IElementReference ref, Collection<EObject> elements) {
        if (ref instanceof ModelDescriptorReference) {
            return true;
        }
        int lowerBound = ref.getLowerBound();
        int upperBound = ref.getUpperBound();
        if (elements == null) {
            return false;
        }
        if (lowerBound < 0) {
            return false;
        }
        if (upperBound == lowerBound) {
            return elements.size() == upperBound;
        }
        if (upperBound < 0) {
            return lowerBound <= elements.size();
        }
        if (upperBound > lowerBound) {
            return lowerBound <= elements.size() && upperBound >= elements.size();
        }
        return false;
    }

    static void validateElementStates(ResolvedSymbolicReferences mapping, boolean strict) {
        boolean forward = mapping.getDirection() == 1;
        mapping.getValidation().clear();
        List<IndepChange> orderedChanges = MPatchValidator.orderChanges(mapping.getResolutionByChange().keySet(), !forward);
        for (IndepChange change : orderedChanges) {
            ResolvedSymbolicReferences.ValidationResult state = MPatchValidator.validateElementState(change, mapping, strict, forward);
            mapping.getValidation().put(change, state);
        }
    }

    static ResolvedSymbolicReferences.ValidationResult validateElementState(IndepChange change, ResolvedSymbolicReferences mapping, boolean strict, boolean forward) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        if (change instanceof UnknownChange) {
            return ResolvedSymbolicReferences.ValidationResult.UNKNOWN_CHANGE;
        }
        if (changeMapping == null || ((List)changeMapping.get(change.getCorrespondingElement())).size() == 0) {
            return ResolvedSymbolicReferences.ValidationResult.REFERENCE;
        }
        for (IElementReference symref : changeMapping.keySet()) {
            if (symref.eContainer() instanceof IModelDescriptor || MPatchValidator.validateResolution(symref, (Collection)changeMapping.get(symref))) continue;
            return ResolvedSymbolicReferences.ValidationResult.REFERENCE;
        }
        if (forward) {
            if (change instanceof IndepAddElementChange) {
                return MPatchValidator.validateAddElementState((IndepAddRemElementChange)((IndepAddElementChange)change), changeMapping, strict);
            }
            if (change instanceof IndepRemoveElementChange) {
                return MPatchValidator.validateRemoveElementState((IndepAddRemElementChange)((IndepRemoveElementChange)change), changeMapping, strict);
            }
            if (change instanceof IndepMoveElementChange) {
                return MPatchValidator.validateMoveElementState((IndepMoveElementChange)change, changeMapping, strict, true);
            }
            if (change instanceof IndepAddAttributeChange) {
                return MPatchValidator.validateAddAttributeState((IndepAddRemAttributeChange)((IndepAddAttributeChange)change), changeMapping, strict);
            }
            if (change instanceof IndepRemoveAttributeChange) {
                return MPatchValidator.validateRemoveAttributeState((IndepAddRemAttributeChange)((IndepRemoveAttributeChange)change), changeMapping, strict);
            }
            if (change instanceof IndepUpdateAttributeChange) {
                return MPatchValidator.validateUpdateAttributeState((IndepUpdateAttributeChange)change, changeMapping, strict, true);
            }
            if (change instanceof IndepAddReferenceChange) {
                return MPatchValidator.validateAddReferenceState((IndepAddRemReferenceChange)((IndepAddReferenceChange)change), mapping, strict);
            }
            if (change instanceof IndepRemoveReferenceChange) {
                return MPatchValidator.validateRemoveReferenceState((IndepAddRemReferenceChange)((IndepRemoveReferenceChange)change), mapping, strict);
            }
            if (change instanceof IndepUpdateReferenceChange) {
                return MPatchValidator.validateUpdateReferenceState((IndepUpdateReferenceChange)change, mapping, strict, true);
            }
            throw new IllegalArgumentException("Unknown change type: " + change.eClass().getName());
        }
        if (change instanceof IndepAddElementChange) {
            return MPatchValidator.validateRemoveElementState((IndepAddRemElementChange)((IndepAddElementChange)change), changeMapping, strict);
        }
        if (change instanceof IndepRemoveElementChange) {
            return MPatchValidator.validateAddElementState((IndepAddRemElementChange)((IndepRemoveElementChange)change), changeMapping, strict);
        }
        if (change instanceof IndepMoveElementChange) {
            return MPatchValidator.validateMoveElementState((IndepMoveElementChange)change, changeMapping, strict, false);
        }
        if (change instanceof IndepAddAttributeChange) {
            return MPatchValidator.validateRemoveAttributeState((IndepAddRemAttributeChange)((IndepAddAttributeChange)change), changeMapping, strict);
        }
        if (change instanceof IndepRemoveAttributeChange) {
            return MPatchValidator.validateAddAttributeState((IndepAddRemAttributeChange)((IndepRemoveAttributeChange)change), changeMapping, strict);
        }
        if (change instanceof IndepUpdateAttributeChange) {
            return MPatchValidator.validateUpdateAttributeState((IndepUpdateAttributeChange)change, changeMapping, strict, false);
        }
        if (change instanceof IndepAddReferenceChange) {
            return MPatchValidator.validateRemoveReferenceState((IndepAddRemReferenceChange)((IndepAddReferenceChange)change), mapping, strict);
        }
        if (change instanceof IndepRemoveReferenceChange) {
            return MPatchValidator.validateAddReferenceState((IndepAddRemReferenceChange)((IndepRemoveReferenceChange)change), mapping, strict);
        }
        if (change instanceof IndepUpdateReferenceChange) {
            return MPatchValidator.validateUpdateReferenceState((IndepUpdateReferenceChange)change, mapping, strict, false);
        }
        throw new IllegalArgumentException("Unknown change type: " + change.eClass().getName());
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateUpdateReferenceState(IndepUpdateReferenceChange change, ResolvedSymbolicReferences mapping, boolean strict, boolean forward) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        IElementReference beforeSymRef = forward ? change.getOldReference() : change.getNewReference();
        IElementReference afterSymRef = !forward ? change.getOldReference() : change.getNewReference();
        SymRefCheck beforeCheck = new SymRefCheck(beforeSymRef, changeMapping, change.getReference().getEType(), 1);
        SymRefCheck afterCheck = new SymRefCheck(afterSymRef, changeMapping, change.getReference().getEType(), 1);
        if (beforeCheck.validationResult != null) {
            return beforeCheck.validationResult;
        }
        if (afterCheck.validationResult != null) {
            return afterCheck.validationResult;
        }
        EObject beforeElement = beforeCheck.internal || beforeCheck.symRef == null ? null : beforeCheck.elements.get(0);
        EObject afterElement = afterCheck.internal || afterCheck.symRef == null ? null : afterCheck.elements.get(0);
        ResultAccumulator result = new ResultAccumulator();
        for (EObject element : (List)changeMapping.get(change.getCorrespondingElement())) {
            IndepChange otherChange;
            Object currentElement = element.eGet((EStructuralFeature)change.getReference());
            if (beforeCheck.internal) {
                otherChange = (IndepChange)ExtEcoreUtils.getContainerOfType((EObject)((ModelDescriptorReference)beforeCheck.symRef).getResolvesTo(), (EClass)MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE);
                if (currentElement == null) {
                    if (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals(mapping.getValidation().get(otherChange))) {
                        result.after = true;
                    } else {
                        result.invalid = true;
                    }
                } else if (ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals(mapping.getValidation().get(otherChange))) {
                    result.before = true;
                }
            } else if (currentElement == null && beforeElement == null) {
                result.before = true;
            } else if (currentElement != null && currentElement.equals(beforeElement)) {
                result.before = true;
            }
            if (afterCheck.internal) {
                otherChange = (IndepChange)ExtEcoreUtils.getContainerOfType((EObject)((ModelDescriptorReference)afterCheck.symRef).getResolvesTo(), (EClass)MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE);
                ResolvedSymbolicReferences.ValidationResult otherState = (ResolvedSymbolicReferences.ValidationResult)mapping.getValidation().get(otherChange);
                if (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)otherState)) {
                    result.after = result.after | currentElement != null;
                    continue;
                }
                result.invalid = true;
                continue;
            }
            if (currentElement == null && afterElement == null) {
                result.after = true;
                continue;
            }
            if (currentElement == null || !currentElement.equals(afterElement)) continue;
            result.after = true;
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateRemoveReferenceState(IndepAddRemReferenceChange change, ResolvedSymbolicReferences mapping, boolean strict) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        SymRefCheck symRefCheck = new SymRefCheck(change.getChangedReference(), changeMapping, change.getReference().getEType(), change.getChangedReference().getUpperBound());
        if (symRefCheck.validationResult != null) {
            return symRefCheck.validationResult;
        }
        ResultAccumulator result = new ResultAccumulator();
        for (EObject element : (List)changeMapping.get(change.getCorrespondingElement())) {
            EList rawList = (EList)element.eGet((EStructuralFeature)change.getReference());
            ArrayList list = new ArrayList(rawList);
            if (symRefCheck.internal) {
                IndepChange otherChange = (IndepChange)ExtEcoreUtils.getContainerOfType((EObject)((ModelDescriptorReference)symRefCheck.symRef).getResolvesTo(), (EClass)MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE);
                if (rawList.isEmpty()) {
                    if (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals(mapping.getValidation().get(otherChange))) {
                        result.after = true;
                        continue;
                    }
                    result.invalid = true;
                    continue;
                }
                if (ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals(mapping.getValidation().get(otherChange))) {
                    result.before = true;
                    continue;
                }
                result.invalid = true;
                continue;
            }
            list.retainAll(symRefCheck.elements);
            result.before = result.before | !list.isEmpty();
            result.after = result.after | list.size() < symRefCheck.elements.size();
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateAddReferenceState(IndepAddRemReferenceChange change, ResolvedSymbolicReferences mapping, boolean strict) {
        Map changeMapping = (Map)mapping.getResolutionByChange().get(change);
        SymRefCheck symRefCheck = new SymRefCheck(change.getChangedReference(), changeMapping, change.getReference().getEType(), change.getChangedReference().getUpperBound());
        if (symRefCheck.validationResult != null) {
            return symRefCheck.validationResult;
        }
        ResultAccumulator result = new ResultAccumulator();
        if (symRefCheck.internal) {
            IndepChange otherChange = (IndepChange)ExtEcoreUtils.getContainerOfType((EObject)((ModelDescriptorReference)symRefCheck.symRef).getResolvesTo(), (EClass)MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE);
            ResolvedSymbolicReferences.ValidationResult otherState = (ResolvedSymbolicReferences.ValidationResult)mapping.getValidation().get(otherChange);
            if (ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE.equals((Object)otherState)) {
                result.before = true;
            } else if (ResolvedSymbolicReferences.ValidationResult.STATE_INVALID.equals((Object)otherState)) {
                result.invalid = true;
            } else if (ResolvedSymbolicReferences.ValidationResult.STATE_AFTER.equals((Object)otherState)) {
                Map otherMapping = (Map)mapping.getResolutionByChange().get(otherChange);
                IElementReference selfReference = ((IndepAddRemElementChange)otherChange).getSubModelReference();
                List addedElements = (List)otherMapping.get(selfReference);
                List allAddedElements = ExtEcoreUtils.flattenEObjects((Collection)addedElements);
                symRefCheck.elements.addAll(allAddedElements);
            }
        }
        for (EObject element : (List)changeMapping.get(change.getCorrespondingElement())) {
            EList rawList = (EList)element.eGet((EStructuralFeature)change.getReference());
            ArrayList list = new ArrayList(rawList);
            list.retainAll(symRefCheck.elements);
            if (!symRefCheck.internal) {
                result.before = result.before | list.size() < symRefCheck.elements.size();
            }
            result.after = result.after | !list.isEmpty();
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateUpdateAttributeState(IndepUpdateAttributeChange change, Map<IElementReference, List<EObject>> map, boolean strict, boolean forward) {
        Object oldValue = forward ? change.getOldValue() : change.getNewValue();
        Object newValue = !forward ? change.getOldValue() : change.getNewValue();
        ResultAccumulator result = new ResultAccumulator();
        for (EObject element : map.get(change.getCorrespondingElement())) {
            Object currentValue = element.eGet((EStructuralFeature)change.getChangedAttribute());
            if (currentValue == null && oldValue == null) {
                result.before = true;
                continue;
            }
            if (currentValue != null && currentValue.equals(oldValue)) {
                result.before = true;
                continue;
            }
            if (currentValue == null && newValue == null) {
                result.after = true;
                continue;
            }
            if (currentValue != null && currentValue.equals(newValue)) {
                result.after = true;
                continue;
            }
            result.invalid = true;
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateRemoveAttributeState(IndepAddRemAttributeChange change, Map<IElementReference, List<EObject>> map, boolean strict) {
        Object value = change.getValue();
        ResultAccumulator result = new ResultAccumulator();
        for (EObject element : map.get(change.getCorrespondingElement())) {
            EList currentValues = (EList)element.eGet((EStructuralFeature)change.getChangedAttribute());
            result.before |= currentValues.contains(value);
            result.after = result.after | !currentValues.contains(value);
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateAddAttributeState(IndepAddRemAttributeChange change, Map<IElementReference, List<EObject>> map, boolean strict) {
        Object value = change.getValue();
        ResultAccumulator result = new ResultAccumulator();
        for (EObject element : map.get(change.getCorrespondingElement())) {
            EList currentValues = (EList)element.eGet((EStructuralFeature)change.getChangedAttribute());
            result.before = result.before | !currentValues.contains(value);
            result.after |= currentValues.contains(value);
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateMoveElementState(IndepMoveElementChange change, Map<IElementReference, List<EObject>> map, boolean strict, boolean forward) {
        IElementReference newParentRef;
        EReference oldContainment = forward ? change.getOldContainment() : change.getNewContainment();
        EReference newContainment = forward ? change.getNewContainment() : change.getOldContainment();
        IElementReference oldParentRef = forward ? change.getOldParent() : change.getNewParent();
        IElementReference iElementReference = newParentRef = !forward ? change.getOldParent() : change.getNewParent();
        if (oldParentRef == null || newParentRef == null || oldContainment == null || newContainment == null) {
            throw new IllegalStateException("old and new parent and their containment features must be defined in the change but they are not!");
        }
        Collection correspondingElements = map.get(change.getCorrespondingElement());
        if (!newContainment.isMany() && correspondingElements.size() > 1) {
            return ResolvedSymbolicReferences.ValidationResult.REFERENCE;
        }
        SymRefCheck oldParentCheck = new SymRefCheck(oldParentRef, map, (EClassifier)oldContainment.getEContainingClass(), 1);
        SymRefCheck newParentCheck = new SymRefCheck(newParentRef, map, (EClassifier)newContainment.getEContainingClass(), 1);
        if (oldParentCheck.validationResult != null) {
            return oldParentCheck.validationResult;
        }
        if (newParentCheck.validationResult != null) {
            return newParentCheck.validationResult;
        }
        EObject oldParent = oldParentCheck.internal ? null : oldParentCheck.elements.get(0);
        EObject newParent = newParentCheck.internal ? null : newParentCheck.elements.get(0);
        ResultAccumulator result = new ResultAccumulator();
        if (oldParentCheck.internal) {
            result.before = true;
        } else {
            for (EObject element : map.get(change.getCorrespondingElement())) {
                EObject currentParent = element.eContainer();
                EReference currentContainment = element.eContainmentFeature();
                if (currentParent == null || currentContainment == null) {
                    result.invalid = true;
                    continue;
                }
                if (currentParent.equals(oldParent) && currentContainment.equals(oldContainment)) {
                    result.before = true;
                    continue;
                }
                if (currentParent.equals(newParent) && currentContainment.equals(newContainment)) {
                    result.after = true;
                    continue;
                }
                result.invalid = true;
            }
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateRemoveElementState(IndepAddRemElementChange change, Map<IElementReference, List<EObject>> map, boolean strict) {
        SymRefCheck toDeleteCheck = new SymRefCheck(change.getSubModelReference(), map, (EClassifier)change.getSubModel().getType(), change.getSubModelReference().getUpperBound());
        if (toDeleteCheck.symRef == null || toDeleteCheck.internal) {
            throw new IllegalStateException("Submodel reference must neither be null nor an internal reference!");
        }
        int elementCountToDelete = toDeleteCheck.elements.size();
        ResultAccumulator result = new ResultAccumulator();
        if (elementCountToDelete > 0) {
            for (EObject parent : map.get(change.getCorrespondingElement())) {
                if (change.getContainment().isMany()) {
                    EList rawList = (EList)parent.eGet((EStructuralFeature)change.getContainment());
                    ArrayList toDelete = new ArrayList(rawList);
                    toDelete.retainAll(toDeleteCheck.elements);
                    toDeleteCheck.elements.removeAll(toDelete);
                    result.before = result.before | !toDelete.isEmpty();
                    result.after |= toDelete.isEmpty();
                    continue;
                }
                Object toDelete = parent.eGet((EStructuralFeature)change.getContainment());
                result.invalid = result.invalid | (toDelete == null || !toDeleteCheck.elements.contains(toDelete));
                result.before = result.before | (toDelete != null && toDeleteCheck.elements.remove(toDelete));
            }
        } else {
            result.after = true;
        }
        return result.accumulate(strict);
    }

    protected static ResolvedSymbolicReferences.ValidationResult validateAddElementState(IndepAddRemElementChange change, Map<IElementReference, List<EObject>> map, boolean strict) {
        SymRefCheck toAddCheck = new SymRefCheck(change.getSubModelReference(), map, (EClassifier)change.getSubModel().getType(), change.getSubModelReference().getUpperBound());
        if (toAddCheck.symRef == null || toAddCheck.internal) {
            throw new IllegalStateException("Submodel reference must neither be null nor an internal reference!");
        }
        int i = toAddCheck.elements.size() - 1;
        while (i >= 0) {
            EObject element = toAddCheck.elements.get(i);
            if (change.getSubModel().isDescriptorFor(element, true) == null) {
                toAddCheck.elements.remove(i);
            }
            --i;
        }
        ResultAccumulator result = new ResultAccumulator();
        for (EObject parent : map.get(change.getCorrespondingElement())) {
            if (change.getContainment().isMany()) {
                EList rawList = (EList)parent.eGet((EStructuralFeature)change.getContainment());
                ArrayList added = new ArrayList(rawList);
                added.retainAll(toAddCheck.elements);
                toAddCheck.elements.removeAll(added);
                result.before |= added.isEmpty();
                result.after = result.after | !added.isEmpty();
                continue;
            }
            Object toAdd = parent.eGet((EStructuralFeature)change.getContainment());
            result.invalid = result.invalid | (toAdd != null && !toAddCheck.elements.contains(toAdd));
            result.before = result.before | toAdd == null;
            result.after |= toAddCheck.elements.remove(toAdd);
        }
        return result.accumulate(strict);
    }

    static Collection<EReference> getImportantReferencesFor(EClass eClass, int direction) {
        ArrayList<EReference> refs = new ArrayList<EReference>();
        if (!MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.CHANGE_GROUP) && !MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.UNKNOWN_CHANGE)) {
            refs.add(MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT);
            if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_ADD_ELEMENT_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE__SUB_MODEL_REFERENCE);
            } else if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_REMOVE_ELEMENT_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE__SUB_MODEL_REFERENCE);
            } else if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__OLD_PARENT);
                refs.add(MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__NEW_PARENT);
            } else if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_ADD_REFERENCE_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_ADD_REM_REFERENCE_CHANGE__CHANGED_REFERENCE);
            } else if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_REMOVE_REFERENCE_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_ADD_REM_REFERENCE_CHANGE__CHANGED_REFERENCE);
            } else if (MPatchValidator.equalEClasses(eClass, MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE)) {
                refs.add(MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__OLD_REFERENCE);
                refs.add(MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__NEW_REFERENCE);
            }
        }
        return refs;
    }

    protected static boolean equalEClasses(EClass eClass1, EClass eClass2) {
        return eClass1.getClassifierID() == eClass2.getClassifierID();
    }

    public static List<IndepChange> orderChanges(Set<IndepChange> changes, boolean forward) {
        ArrayList<IndepChange> list = new ArrayList<IndepChange>(changes.size());
        for (IndepChange change : changes) {
            if (change instanceof IndepAddElementChange && forward || change instanceof IndepRemoveElementChange && !forward) {
                list.add(change);
                continue;
            }
            if ((!(change instanceof IndepRemoveElementChange) || !forward) && (!(change instanceof IndepAddElementChange) || forward)) continue;
            list.add(0, change);
        }
        for (IndepChange change : new ArrayList(list)) {
            if (change instanceof IndepAddElementChange && forward || change instanceof IndepRemoveElementChange && !forward) {
                list.addAll((Collection<IndepChange>)change.getDependants());
                continue;
            }
            if ((!(change instanceof IndepRemoveElementChange) || !forward) && (!(change instanceof IndepAddElementChange) || forward)) continue;
            list.addAll(0, (Collection<IndepChange>)change.getDependsOn());
        }
        HashSet<IndepChange> tmpDiffs = new HashSet<IndepChange>(changes);
        tmpDiffs.removeAll(list);
        list.addAll(tmpDiffs);
        list.retainAll(changes);
        if (list.size() > changes.size()) {
            HashSet<IndepChange> elements = new HashSet<IndepChange>(changes.size());
            int i = list.size() - 1;
            while (i >= 0) {
                if (elements.contains(list.get(i))) {
                    list.remove(i);
                } else {
                    elements.add((IndepChange)list.get(i));
                }
                --i;
            }
        }
        if (list.size() != changes.size() || !changes.containsAll(list)) {
            throw new IllegalStateException("The number of ordered changes does not equal the number of total changes! Please check ordering algorithm!");
        }
        return list;
    }
}

