/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.ApplyActivator;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardNewEmfdiffPage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardNewModelPage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardResolvePage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardSaveBindingPage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardSelectMPatchPage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardSelectModelPage;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizardSummaryPage;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionManager;
import org.eclipse.emf.compare.mpatch.extension.IMPatchApplication;
import org.eclipse.emf.compare.mpatch.extension.MPatchApplicationResult;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.provider.MPatchItemProviderAdapterFactory;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class ApplyWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_ICON = "icons/mpatch.gif";
    boolean saveIntermediateFiles;
    boolean saveBinding;
    boolean respectApplied;
    protected IMPatchApplication mPatchApplication = ExtensionManager.getSelectedApplication();
    protected IWorkbench workbench;
    protected IFile mPatchFile;
    protected URI modelURI;
    protected MPatchModel mpatch;
    protected Resource modelResource;
    private EObject modelTarget;
    protected ResolvedSymbolicReferences resolvedElements;
    protected IFile emfdiffFile;
    protected IFile newModelFile;
    private IFile bindingFile;
    private ApplyWizardResolvePage symbolicReferenceResolutionPage;
    private ApplyWizardNewModelPage storeModelPage;
    private ApplyWizardSummaryPage summaryPage;
    private ApplyWizardSelectMPatchPage selectMPatchPage;
    private ApplyWizardSelectModelPage selectModelPage;
    private ApplyWizardNewEmfdiffPage storeDiffPage;
    private ApplyWizardSaveBindingPage storeBindingPage;
    private ComposedAdapterFactory adapterFactory;

    public void addPages() {
        StructuredSelection selection = null;
        if (this.mPatchFile != null) {
            selection = new StructuredSelection((Object)this.mPatchFile);
        }
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MPatchItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.selectMPatchPage = new ApplyWizardSelectMPatchPage("Select MPatch", this.mPatchFile, (AdapterFactory)this.adapterFactory);
        this.selectModelPage = new ApplyWizardSelectModelPage("Select Model", this.modelURI, (AdapterFactory)this.adapterFactory);
        this.symbolicReferenceResolutionPage = new ApplyWizardResolvePage("Resolve Symbolic References", (AdapterFactory)this.adapterFactory);
        this.storeModelPage = new ApplyWizardNewModelPage("Store New Model", (IStructuredSelection)selection);
        this.storeDiffPage = new ApplyWizardNewEmfdiffPage("Store Emfdiff", (IStructuredSelection)selection);
        this.storeBindingPage = new ApplyWizardSaveBindingPage("Store Binding", (IStructuredSelection)selection);
        this.summaryPage = new ApplyWizardSummaryPage("Summary");
        this.addPage((IWizardPage)this.selectMPatchPage);
        this.addPage((IWizardPage)this.selectModelPage);
        this.addPage((IWizardPage)this.symbolicReferenceResolutionPage);
        this.addPage((IWizardPage)this.storeModelPage);
        this.addPage((IWizardPage)this.storeDiffPage);
        this.addPage((IWizardPage)this.storeBindingPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.symbolicReferenceResolutionPage)) {
            this.saveIntermediateFiles = this.symbolicReferenceResolutionPage.storeIntermediateModels();
            this.saveBinding = this.symbolicReferenceResolutionPage.storeBinding();
            if (this.saveIntermediateFiles) {
                return this.storeModelPage;
            }
            if (this.saveBinding) {
                return this.storeBindingPage;
            }
            return this.summaryPage;
        }
        if (page.equals((Object)this.storeDiffPage)) {
            if (this.saveBinding) {
                return this.storeBindingPage;
            }
            return this.summaryPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!(!this.saveIntermediateFiles && (page.equals((Object)this.storeModelPage) || page.equals((Object)this.storeDiffPage)) || !this.saveBinding && page.equals((Object)this.storeBindingPage) || page.isPageComplete())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        URI uri;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                if ("mpatch".equals(file.getFileExtension()) && this.mPatchFile == null) {
                    this.mPatchFile = file;
                } else if (this.modelURI == null) {
                    this.modelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                }
            }
            ++n2;
        }
        this.workbench = workbench;
        this.setWindowTitle("Apply MPatch");
        URL imageURL = ApplyActivator.getDefault().getBundle().getEntry(WIZARD_ICON);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imageURL));
        if (this.modelURI == null) {
            this.modelURI = CommonUtils.getCurrentEditorFileInputUri();
        }
        if (this.modelURI != null && this.mPatchFile != null && this.modelURI.equals((Object)(uri = URI.createPlatformResourceURI((String)this.mPatchFile.getFullPath().toString(), (boolean)true)))) {
            this.modelURI = null;
        }
    }

    public boolean performFinish() {
        final boolean reviewDiffApplication = this.summaryPage.reviewDiffApplication();
        final EObject model = (EObject)this.modelResource.getContents().get(0);
        final boolean[] result = new boolean[]{true};
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Applying MPatch...", 10);
                    monitor.worked(2);
                    HashMap<Integer, Boolean> options = new HashMap<Integer, Boolean>();
                    options.put(IMPatchApplication.OPTION_STORE_BINDING, ApplyWizard.this.saveBinding);
                    options.put(IMPatchApplication.OPTION_MATCH_APPLIED_CHANGES, ApplyWizard.this.respectApplied);
                    try {
                        if (!ApplyWizard.this.saveIntermediateFiles && !reviewDiffApplication) {
                            MPatchApplicationResult result2 = ApplyWizard.this.mPatchApplication.applyMPatch(ApplyWizard.this.resolvedElements, options);
                            result2.showDialog(ApplyWizard.this.getShell(), (AdapterFactory)ApplyWizard.this.adapterFactory);
                            ApplyWizard.this.modelResource.save(null);
                        } else {
                            ResourceImpl emfdiffResource;
                            ResourceImpl copyModelResource;
                            EObject copyModel = EcoreUtil.copy((EObject)model);
                            if (ApplyWizard.this.saveIntermediateFiles) {
                                copyModelResource = new XMIResourceImpl(URI.createPlatformResourceURI((String)ApplyWizard.this.newModelFile.getFullPath().toString(), (boolean)true));
                                emfdiffResource = new XMIResourceImpl(URI.createPlatformResourceURI((String)ApplyWizard.this.emfdiffFile.getFullPath().toString(), (boolean)true));
                            } else {
                                copyModelResource = new ResourceImpl(ApplyWizard.this.modelResource.getURI());
                                emfdiffResource = new ResourceImpl();
                            }
                            copyModelResource.getContents().add((Object)copyModel);
                            monitor.worked(2);
                            MPatchApplicationResult result3 = ApplyWizard.this.mPatchApplication.applyMPatch(ApplyWizard.this.resolvedElements, options);
                            monitor.worked(2);
                            result3.showDialog(ApplyWizard.this.getShell(), (AdapterFactory)ApplyWizard.this.adapterFactory);
                            ApplyWizard.this.modelResource.save(null);
                            ComparisonResourceSnapshot emfdiff = CommonUtils.createEmfdiff((EObject)model, (EObject)copyModel, (boolean)false);
                            if (ApplyWizard.this.saveIntermediateFiles) {
                                copyModelResource.save(null);
                                emfdiffResource.getContents().add((Object)emfdiff);
                                emfdiffResource.save(null);
                                if (reviewDiffApplication) {
                                    IDE.openEditor((IWorkbenchPage)ApplyWizard.this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)ApplyWizard.this.emfdiffFile);
                                }
                            } else if (reviewDiffApplication) {
                                CompareUI.openCompareEditor((CompareEditorInput)new ModelCompareEditorInput((ComparisonSnapshot)emfdiff));
                            }
                            monitor.worked(2);
                        }
                        if (ApplyWizard.this.saveBinding) {
                            try {
                                XMIResourceImpl bindingResource = new XMIResourceImpl(URI.createPlatformResourceURI((String)ApplyWizard.this.bindingFile.getFullPath().toString(), (boolean)true));
                                bindingResource.getContents().add((Object)ApplyWizard.this.resolvedElements.getMPatchModelBinding());
                                bindingResource.save(null);
                            }
                            catch (IOException e) {
                                ApplyActivator.getDefault().logError("An error occurred saving the binding.", e);
                                MessageDialog.openError((Shell)ApplyWizard.this.getShell(), (String)"Could not save binding", (String)("An error occurred saving the binding.\nPlease check error log for details.\n\n" + e.getMessage()));
                            }
                        }
                        monitor.done();
                    }
                    catch (Exception e) {
                        ApplyActivator.getDefault().logError("An error occured while saving the selected files", e);
                        MessageDialog.openError((Shell)ApplyWizard.this.getShell(), (String)"An error occured", (String)("An error occured while applying differences:\n" + e.getMessage()));
                        result[0] = false;
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    MPatchModel getMPatch() {
        return this.mpatch;
    }

    void setMPatch(MPatchModel mpatch) {
        this.mpatch = mpatch;
    }

    Resource getModelResource() {
        return this.modelResource;
    }

    void setModelResource(Resource modelResource) {
        this.modelResource = modelResource;
    }

    ResolvedSymbolicReferences getResolvedElements() {
        return this.resolvedElements;
    }

    void setResolvedElements(ResolvedSymbolicReferences resolvedElements) {
        this.resolvedElements = resolvedElements;
    }

    void setEmfdiff(IFile emfdiffFile) {
        this.emfdiffFile = emfdiffFile;
    }

    IFile getEmfdiffFile() {
        return this.emfdiffFile;
    }

    void setNewModelFile(IFile newModelFile) {
        this.newModelFile = newModelFile;
    }

    IFile getNewModelFile() {
        return this.newModelFile;
    }

    void setBindingFile(IFile file) {
        this.bindingFile = file;
    }

    IFile getBindingFile() {
        return this.bindingFile;
    }

    void setModelTarget(EObject modelTarget) {
        this.modelTarget = modelTarget;
    }

    EObject getModelTarget() {
        return this.modelTarget;
    }
}

