/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchResolver;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionManager;
import org.eclipse.emf.compare.mpatch.extension.IMPatchResolution;
import org.eclipse.emf.compare.mpatch.extension.IMPatchResolutionHost;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ApplyWizardResolvePage
extends WizardPage
implements IMPatchResolutionHost {
    final String INFO_TEXT = "Selected changes: %d, to be applied: %d, already applied: %d, not resolved: %d, invalid state: %d";
    private Resource modelResource;
    private MPatchModel mpatch;
    private ResolvedSymbolicReferences resolvedElements;
    private Label infoLabel;
    private Button storeIntermediateModelsCheckbox;
    private Button storeBindingButton;
    private Button respectAppliedButton;
    private final AdapterFactory adapterFactory;
    private final AdapterFactoryLabelProvider labelProvider;
    private IMPatchResolution iDiffResolution;

    public ApplyWizardResolvePage(String pageName, AdapterFactory adapterFactory) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Resolve Symbolic References for the selected model.");
        this.adapterFactory = adapterFactory;
        this.labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        this.iDiffResolution = ExtensionManager.getSelectedResolution();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        Group resolutionContainer = new Group(container, 8);
        resolutionContainer.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        resolutionContainer.setLayout((Layout)new GridLayout(1, false));
        resolutionContainer.setText(this.iDiffResolution.getLabel());
        this.iDiffResolution.buildResolutionGUI((Composite)resolutionContainer, this.adapterFactory);
        this.infoLabel = new Label(container, 0);
        this.infoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.respectAppliedButton = new Button(container, 32);
        this.respectAppliedButton.setText("Detect and bind already applied changes (experimental feature)");
        this.respectAppliedButton.setSelection(false);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.respectAppliedButton.setLayoutData((Object)gd);
        this.respectAppliedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ApplyWizardResolvePage.this.iDiffResolution.refineResolution(ApplyWizardResolvePage.this.resolvedElements, ApplyWizardResolvePage.this.respectApplied(), (IMPatchResolutionHost)ApplyWizardResolvePage.this);
                ApplyWizardResolvePage.this.dialogChanged();
            }
        });
        this.storeIntermediateModelsCheckbox = new Button(container, 32);
        this.storeIntermediateModelsCheckbox.setText("Store intermediate differences and model");
        this.storeIntermediateModelsCheckbox.setSelection(false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.storeIntermediateModelsCheckbox.setLayoutData((Object)gd);
        this.storeBindingButton = new Button(container, 32);
        this.storeBindingButton.setText("Store binding between MPatch and model in a file");
        this.storeBindingButton.setSelection(false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.storeBindingButton.setLayoutData((Object)gd);
        this.setControl((Control)container);
    }

    boolean storeIntermediateModels() {
        return this.storeIntermediateModelsCheckbox.getSelection();
    }

    boolean storeBinding() {
        return this.storeBindingButton.getSelection();
    }

    public boolean respectApplied() {
        return this.respectAppliedButton.getSelection();
    }

    public boolean resolved(ResolvedSymbolicReferences mapping) {
        this.resolvedElements = mapping;
        this.dialogChanged();
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Resource modelResource = ((ApplyWizard)this.getWizard()).getModelResource();
            MPatchModel mpatch = ((ApplyWizard)this.getWizard()).getMPatch();
            EObject modelTarget = ((ApplyWizard)this.getWizard()).getModelTarget();
            if (modelResource != null && mpatch != null) {
                if (modelResource.equals(this.modelResource)) {
                    mpatch.equals(this.mpatch);
                }
                this.modelResource = modelResource;
                this.mpatch = mpatch;
                if (modelTarget == null) {
                    modelTarget = (EObject)modelResource.getContents().get(0);
                }
                if (this.resolvedElements == null || !mpatch.equals(this.resolvedElements.getMPatchModel()) || !modelTarget.equals(this.resolvedElements.getModel())) {
                    this.resolvedElements = MPatchResolver.resolveSymbolicReferences(mpatch, modelTarget, 1, this.respectApplied());
                }
                this.iDiffResolution.refineResolution(this.resolvedElements, this.respectApplied(), (IMPatchResolutionHost)this);
                this.dialogChanged();
            } else {
                this.updateStatus("Please select a valid MPatch and a valid target model before.");
            }
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void dialogChanged() {
        String status;
        String infoText;
        if (this.resolvedElements != null) {
            if (this.resolvedElements.getResolutionByChange().size() > 0) {
                boolean respectApplied = this.respectApplied();
                List<IndepChange> invalidResolutions = MPatchValidator.validateResolutions(this.resolvedElements, respectApplied);
                int unresolved = invalidResolutions.size();
                int total = this.resolvedElements.getResolutionByChange().keySet().size();
                int before = CommonUtils.filterByValue((Map)this.resolvedElements.getValidation(), (Object)ResolvedSymbolicReferences.ValidationResult.STATE_BEFORE).size();
                int after = CommonUtils.filterByValue((Map)this.resolvedElements.getValidation(), (Object)ResolvedSymbolicReferences.ValidationResult.STATE_AFTER).size();
                int invalid = CommonUtils.filterByValue((Map)this.resolvedElements.getValidation(), (Object)ResolvedSymbolicReferences.ValidationResult.STATE_INVALID).size() + CommonUtils.filterByValue((Map)this.resolvedElements.getValidation(), (Object)ResolvedSymbolicReferences.ValidationResult.REFERENCE).size();
                infoText = String.format("Selected changes: %d, to be applied: %d, already applied: %d, not resolved: %d, invalid state: %d", total, before, after, unresolved, invalid);
                if (unresolved == 0 && invalid == 0) {
                    ((ApplyWizard)this.getWizard()).setResolvedElements(this.resolvedElements);
                    status = null;
                } else {
                    status = unresolved > 0 ? "Not all Symbolic References resolved sufficiantly: " + this.labelProvider.getText((Object)invalidResolutions.get(0)) : "Not all changes can be applied to the selected model elements!";
                }
            } else {
                infoText = "Please select some changes.";
                status = "No changes are selected!";
            }
        } else {
            infoText = "There is an error in the resolution of Symbolic References!";
            status = "There is an error in the resolution of Symbolic References!";
        }
        this.infoLabel.setText(infoText);
        this.updateStatus(status);
    }
}

