/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.uml2.diff.UML2DiffEngine;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffExtensionFactory
implements IDiffExtensionFactory {
    private static final UMLPredicate<?> ALWAYS_TRUE = new UMLPredicate<Object>(){

        @Override
        public boolean apply(Object input) {
            return true;
        }
    };
    private UML2DiffEngine fEngine;

    protected AbstractDiffExtensionFactory(UML2DiffEngine engine) {
        this.fEngine = engine;
    }

    protected final UML2DiffEngine getEngine() {
        return this.fEngine;
    }

    @Override
    public DiffElement getParentDiff(DiffElement input, EcoreUtil.CrossReferencer crossReferencer) {
        return (DiffElement)input.eContainer();
    }

    protected final DiffGroup findOrCreateDiffGroup(DiffModel diffModel, EObject elt, EcoreUtil.CrossReferencer crossReferencer) {
        DiffGroup referencingDiffGroup = null;
        List<EObject> ancestors = this.ancestors(elt);
        Iterator<EObject> iterator = ancestors.iterator();
        while (iterator.hasNext()) {
            EObject ancestor;
            EObject parent = ancestor = iterator.next();
            if (referencingDiffGroup == null) {
                parent = this.getEngine().getMatched(ancestor);
            }
            if ((referencingDiffGroup = this.firstReferencingDiffGroup((Collection)crossReferencer.get((Object)parent))) != null) break;
        }
        if (referencingDiffGroup == null) {
            if (diffModel.getRightRoots().contains((Object)elt) || diffModel.getLeftRoots().contains((Object)elt)) {
                if (diffModel.getOwnedElements().isEmpty()) {
                    referencingDiffGroup = DiffFactory.eINSTANCE.createDiffGroup();
                    diffModel.getOwnedElements().add((Object)referencingDiffGroup);
                    referencingDiffGroup.setRightParent(elt);
                    EStructuralFeature.Setting set = ((InternalEObject)referencingDiffGroup).eSetting((EStructuralFeature)DiffPackage.Literals.DIFF_GROUP__RIGHT_PARENT);
                    ArrayList<EStructuralFeature.Setting> values = new ArrayList<EStructuralFeature.Setting>();
                    values.add(set);
                    crossReferencer.put((Object)((EObject)((DiffModel)elt).getRightRoots().get(0)), values);
                } else {
                    referencingDiffGroup = (DiffGroup)diffModel.getOwnedElements().get(0);
                }
            } else {
                referencingDiffGroup = (DiffGroup)diffModel.getOwnedElements().get(0);
            }
        }
        ArrayList<EObject> ancestorsAndSelf = new ArrayList<EObject>(ancestors);
        ancestorsAndSelf.add(0, elt);
        referencingDiffGroup = this.createSubTreeOfDiffGroup(referencingDiffGroup, ancestorsAndSelf, crossReferencer);
        return referencingDiffGroup;
    }

    private DiffGroup createSubTreeOfDiffGroup(DiffGroup referencingDiffGroup, List<EObject> ancestors, EcoreUtil.CrossReferencer crossReferencer) {
        DiffGroup ret = referencingDiffGroup;
        List<EObject> subList = null;
        if (referencingDiffGroup.getRightParent() != null) {
            EObject parent = null;
            int indexParent = ancestors.indexOf(referencingDiffGroup.getRightParent());
            parent = indexParent == -1 ? this.getEngine().getMatched(referencingDiffGroup.getRightParent()) : referencingDiffGroup.getRightParent();
            subList = ancestors.subList(0, ancestors.indexOf(parent));
        } else {
            subList = ancestors;
        }
        ListIterator<EObject> it = subList.listIterator(subList.size());
        while (it.hasPrevious()) {
            EObject previous = it.previous();
            DiffGroup existingDiffGroup = this.firstReferencingDiffGroup((Collection)crossReferencer.get((Object)previous));
            if (existingDiffGroup == null) {
                DiffGroup newGroup = DiffFactory.eINSTANCE.createDiffGroup();
                ret.getSubDiffElements().add((Object)newGroup);
                newGroup.setRightParent(previous);
                newGroup.setRemote(referencingDiffGroup.isRemote());
                ret = newGroup;
                EStructuralFeature.Setting setting = ((InternalEObject)newGroup).eSetting((EStructuralFeature)DiffPackage.Literals.DIFF_GROUP__RIGHT_PARENT);
                ArrayList<EStructuralFeature.Setting> values = new ArrayList<EStructuralFeature.Setting>();
                values.add(setting);
                crossReferencer.put((Object)previous, values);
                continue;
            }
            ret = existingDiffGroup;
        }
        return ret;
    }

    private List<EObject> ancestors(EObject eObject) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            ret.add(eContainer);
            eContainer = eContainer.eContainer();
        }
        return ret;
    }

    private DiffGroup firstReferencingDiffGroup(Collection<EStructuralFeature.Setting> settings) {
        DiffGroup result = null;
        if (settings != null) {
            for (EStructuralFeature.Setting setting : settings) {
                EObject eObject = setting.getEObject();
                if (setting.getEStructuralFeature() != DiffPackage.Literals.DIFF_GROUP__RIGHT_PARENT || !(eObject instanceof DiffGroup)) continue;
                result = (DiffGroup)eObject;
                break;
            }
        }
        return result;
    }

    protected static final List<EObject> getInverseReferences(EObject lookup, EStructuralFeature inFeature) {
        return AbstractDiffExtensionFactory.getInverseReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue());
    }

    protected static final List<EObject> getInverseReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> predicate) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : UML2Util.getInverseReferences((EObject)lookup)) {
            if (setting.getEStructuralFeature() != inFeature || !predicate.apply(setting)) continue;
            ret.add(setting.getEObject());
        }
        return ret;
    }

    protected static final List<EObject> getNonNavigableInverseReferences(EObject lookup, EStructuralFeature inFeature) {
        return AbstractDiffExtensionFactory.getNonNavigableInverseReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue());
    }

    protected static final List<EObject> getNonNavigableInverseReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> predicate) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)lookup)) {
            if (setting.getEStructuralFeature() != inFeature || !predicate.apply(setting)) continue;
            ret.add(setting.getEObject());
        }
        return ret;
    }

    protected final List<DiffElement> findCrossReferences(EObject lookup, EStructuralFeature inFeature, EcoreUtil.CrossReferencer crossReferencer) {
        return this.findCrossReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue(), crossReferencer);
    }

    protected final List<DiffElement> findCrossReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> p, EcoreUtil.CrossReferencer crossReferencer) {
        Collection settings = (Collection)crossReferencer.get((Object)lookup);
        return this.findCrossReferences(inFeature, p, settings);
    }

    private List<DiffElement> findCrossReferences(EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> p, Collection<EStructuralFeature.Setting> settings) {
        ArrayList<DiffElement> ret = new ArrayList<DiffElement>();
        if (settings != null) {
            for (EStructuralFeature.Setting setting : settings) {
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature != inFeature || !p.apply(setting)) continue;
                ret.add((DiffElement)setting.getEObject());
            }
        }
        return ret;
    }

    protected final void hideCrossReferences(EObject lookup, EStructuralFeature inFeature, AbstractDiffExtension hiddingExtension, UMLPredicate<EStructuralFeature.Setting> p, EcoreUtil.CrossReferencer crossReferencer) {
        for (DiffElement diffElement : this.findCrossReferences(lookup, inFeature, p, crossReferencer)) {
            hiddingExtension.getHideElements().add((Object)diffElement);
            ((DiffElement)hiddingExtension).getRequires().add((Object)diffElement);
        }
    }

    protected final void hideCrossReferences(EObject lookup, EStructuralFeature inFeature, AbstractDiffExtension hiddingExtension, EcoreUtil.CrossReferencer crossReferencer) {
        this.hideCrossReferences(lookup, inFeature, hiddingExtension, AbstractDiffExtensionFactory.alwaysTrue(), crossReferencer);
    }

    private static UMLPredicate<EStructuralFeature.Setting> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @Override
    public void fillRequiredDifferences(AbstractDiffExtension diff, EcoreUtil.CrossReferencer crossReferencer) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface UMLPredicate<T> {
        public boolean apply(T var1);
    }
}

