/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementChangeRightTargetMerger
extends DefaultMerger {
    @Override
    public void doApplyInOrigin() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        EObject origin = theDiff.getLeftParent();
        EObject element = theDiff.getRightElement();
        EObject newOne = this.copy(element);
        EReference ref = element.eContainmentFeature();
        if (ref != null) {
            try {
                Object containmentRefVal;
                int expectedIndex = -1;
                if (ref.isMany() && (containmentRefVal = element.eContainer().eGet((EStructuralFeature)ref)) instanceof List) {
                    List listVal = (List)containmentRefVal;
                    expectedIndex = listVal.indexOf(element);
                }
                EFactory.eAdd((EObject)origin, (String)ref.getName(), (Object)newOne, (int)expectedIndex, (boolean)true);
                this.setXMIID(newOne, this.getXMIID(element));
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
            }
        } else if (origin == null && this.getDiffModel().getLeftRoots().size() > 0) {
            ((EObject)this.getDiffModel().getLeftRoots().get(0)).eResource().getContents().add((Object)newOne);
        } else if (origin != null) {
            origin.eResource().getContents().add((Object)newOne);
        }
        TreeIterator siblings = this.getDiffModel().eAllContents();
        while (siblings.hasNext()) {
            ReferenceChange link;
            DiffElement op = (DiffElement)siblings.next();
            if (op instanceof ReferenceChangeRightTarget) {
                link = (ReferenceChangeRightTarget)op;
                if (link.getLeftTarget() == null || link.getLeftTarget() != element) continue;
                link.setRightTarget(newOne);
                continue;
            }
            if (!(op instanceof ReferenceOrderChange) || (link = (ReferenceOrderChange)op).getLeftElement() != origin || link.getReference() != ref) continue;
            ListIterator targetIterator = link.getLeftTarget().listIterator();
            boolean replaced = false;
            while (!replaced && targetIterator.hasNext()) {
                EObject target = (EObject)targetIterator.next();
                if (!target.eIsProxy() || !ModelElementChangeRightTargetMerger.equalProxyURIs(((InternalEObject)target).eProxyURI(), EcoreUtil.getURI((EObject)element))) continue;
                targetIterator.set(newOne);
                replaced = true;
            }
        }
    }

    @Override
    public void doUndoInTarget() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        EObject element = theDiff.getRightElement();
        EObject parent = theDiff.getRightElement().eContainer();
        EcoreUtil.remove((EObject)element);
        this.removeDanglingReferences(parent);
    }

    @Override
    public boolean canUndoInTarget() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        boolean isRightElementNotNull = theDiff.getRightElement() != null;
        return isRightElementNotNull;
    }

    @Override
    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        if (applyInOrigin) {
            return this.diff.getRequires();
        }
        return super.getDependencies(applyInOrigin);
    }
}

