/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.merge.service.MergeFactory;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IMerger {
    private static final String PROXY_SCHEME = "emfCompareProxy";
    private static List<DiffElement> mergedDiffs;
    private static MergedDiffsListener mergedDiffslistener;
    protected DiffElement diff;
    @Deprecated
    protected Resource leftResource;
    @Deprecated
    protected Resource rightResource;

    protected static void resetMergedDiffs() {
        mergedDiffs = null;
    }

    public static boolean isEMFCompareProxy(URI uri) {
        return uri.scheme() != null && uri.scheme().equals(PROXY_SCHEME);
    }

    public static boolean equalProxyURIs(URI uri1, URI uri2) {
        String stringValue1 = uri1.toString();
        String stringValue2 = uri2.toString();
        if (DefaultMerger.isEMFCompareProxy(uri1)) {
            stringValue1 = stringValue1.substring(PROXY_SCHEME.length() + 2);
        }
        if (DefaultMerger.isEMFCompareProxy(uri2)) {
            stringValue2 = stringValue2.substring(PROXY_SCHEME.length() + 2);
        }
        return stringValue1.equals(stringValue2);
    }

    @Override
    public void applyInOrigin() {
        this.mergeRequiredDifferences(true);
        this.doApplyInOrigin();
        this.postProcess();
    }

    protected void doApplyInOrigin() {
    }

    protected void postProcess() {
        this.handleMutuallyDerivedReferences();
        this.ensureXMIIDCopied();
        this.removeFromContainer(this.diff);
    }

    @Override
    public boolean canApplyInOrigin() {
        return true;
    }

    @Override
    public boolean canUndoInTarget() {
        return true;
    }

    @Override
    public void setDiffElement(DiffElement element) {
        this.diff = element;
    }

    @Override
    public void undoInTarget() {
        this.mergeRequiredDifferences(false);
        this.doUndoInTarget();
        this.postProcess();
    }

    protected void doUndoInTarget() {
    }

    protected void cleanDiffGroup(DiffGroup diffGroup) {
        EObject parent;
        if (diffGroup != null && diffGroup.getSubDiffElements().size() == 0 && (parent = diffGroup.eContainer()) instanceof DiffGroup) {
            EcoreUtil.remove((EObject)diffGroup);
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected EObject copy(EObject eObject) {
        EMFCompareEObjectCopier copier = MergeService.getCopier(this.diff);
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        copier.copyXMIIDs();
        return result;
    }

    protected void ensureXMIIDCopied() {
        EMFCompareEObjectCopier copier = MergeService.getCopier(this.diff);
        copier.copyXMIIDs();
    }

    protected DiffModel getDiffModel() {
        EObject container = this.diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }

    protected void removeDanglingReferences(EObject deletedObject) {
    }

    protected void removeFromContainer(DiffElement diffElement) {
        EObject parent = diffElement.eContainer();
        EcoreUtil.remove((EObject)diffElement);
        this.removeDanglingReferences(parent);
        if (parent instanceof ConflictingDiffElement) {
            this.removeFromContainer((DiffElement)parent);
        }
        if (parent instanceof DiffGroup) {
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected void setXMIID(EObject object, String id) {
        if (object != null && object.eResource() instanceof XMIResource) {
            ((XMIResource)object.eResource()).setID(object, id);
        }
    }

    protected void mergeRequiredDifferences(boolean applyInOrigin) {
        if (mergedDiffs == null) {
            mergedDiffs = new ArrayList<DiffElement>();
            if (mergedDiffslistener == null) {
                mergedDiffslistener = new MergedDiffsListener();
                MergeService.addMergeListener(mergedDiffslistener);
            }
        }
        mergedDiffs.add(this.diff);
        for (DiffElement requiredDiff : this.getDependencies(applyInOrigin)) {
            if (requiredDiff.eContainer() == null || mergedDiffs.contains(requiredDiff)) continue;
            IMerger merger = MergeFactory.createMerger(requiredDiff);
            if (applyInOrigin) {
                merger.applyInOrigin();
                continue;
            }
            merger.undoInTarget();
        }
    }

    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        return new ArrayList<DiffElement>();
    }

    private void handleMutuallyDerivedReferences() {
        DiffElement toRemove = null;
        if (this.diff instanceof ReferenceChange) {
            EReference reference = ((ReferenceChange)this.diff).getReference();
            if (reference == EcorePackage.eINSTANCE.getEClass_ESuperTypes()) {
                EObject referenceType = null;
                if (this.diff instanceof ReferenceChangeLeftTarget) {
                    referenceType = ((ReferenceChangeLeftTarget)this.diff).getRightTarget();
                } else if (this.diff instanceof ReferenceChangeRightTarget) {
                    referenceType = ((ReferenceChangeRightTarget)this.diff).getLeftTarget();
                } else if (this.diff instanceof UpdateReference) {
                    referenceType = ((UpdateReference)this.diff).getLeftTarget();
                }
                for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                    if (siblingDiff instanceof ModelElementChangeLeftTarget) {
                        if (!(((ModelElementChangeLeftTarget)siblingDiff).getLeftElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeLeftTarget)siblingDiff).getLeftElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    } else {
                        if (!(siblingDiff instanceof ModelElementChangeRightTarget) || !(((ModelElementChangeRightTarget)siblingDiff).getRightElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeRightTarget)siblingDiff).getRightElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    }
                    break;
                }
            }
        } else if (this.diff instanceof ModelElementChangeLeftTarget && ((ModelElementChangeLeftTarget)this.diff).getLeftElement() instanceof EGenericType) {
            ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getLeftElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeLeftTarget) || ((ReferenceChangeLeftTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeLeftTarget)siblingDiff).getRightTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        } else if (this.diff instanceof ModelElementChangeRightTarget && ((ModelElementChangeRightTarget)this.diff).getRightElement() instanceof EGenericType) {
            ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getRightElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeRightTarget) || ((ReferenceChangeRightTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeRightTarget)siblingDiff).getLeftTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        }
        if (toRemove != null) {
            this.removeFromContainer(toRemove);
        }
    }

    private class MergedDiffsListener
    implements IMergeListener {
        public void mergeDiffEnd(MergeEvent event) {
        }

        public void mergeDiffStart(MergeEvent event) {
        }

        public void mergeOperationEnd(MergeEvent event) {
            DefaultMerger.resetMergedDiffs();
        }

        public void mergeOperationStart(MergeEvent event) {
        }
    }
}

