/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.compare.diagram.provider.IViewLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractLabelProvider
implements IViewLabelProvider {
    protected Map<View, ITextAwareEditPart> registry = new HashMap<View, ITextAwareEditPart>();

    public boolean isManaged(View view) {
        boolean result = true;
        EditPart ep = (EditPart)this.registry.get(view);
        if (ep == null) {
            ep = this.createEditPart(view);
            if (ep instanceof ITextAwareEditPart) {
                this.registry.put(view, (ITextAwareEditPart)ep);
            } else {
                if (ep != null) {
                    ep.deactivate();
                }
                result = false;
            }
        }
        return result;
    }

    public String elementLabel(View view) {
        if (this.isManaged(view)) {
            ITextAwareEditPart ep = this.registry.get(view);
            return this.elementLabel(view, ep);
        }
        return "";
    }

    public void setLabel(View view, String label) {
        if (this.isManaged(view)) {
            ITextAwareEditPart ep = this.registry.get(view);
            ICommand iCommand = this.getDirectEditCommand(ep, label);
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IEditorPart part = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                DiagramEditDomain editDomain = new DiagramEditDomain(part);
                editDomain.getCommandStack().execute((Command)new ICommandProxy(iCommand));
            }
        }
    }

    protected EditPart createEditPart(View view) {
        return null;
    }

    protected String elementLabel(View view, ITextAwareEditPart ep) {
        return "";
    }

    protected EObject getSemanticElement(GraphicalEditPart editPart) {
        if (editPart.getModel() instanceof View) {
            View view = (View)editPart.getModel();
            return view.getElement();
        }
        return null;
    }

    public void clear() {
        this.registry.clear();
    }

    private ICommand getDirectEditCommand(ITextAwareEditPart textEp, String label) {
        EObject model = (EObject)textEp.getModel();
        EObjectAdapterEx elementAdapter = null;
        if (model instanceof View) {
            View lview = (View)model;
            elementAdapter = new EObjectAdapterEx(ViewUtil.resolveSemanticElement((View)lview), lview);
        } else {
            elementAdapter = new EObjectAdapterEx(model, null);
        }
        return textEp.getParser().getParseCommand((IAdaptable)elementAdapter, label, 0);
    }

    class EObjectAdapterEx
    extends EObjectAdapter {
        private View mView;

        public EObjectAdapterEx(EObject element, View pView) {
            super(element);
            this.mView = pView;
        }

        public Object getAdapter(Class adapter) {
            Object result = null;
            Object o = super.getAdapter(adapter);
            if (o != null) {
                result = o;
            } else if (adapter.equals(View.class)) {
                result = this.mView;
            }
            return result;
        }
    }
}

