/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.common.actions.AbstractCompareAction;
import org.eclipse.emf.compare.mpatch.transform.impl.DefaultMPatchGrouping;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class GroupingAction
extends AbstractCompareAction {
    private static final String ACTION_NAME = "Grouping";
    private static final String INPUT_FILE_EXTENSION = "mpatch";
    private static final String OUTPUT_FILE_EXTENSION = "mpatch";
    private static final String JOB_TITLE = "Grouping MPatch...";

    public GroupingAction() {
        super("mpatch", "mpatch", JOB_TITLE);
    }

    protected Status runAction(Resource input, Resource output, IProgressMonitor monitor) {
        Exception exception;
        int code;
        String message;
        block7: {
            message = "";
            code = 0;
            exception = null;
            EObject content = (EObject)input.getContents().get(0);
            if (content instanceof MPatchModel) {
                MPatchModel mpatch = (MPatchModel)content;
                int groups = 0;
                try {
                    groups = DefaultMPatchGrouping.group(mpatch);
                    if (groups > 0) {
                        output.getContents().add((Object)mpatch);
                        try {
                            output.save(null);
                            message = "Grouping successfully finished: " + groups + " groups created.";
                        }
                        catch (IOException e) {
                            code = 4;
                            message = "Could not save grouped MPatch!";
                            exception = e;
                        }
                        break block7;
                    }
                    message = "Grouping finished: nothing was changed.";
                }
                catch (Exception e) {
                    message = "An exception occured during Grouping";
                    exception = e;
                    code = 4;
                }
            } else {
                code = 4;
                message = "Could not find MPatch in:\n\n" + content;
            }
        }
        return new Status(code, "org.eclipse.emf.compare.mpatch.transform", message, (Throwable)exception);
    }
}

