/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.descriptor.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.descriptor.DescriptorPackage;
import org.eclipse.emf.compare.mpatch.descriptor.EMFModelDescriptor;
import org.eclipse.emf.compare.mpatch.descriptor.impl.EAttributeToObjectMapImpl;
import org.eclipse.emf.compare.mpatch.descriptor.impl.EReferenceToDescriptorMapImpl;
import org.eclipse.emf.compare.mpatch.descriptor.impl.EReferenceToElementReferenceMapImpl;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.Activator;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFModelDescriptorImpl
extends EObjectImpl
implements EMFModelDescriptor {
    protected IElementReference selfReference;
    protected EClass type;
    protected EMap<EAttribute, EList<Object>> attributes;
    protected EMap<EReference, EList<EMFModelDescriptor>> subDescriptors;
    protected EMap<EReference, EList<IElementReference>> references;
    protected static final String DESCRIPTOR_URI_EDEFAULT = null;
    protected String descriptorUri = DESCRIPTOR_URI_EDEFAULT;

    protected EMFModelDescriptorImpl() {
    }

    protected EClass eStaticClass() {
        return DescriptorPackage.Literals.EMF_MODEL_DESCRIPTOR;
    }

    public EList<IElementReference> getCrossReferences() {
        EObjectEList references = new EObjectEList(IElementReference.class, (InternalEObject)this, 1);
        for (EList list : this.getReferences().values()) {
            references.addAll((Collection)list);
        }
        return references;
    }

    public EList<IElementReference> getAllCrossReferences() {
        EList<IElementReference> references = this.getCrossReferences();
        for (EList list : this.getSubDescriptors().values()) {
            for (EMFModelDescriptor emfModelDescriptor : list) {
                references.addAll((Collection)emfModelDescriptor.getAllCrossReferences());
            }
        }
        return references;
    }

    public IElementReference getSelfReference() {
        return this.selfReference;
    }

    public NotificationChain basicSetSelfReference(IElementReference newSelfReference, NotificationChain msgs) {
        IElementReference oldSelfReference = this.selfReference;
        this.selfReference = newSelfReference;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSelfReference, (Object)newSelfReference);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setSelfReference(IElementReference newSelfReference) {
        if (newSelfReference != this.selfReference) {
            NotificationChain msgs = null;
            if (this.selfReference != null) {
                msgs = ((InternalEObject)this.selfReference).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newSelfReference != null) {
                msgs = ((InternalEObject)newSelfReference).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetSelfReference(newSelfReference, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newSelfReference, (Object)newSelfReference));
        }
    }

    public EList<String> getDescriptorUris() {
        EDataTypeUniqueEList uris = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 5);
        uris.add((Object)this.getDescriptorUri());
        for (EList list : this.getSubDescriptors().values()) {
            for (EMFModelDescriptor emfModelDescriptor : list) {
                uris.addAll((Collection)emfModelDescriptor.getDescriptorUris());
            }
        }
        return uris;
    }

    public EList<IElementReference> getAllSelfReferences() {
        EObjectEList selves = new EObjectEList(IElementReference.class, (InternalEObject)this, 3);
        LinkedList<EMFModelDescriptorImpl> queue = new LinkedList<EMFModelDescriptorImpl>();
        queue.add(this);
        while (!queue.isEmpty()) {
            EMFModelDescriptor descriptor = (EMFModelDescriptor)queue.poll();
            selves.add((Object)descriptor.getSelfReference());
            for (Collection subModelDescriptors : descriptor.getSubDescriptors().values()) {
                queue.addAll(subModelDescriptors);
            }
        }
        return selves;
    }

    public EList<IModelDescriptor> getSubModelDescriptors() {
        EObjectEList descriptors = new EObjectEList(IModelDescriptor.class, (InternalEObject)this, 4);
        for (List list : this.getSubDescriptors().values()) {
            descriptors.addAll((Collection)list);
        }
        return descriptors;
    }

    public EClass getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (EClass)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public EClass basicGetType() {
        return this.type;
    }

    public void setType(EClass newType) {
        EClass oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public EMap<EAttribute, EList<Object>> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EcoreEMap(DescriptorPackage.Literals.EATTRIBUTE_TO_OBJECT_MAP, EAttributeToObjectMapImpl.class, (InternalEObject)this, 7);
        }
        return this.attributes;
    }

    @Override
    public EMap<EReference, EList<EMFModelDescriptor>> getSubDescriptors() {
        if (this.subDescriptors == null) {
            this.subDescriptors = new EcoreEMap(DescriptorPackage.Literals.EREFERENCE_TO_DESCRIPTOR_MAP, EReferenceToDescriptorMapImpl.class, (InternalEObject)this, 8);
        }
        return this.subDescriptors;
    }

    @Override
    public EMap<EReference, EList<IElementReference>> getReferences() {
        if (this.references == null) {
            this.references = new EcoreEMap(DescriptorPackage.Literals.EREFERENCE_TO_ELEMENT_REFERENCE_MAP, EReferenceToElementReferenceMapImpl.class, (InternalEObject)this, 9);
        }
        return this.references;
    }

    @Override
    public String getDescriptorUri() {
        return this.descriptorUri;
    }

    @Override
    public void setDescriptorUri(String newDescriptorUri) {
        String oldDescriptorUri = this.descriptorUri;
        this.descriptorUri = newDescriptorUri;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDescriptorUri, (Object)this.descriptorUri));
        }
    }

    private EObject applyObject(Map<EMFModelDescriptor, EObject> appliedSubDescriptors, EMap<EObject, IModelDescriptor> submodelElements) {
        EObject object = this.getType().getEPackage().getEFactoryInstance().create(this.getType());
        appliedSubDescriptors.put(this, object);
        submodelElements.put((Object)object, (Object)this);
        for (EReference containment : this.getSubDescriptors().keySet()) {
            for (EMFModelDescriptor subDescriptor : (EList)this.getSubDescriptors().get((Object)containment)) {
                EObject subElement = ((EMFModelDescriptorImpl)subDescriptor).applyObject(appliedSubDescriptors, submodelElements);
                if (ExtEcoreUtils.setStructuralFeature((EObject)object, (EStructuralFeature)containment, (Object)subElement)) continue;
                throw new IllegalArgumentException("Something is wrong here because we could not add a child as defined in the model descriptor!");
            }
        }
        return object;
    }

    public EList<IElementReference> applyCrossReferences(EObject createdObject, EMap<IElementReference, EList<EObject>> resolvedCrossReferences) {
        BasicEList result = new BasicEList();
        for (EReference reference : this.getReferences().keySet()) {
            for (IElementReference symRef : (EList)this.getReferences().get((Object)reference)) {
                try {
                    EList resolvedElements = (EList)resolvedCrossReferences.get((Object)symRef);
                    if (resolvedElements == null || resolvedElements.isEmpty()) {
                        result.add((Object)symRef);
                        continue;
                    }
                    if (ExtEcoreUtils.setStructuralFeature((EObject)createdObject, (EStructuralFeature)reference, (Object)resolvedElements)) continue;
                    result.add((Object)symRef);
                }
                catch (Exception e) {
                    Activator.getDefault().logError("Cross reference restoring failed!", e);
                    result.add((Object)symRef);
                }
            }
        }
        return result;
    }

    private List<EAttribute> applyAttributes(EObject object) {
        ArrayList<EAttribute> result = new ArrayList<EAttribute>();
        for (EAttribute attribute : this.getAttributes().keySet()) {
            Object value;
            if (ExtEcoreUtils.setStructuralFeature((EObject)object, (EStructuralFeature)attribute, (Object)(value = this.getAttributes().get((Object)attribute)))) continue;
            result.add(attribute);
        }
        return result;
    }

    private List<EAttribute> applyAttributes(EObject object, Map<EMFModelDescriptor, EObject> appliedSubDescriptors) {
        List<EAttribute> result = this.applyAttributes(object);
        for (EMFModelDescriptor subDescriptor : appliedSubDescriptors.keySet()) {
            result.addAll(((EMFModelDescriptorImpl)subDescriptor).applyAttributes(appliedSubDescriptors.get(subDescriptor)));
        }
        return result;
    }

    public EMap<EObject, IModelDescriptor> applyStructure(EObject parentModelElement, EReference containment) {
        LinkedHashMap<EMFModelDescriptor, EObject> appliedSubDescriptors = new LinkedHashMap<EMFModelDescriptor, EObject>();
        BasicEMap submodelElements = new BasicEMap();
        EObject createdElement = this.applyObject(appliedSubDescriptors, (EMap<EObject, IModelDescriptor>)submodelElements);
        if (this.applyAttributes(createdElement, appliedSubDescriptors).isEmpty() && ExtEcoreUtils.setStructuralFeature((EObject)parentModelElement, (EStructuralFeature)containment, (Object)createdElement)) {
            return submodelElements;
        }
        System.out.println("EMFModelDescriptor.apply was not successful! We should really add more error handling here!");
        Activator.getDefault().logError("EMFModelDescriptor.apply was not successful! We should really add more error handling here!");
        return null;
    }

    public boolean describesEqual(IModelDescriptor other) {
        if (other == null || !(other instanceof EMFModelDescriptor)) {
            return false;
        }
        EMFModelDescriptor other2 = (EMFModelDescriptor)other;
        if (this.getType() == null || !this.getType().equals(other2.getType())) {
            return false;
        }
        if (this.getReferences().size() != other2.getReferences().size()) {
            return false;
        }
        if (this.getAttributes().size() != other2.getAttributes().size()) {
            return false;
        }
        if (this.getSubDescriptors().size() != other2.getSubDescriptors().size()) {
            return false;
        }
        for (EReference ref : this.getReferences().keySet()) {
            if (((EList)this.getReferences().get((Object)ref)).size() != ((EList)other2.getReferences().get((Object)ref)).size()) {
                return false;
            }
            block1: for (IElementReference crossRef1 : (EList)this.getReferences().get((Object)ref)) {
                for (IElementReference crossRef2 : (EList)other2.getReferences().get((Object)ref)) {
                    if (crossRef1 != null && crossRef1.resolvesEqual(crossRef2)) continue block1;
                }
                return false;
            }
        }
        for (EAttribute attr : this.getAttributes().keySet()) {
            if (((EList)this.getAttributes().get((Object)attr)).size() != ((EList)other2.getAttributes().get((Object)attr)).size()) {
                return false;
            }
            block4: for (Object value1 : (EList)this.getAttributes().get((Object)attr)) {
                for (Object value2 : (EList)other2.getAttributes().get((Object)attr)) {
                    if (value1 != null && value1.equals(value2)) continue block4;
                }
                return false;
            }
        }
        for (EReference ref : this.getSubDescriptors().keySet()) {
            if (((EList)this.getSubDescriptors().get((Object)ref)).size() != ((EList)other2.getSubDescriptors().get((Object)ref)).size()) {
                return false;
            }
            block7: for (IModelDescriptor subMd1 : (EList)this.getSubDescriptors().get((Object)ref)) {
                for (IModelDescriptor subMd2 : (EList)other2.getSubDescriptors().get((Object)ref)) {
                    if (subMd1.describesEqual(subMd2)) continue block7;
                }
                return false;
            }
        }
        return true;
    }

    public EMap<EObject, IModelDescriptor> isDescriptorFor(EObject element, boolean checkAttributes) {
        BasicEMap descriptorMap = new BasicEMap();
        if (this.isDescriptorFor(element, (EMap<EObject, IModelDescriptor>)descriptorMap, checkAttributes)) {
            return descriptorMap;
        }
        return null;
    }

    private boolean isDescriptorFor(EObject element, EMap<EObject, IModelDescriptor> descriptorMap, boolean checkAttributes) {
        if (!element.eClass().equals(this.getType())) {
            return false;
        }
        if (checkAttributes && !this.checkAttributes(element)) {
            return false;
        }
        for (EReference subReference : this.getSubDescriptors().keySet()) {
            Object child;
            List<Object> children = subReference.isMany() ? (List<Object>)element.eGet((EStructuralFeature)subReference) : ((child = element.eGet((EStructuralFeature)subReference)) == null ? null : Collections.singletonList(child));
            ArrayList subDescriptors = new ArrayList((Collection)this.getSubDescriptors().get((Object)subReference));
            if (subDescriptors.isEmpty() && (children == null || children.isEmpty())) continue;
            if (subDescriptors.isEmpty() ^ (children == null || children.isEmpty())) {
                return false;
            }
            if (children == null || children.size() != subDescriptors.size()) {
                return false;
            }
            block1: for (Object child2 : children) {
                int i = 0;
                while (i < subDescriptors.size()) {
                    EMFModelDescriptorImpl subDescriptor = (EMFModelDescriptorImpl)subDescriptors.get(i);
                    if (subDescriptor.isDescriptorFor((EObject)child2, descriptorMap, checkAttributes)) {
                        subDescriptors.remove(i);
                        continue block1;
                    }
                    ++i;
                }
                return false;
            }
        }
        descriptorMap.put((Object)element, (Object)this);
        return true;
    }

    private boolean checkAttributes(EObject element) {
        HashSet<EAttribute> checkedAttributes = new HashSet<EAttribute>();
        for (EAttribute eAttribute : this.getAttributes().keySet()) {
            checkedAttributes.add(eAttribute);
            EList describedValue = (EList)this.getAttributes().get((Object)eAttribute);
            Object actualValue = element.eGet((EStructuralFeature)eAttribute);
            if (actualValue == null && (describedValue == null || describedValue.isEmpty())) continue;
            if (actualValue == null ^ (describedValue == null || describedValue.isEmpty())) {
                return false;
            }
            if (eAttribute.isMany()) {
                List actualList = (List)actualValue;
                if (actualList == null || describedValue == null || actualList.size() != describedValue.size()) {
                    return false;
                }
                for (Object object : actualList) {
                    if (describedValue.contains(object)) continue;
                    return false;
                }
                continue;
            }
            if (actualValue == null && (describedValue == null || describedValue.isEmpty()) || describedValue != null && actualValue != null && describedValue.size() == 1 && actualValue.equals(describedValue.get(0))) continue;
            return false;
        }
        ArrayList toCheck = new ArrayList(element.eClass().getEAllAttributes());
        toCheck.removeAll(checkedAttributes);
        for (EAttribute eAttribute : toCheck) {
            if (!MPatchUtil.isRelevantFeature((EStructuralFeature)eAttribute)) continue;
            Object value = element.eGet((EStructuralFeature)eAttribute);
            Object defaultValue = eAttribute.getDefaultValue();
            if (eAttribute.isMany()) {
                if (value == null || ((List)value).size() == 0) {
                    if (defaultValue == null || !(defaultValue instanceof List) || ((List)defaultValue).isEmpty()) continue;
                    return false;
                }
                if (!(defaultValue instanceof List)) continue;
                List defaultValues = (List)defaultValue;
                List actualValues = (List)value;
                if (defaultValues.size() != actualValues.size()) {
                    return false;
                }
                for (Object object : actualValues) {
                    if (defaultValues.contains(object)) continue;
                    return false;
                }
                for (Object object : defaultValues) {
                    if (actualValues.contains(object)) continue;
                    return false;
                }
                continue;
            }
            if (!(value == null ? defaultValue != null : !value.equals(defaultValue))) continue;
            return false;
        }
        return true;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetSelfReference(null, msgs);
            }
            case 7: {
                return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getSubDescriptors()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCrossReferences();
            }
            case 1: {
                return this.getAllCrossReferences();
            }
            case 2: {
                return this.getSelfReference();
            }
            case 3: {
                return this.getAllSelfReferences();
            }
            case 4: {
                return this.getSubModelDescriptors();
            }
            case 5: {
                return this.getDescriptorUris();
            }
            case 6: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 7: {
                if (coreType) {
                    return this.getAttributes();
                }
                return this.getAttributes().map();
            }
            case 8: {
                if (coreType) {
                    return this.getSubDescriptors();
                }
                return this.getSubDescriptors().map();
            }
            case 9: {
                if (coreType) {
                    return this.getReferences();
                }
                return this.getReferences().map();
            }
            case 10: {
                return this.getDescriptorUri();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setSelfReference((IElementReference)newValue);
                return;
            }
            case 6: {
                this.setType((EClass)newValue);
                return;
            }
            case 7: {
                ((EStructuralFeature.Setting)this.getAttributes()).set(newValue);
                return;
            }
            case 8: {
                ((EStructuralFeature.Setting)this.getSubDescriptors()).set(newValue);
                return;
            }
            case 9: {
                ((EStructuralFeature.Setting)this.getReferences()).set(newValue);
                return;
            }
            case 10: {
                this.setDescriptorUri((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setSelfReference(null);
                return;
            }
            case 6: {
                this.setType(null);
                return;
            }
            case 7: {
                this.getAttributes().clear();
                return;
            }
            case 8: {
                this.getSubDescriptors().clear();
                return;
            }
            case 9: {
                this.getReferences().clear();
                return;
            }
            case 10: {
                this.setDescriptorUri(DESCRIPTOR_URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getCrossReferences().isEmpty();
            }
            case 1: {
                return !this.getAllCrossReferences().isEmpty();
            }
            case 2: {
                return this.selfReference != null;
            }
            case 3: {
                return !this.getAllSelfReferences().isEmpty();
            }
            case 4: {
                return !this.getSubModelDescriptors().isEmpty();
            }
            case 5: {
                return !this.getDescriptorUris().isEmpty();
            }
            case 6: {
                return this.type != null;
            }
            case 7: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 8: {
                return this.subDescriptors != null && !this.subDescriptors.isEmpty();
            }
            case 9: {
                return this.references != null && !this.references.isEmpty();
            }
            case 10: {
                return DESCRIPTOR_URI_EDEFAULT == null ? this.descriptorUri != null : !DESCRIPTOR_URI_EDEFAULT.equals(this.descriptorUri);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (descriptorUri: ");
        result.append(this.descriptorUri);
        result.append(')');
        return result.toString();
    }
}

