/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.mpatch.common.util.CommonGmfUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    public static final int DIFF_EMPTY = 1;
    public static final int DIFF_ORDERINGS = 2;

    public static IFile createNewIFile(URI referenceURI, String fileName) {
        Path referencePath = new Path(referenceURI.toPlatformString(true));
        IPath path = referencePath.removeLastSegments(1);
        IPath newPath = path.append(fileName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
        return file;
    }

    public static IFile createNewIFile(IFile referenceFile, String fileName) {
        IPath path = referenceFile.getFullPath().removeLastSegments(1);
        IPath newPath = path.append(fileName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
        return file;
    }

    public static EObject getModelFromEmfdiff(ComparisonSnapshot emfdiff, boolean leftModel) {
        if (emfdiff instanceof ComparisonResourceSnapshot) {
            EList roots;
            ComparisonResourceSnapshot resourceSnapshot = (ComparisonResourceSnapshot)emfdiff;
            EList eList = roots = leftModel ? resourceSnapshot.getMatch().getLeftRoots() : resourceSnapshot.getMatch().getRightRoots();
            if (roots.size() > 1) {
                throw new UnsupportedOperationException("This is not supported yet. Please implement it!");
            }
            if (roots.size() == 0) {
                return null;
            }
            return (EObject)roots.get(0);
        }
        if (emfdiff instanceof ComparisonResourceSetSnapshot) {
            EList roots;
            ComparisonResourceSetSnapshot resourceSetSnapshot = (ComparisonResourceSetSnapshot)emfdiff;
            if (resourceSetSnapshot.getMatchResourceSet().getMatchModels().size() > 1) {
                throw new UnsupportedOperationException("This is not supported yet. Please implement it!");
            }
            EList eList = roots = leftModel ? ((MatchModel)resourceSetSnapshot.getMatchResourceSet().getMatchModels().get(0)).getLeftRoots() : ((MatchModel)resourceSetSnapshot.getMatchResourceSet().getMatchModels().get(0)).getRightRoots();
            if (roots.size() > 1) {
                throw new UnsupportedOperationException("This is not supported yet. Please implement it!");
            }
            if (roots.size() == 0) {
                return null;
            }
            return (EObject)roots.get(0);
        }
        throw new UnsupportedOperationException("Invalid emfdiff type detected!");
    }

    public static ComparisonResourceSnapshot createEmfdiff(EObject leftModel, EObject rightModel, boolean useIdsIfAvailable) {
        MatchModel matchModel = null;
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("match.ignore.id", !useIdsIfAvailable);
            options.put("match.ignore.xmi.id", !useIdsIfAvailable);
            options.put("match.distinct.metamodels", false);
            matchModel = MatchService.doMatch((EObject)leftModel, (EObject)rightModel, options);
        }
        catch (InterruptedException interruptedException) {}
        DiffModel diffModel = DiffService.doDiff(matchModel, (boolean)false);
        return CommonUtils.wrapInComparisonSnapshot(matchModel, diffModel);
    }

    public static ComparisonResourceSnapshot createEmfdiff(EObject leftModel, EObject rightModel) {
        MatchModel matchModel = null;
        try {
            matchModel = MatchService.doMatch((EObject)leftModel, (EObject)rightModel, Collections.emptyMap());
        }
        catch (InterruptedException interruptedException) {}
        DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel, (boolean)false);
        return CommonUtils.wrapInComparisonSnapshot(matchModel, diffModel);
    }

    private static ComparisonResourceSnapshot wrapInComparisonSnapshot(MatchModel matchModel, DiffModel diffModel) {
        ComparisonResourceSnapshot comparison = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        comparison.setDiff(diffModel);
        comparison.setMatch(matchModel);
        comparison.setDate(new Date());
        return comparison;
    }

    public static Collection<DiffElement> analyzeDiff(ComparisonSnapshot snapshot, int criteria) {
        ArrayList<DiffElement> violations = new ArrayList<DiffElement>();
        TreeIterator i = snapshot.eAllContents();
        block4: while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof DiffElement)) continue;
            switch (criteria) {
                case 1: {
                    if (obj instanceof DiffGroup) break;
                    violations.add((DiffElement)obj);
                    break;
                }
                case 2: {
                    if (obj instanceof DiffGroup || obj instanceof ReferenceOrderChange || obj instanceof AttributeOrderChange) continue block4;
                    violations.add((DiffElement)obj);
                }
            }
        }
        return violations;
    }

    public static URI getCurrentEditorFileInputUri() {
        block9: {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor != null) {
                try {
                    IEditorInput editorInput = editor.getEditorInput();
                    if (editorInput instanceof FileEditorInput) {
                        URI uri;
                        ResourceSetImpl resourceSet;
                        Resource resource;
                        IFile file = ((FileEditorInput)editorInput).getFile();
                        if (file != null && (resource = (resourceSet = new ResourceSetImpl()).getResource(uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)) != null && !resource.getContents().isEmpty()) {
                            EObject root = (EObject)resource.getContents().get(0);
                            EObject element = CommonUtils.getDiagramElement(root);
                            if (element != null && element.eResource() != null) {
                                URI uri2 = element.eResource().getURI();
                                return uri2;
                            }
                            return uri;
                        }
                        break block9;
                    }
                    try {
                        URI uri = CommonGmfUtils.getUriFromEditorInput(editorInput);
                        if (uri != null) {
                            return uri;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static Map<EObject, EObject> getMatchingObjects(EObject obj1, EObject obj2) {
        MatchModel match;
        if (obj1 == null || obj2 == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("match.ignore.id", true);
        options.put("match.ignore.xmi.id", true);
        options.put("match.distinct.metamodels", false);
        try {
            match = MatchService.doContentMatch((EObject)obj1, (EObject)obj2, options);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Comparing two EObjects failed!", e);
        }
        HashMap<EObject, EObject> result = new HashMap<EObject, EObject>();
        LinkedList queue = new LinkedList();
        queue.addAll(match.getMatchedElements());
        while (!queue.isEmpty()) {
            MatchElement matchElement = (MatchElement)queue.poll();
            Match2Elements match2Elements = (Match2Elements)matchElement;
            result.put(match2Elements.getLeftElement(), match2Elements.getRightElement());
            result.put(match2Elements.getRightElement(), match2Elements.getLeftElement());
            queue.addAll(matchElement.getSubMatchElements());
        }
        return result;
    }

    private static EObject getDiagramElement(EObject diagram) {
        Object object;
        EStructuralFeature feature;
        EClass eClass = diagram.eClass();
        if (eClass == null) {
            return null;
        }
        if ("org.eclipse.gmf.runtime.notation.Diagram".equals(eClass.getInstanceClassName()) && (feature = eClass.getEStructuralFeature("element")) != null && (object = diagram.eGet(feature)) instanceof EObject) {
            return (EObject)object;
        }
        return null;
    }

    public static <T extends Appendable> T join(String[] src, CharSequence pattern, T dst) throws IOException {
        int i = 0;
        while (i < src.length) {
            if (i > 0) {
                dst.append(pattern);
            }
            dst.append(src[i]);
            ++i;
        }
        return dst;
    }

    public static String join(String[] src, CharSequence pattern) {
        try {
            return CommonUtils.join(src, pattern, new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new Error("StringBuilder should not throw IOExceptions!");
        }
    }

    public static String join(List<? extends String> src, CharSequence pattern) {
        try {
            return CommonUtils.join(src.toArray(new String[src.size()]), pattern, new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new Error("StringBuilder should not throw IOExceptions!");
        }
    }

    public static <K, V> List<K> filterByValue(Map<K, V> map, V value) {
        ArrayList<K> result = new ArrayList<K>();
        if (value != null) {
            for (K key : map.keySet()) {
                if (!value.equals(map.get(key))) continue;
                result.add(key);
            }
        }
        return result;
    }
}

