/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ui.viewer.menus.ContextualMenuDescriptor;
import org.eclipse.emf.compare.ui.viewer.menus.IContextualMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContextualMenuRegistry {
    INSTANCE;

    public static final String CONTEXTUAL_MENU_EXTENSION_POINT = "org.eclipse.emf.compare.ui.contextual.menus";
    private static final String SEPARATOR = ";";
    private final Map<String, ContextualMenuDescriptor> storage = new HashMap<String, ContextualMenuDescriptor>();

    public void parseInitialContributions() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(CONTEXTUAL_MENU_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                this.addExtension(configElements[j]);
                ++j;
            }
            ++i;
        }
    }

    public synchronized List<ContextualMenuDescriptor> getDescriptors() {
        return new ArrayList<ContextualMenuDescriptor>(this.storage.values());
    }

    public synchronized void addExtension(IConfigurationElement element) {
        ContextualMenuDescriptor desc = new ContextualMenuDescriptor(element);
        this.storage.put(desc.getID(), desc);
    }

    public synchronized void removeExtension(IConfigurationElement element) {
        ContextualMenuDescriptor desc = new ContextualMenuDescriptor(element);
        this.storage.remove(desc.getID());
    }

    public synchronized void clearRegistry() {
        this.storage.clear();
    }

    public ContextualMenuDescriptor getDescriptor(String id) {
        return this.storage.get(id);
    }

    public String getDescriptors(List<ContextualMenuDescriptor> descriptors) {
        boolean firstElement = true;
        StringBuffer result = new StringBuffer();
        for (ContextualMenuDescriptor desc : descriptors) {
            if (!firstElement) {
                result.append(SEPARATOR);
            }
            result.append(desc.getID());
            firstElement = false;
        }
        return result.toString();
    }

    public List<ContextualMenuDescriptor> getDescriptors(String descriptors) {
        String[] values;
        ArrayList<ContextualMenuDescriptor> result = new ArrayList<ContextualMenuDescriptor>();
        String[] stringArray = values = descriptors.split(SEPARATOR);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            ContextualMenuDescriptor desc = this.getDescriptor(value);
            if (desc != null) {
                result.add(desc);
            }
            ++n2;
        }
        return result;
    }

    public List<IContextualMenu> getFilters(String descriptors) {
        ArrayList<IContextualMenu> result = new ArrayList<IContextualMenu>();
        for (ContextualMenuDescriptor desc : this.getDescriptors(descriptors)) {
            result.add(desc.getExtension());
        }
        return result;
    }
}

