/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.impl.AbstractReferenceCreator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.util.QvtlibHelper;
import org.eclipse.emf.compare.mpatch.symrefs.ElementSetReference;
import org.eclipse.emf.compare.mpatch.symrefs.OclCondition;
import org.eclipse.emf.compare.mpatch.symrefs.SymrefsFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSetReferenceCreator
extends AbstractReferenceCreator {
    static final Collection<String> PRIMITIVE_TYPES = Arrays.asList("java.lang.String", "int", "java.lang.Integer", "boolean", "java.lang.Boolean", "long", "java.lang.Long", "byte", "java.lang.Byte", "char", "java.lang.Character", "short", "java.lang.Short");

    @Override
    public IElementReference createSymbolicReference(EObject self) {
        return this.create(self, 1);
    }

    public String getLabel() {
        return "Condition-based";
    }

    public ElementSetReference create(EObject self, int contextDepth) {
        ElementSetReference ref = SymrefsFactory.eINSTANCE.createElementSetReference();
        ref.setType(self.eClass());
        ref.setUriReference(QvtlibHelper.getUriString(self));
        ref.setLabel(QvtlibHelper.getLabel(self));
        ref.getConditions().add((Object)this.createOclCondition(self));
        if (contextDepth > 0 && self.eContainer() != null) {
            ref.setContext(this.create(self.eContainer(), contextDepth - 1));
        }
        return ref;
    }

    protected OclCondition createOclCondition(EObject self) {
        EClass eclass = self.eClass();
        String expr = "";
        for (EAttribute attribute : eclass.getEAllAttributes()) {
            if (!this.isRelevantAttribute(attribute)) continue;
            expr = String.valueOf(expr) + (expr.length() > 0 ? " and " : "") + this.eAttributeToCondition(attribute, self.eGet((EStructuralFeature)attribute));
        }
        OclCondition condition = SymrefsFactory.eINSTANCE.createOclCondition();
        condition.setExpression(expr);
        return condition;
    }

    protected boolean isRelevantAttribute(EAttribute eAttribute) {
        if (eAttribute.getEType() instanceof EEnum) {
            return true;
        }
        return PRIMITIVE_TYPES.contains(eAttribute.getEType().getInstanceClassName()) && !eAttribute.isDerived();
    }

    protected String eAttributeToCondition(EAttribute eAttribute, Object obj) {
        if (obj instanceof List) {
            return eAttribute.getName() + "->asSequence() = " + this.listAttributeToString((List)obj);
        }
        if (obj instanceof Enum) {
            Class declaringClass = ((Enum)obj).getDeclaringClass();
            return eAttribute.getName() + " = " + declaringClass.getSimpleName() + "::\"" + ((Enum)obj).toString() + "\"";
        }
        if (obj == null) {
            return eAttribute.getName() + "->asSet()->isEmpty()";
        }
        return eAttribute.getName() + " = " + this.primitiveAttributeToString(obj);
    }

    protected String listAttributeToString(List<?> list) {
        String result = "";
        for (Object o : list) {
            result = o instanceof List ? String.valueOf(result) + (result.length() == 0 ? "" : ",") + this.listAttributeToString((List)o) : String.valueOf(result) + (result.length() == 0 ? "" : ",") + this.primitiveAttributeToString(o);
        }
        return "Sequence{" + result + "}";
    }

    protected String primitiveAttributeToString(Object obj) {
        if (obj == null) {
            return "OclVoid";
        }
        if (obj instanceof String) {
            return "'" + (String)obj + "'";
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "true" : "false";
        }
        if (obj instanceof EObject) {
            return "<EObject is not yet supported as attribute type!>";
        }
        return "<Type not supported: " + obj.getClass().getName() + ">";
    }
}

