/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplyWizardSummaryPage
extends WizardPage {
    private Text diffUriText;
    private Text modelUriText;
    private Text newModelUriText;
    private Text emfdiffUriText;
    private Text bindingUriText;
    private Label resolvedLabel;
    private Button reviewDiffApplicationButton;
    private static final String RESOLVED_LABEL_TEXT = " changes are selected.";

    public ApplyWizardSummaryPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Select a place where the information is stored.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        new Label(container, 0).setText("MPatch:");
        this.diffUriText = new Text(container, 2060);
        GridData gd = new GridData(768);
        this.diffUriText.setLayoutData((Object)gd);
        this.diffUriText.setEditable(false);
        new Label(container, 0).setText("Apply to model:");
        this.modelUriText = new Text(container, 2060);
        gd = new GridData(768);
        this.modelUriText.setLayoutData((Object)gd);
        this.modelUriText.setEditable(false);
        new Label(container, 0).setText("Save new model:");
        this.newModelUriText = new Text(container, 2060);
        gd = new GridData(768);
        this.newModelUriText.setLayoutData((Object)gd);
        this.newModelUriText.setEditable(false);
        new Label(container, 0).setText("Save emfdiff:");
        this.emfdiffUriText = new Text(container, 2060);
        gd = new GridData(768);
        this.emfdiffUriText.setLayoutData((Object)gd);
        this.emfdiffUriText.setEditable(false);
        new Label(container, 0).setText("Save binding:");
        this.bindingUriText = new Text(container, 2060);
        gd = new GridData(768);
        this.bindingUriText.setLayoutData((Object)gd);
        this.bindingUriText.setEditable(false);
        new Label(container, 0).setText("Reference resolution:");
        this.resolvedLabel = new Label(container, 0);
        gd = new GridData(768);
        this.resolvedLabel.setLayoutData((Object)gd);
        this.reviewDiffApplicationButton = new Button(container, 32);
        this.reviewDiffApplicationButton.setText("Review result with EMF Compare");
        this.reviewDiffApplicationButton.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.reviewDiffApplicationButton.setLayoutData((Object)gd);
        this.initialize();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void initialize() {
        MPatchModel diff = ((ApplyWizard)this.getWizard()).getMPatch();
        Resource model = ((ApplyWizard)this.getWizard()).getModelResource();
        IFile newModelFile = ((ApplyWizard)this.getWizard()).getNewModelFile();
        IFile emfdiffFile = ((ApplyWizard)this.getWizard()).getEmfdiffFile();
        IFile bindingFile = ((ApplyWizard)this.getWizard()).getBindingFile();
        ResolvedSymbolicReferences resolved = ((ApplyWizard)this.getWizard()).getResolvedElements();
        this.newModelUriText.setEnabled(((ApplyWizard)this.getWizard()).saveIntermediateFiles);
        this.emfdiffUriText.setEnabled(((ApplyWizard)this.getWizard()).saveIntermediateFiles);
        this.bindingUriText.setEnabled(((ApplyWizard)this.getWizard()).saveBinding);
        this.diffUriText.setText(diff == null ? "" : diff.eResource().getURI().toString());
        this.modelUriText.setText(model == null ? "" : model.getURI().toString());
        if (((ApplyWizard)this.getWizard()).saveIntermediateFiles) {
            this.newModelUriText.setText(newModelFile == null ? "" : URI.createPlatformResourceURI((String)newModelFile.getFullPath().toString(), (boolean)true).toString());
            this.emfdiffUriText.setText(emfdiffFile == null ? "" : URI.createPlatformResourceURI((String)emfdiffFile.getFullPath().toString(), (boolean)true).toString());
        }
        if (((ApplyWizard)this.getWizard()).saveBinding) {
            this.bindingUriText.setText(bindingFile == null ? "" : URI.createPlatformResourceURI((String)bindingFile.getFullPath().toString(), (boolean)true).toString());
        }
        this.resolvedLabel.setText(resolved == null ? "" : String.valueOf(resolved.getResolutionByChange().keySet().size()) + " / " + this.countChanges(resolved.getMPatchModel()) + " " + RESOLVED_LABEL_TEXT);
        this.dialogChanged();
    }

    private int countChanges(MPatchModel mpatch) {
        int counter = 0;
        LinkedList queue = new LinkedList();
        queue.addAll(mpatch.getChanges());
        while (!queue.isEmpty()) {
            IndepChange change = (IndepChange)queue.poll();
            if (change instanceof ChangeGroup) {
                queue.addAll(((ChangeGroup)change).getSubChanges());
                continue;
            }
            ++counter;
        }
        return counter;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    boolean reviewDiffApplication() {
        return this.reviewDiffApplicationButton.getSelection();
    }

    private void dialogChanged() {
        if (this.diffUriText.getText().trim().length() == 0) {
            this.updateStatus("MPatch is not set!");
        } else if (this.modelUriText.getText().trim().length() == 0) {
            this.updateStatus("Model is not set!");
        } else if (((ApplyWizard)this.getWizard()).saveIntermediateFiles && this.emfdiffUriText.getText().trim().length() == 0) {
            this.updateStatus("Emfdiff is not set!");
        } else if (((ApplyWizard)this.getWizard()).saveIntermediateFiles && this.newModelUriText.getText().trim().length() == 0) {
            this.updateStatus("New model is not set!");
        } else if (((ApplyWizard)this.getWizard()).saveBinding && this.bindingUriText.getText().trim().length() == 0) {
            this.updateStatus("Binding file is not set!");
        } else {
            this.updateStatus(null);
        }
    }
}

