/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.binding.AddElementChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.AddReferenceChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.AttributeChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.BindingFactory;
import org.eclipse.emf.compare.mpatch.binding.ChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.ElementChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.MoveElementChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.NoteElement;
import org.eclipse.emf.compare.mpatch.binding.RemoveElementChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.RemoveReferenceChangeBinding;
import org.eclipse.emf.compare.mpatch.binding.SubModelBinding;
import org.eclipse.emf.compare.mpatch.binding.UpdateReferenceChangeBinding;
import org.eclipse.emf.compare.mpatch.extension.IMPatchApplication;
import org.eclipse.emf.compare.mpatch.extension.MPatchApplicationResult;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.provider.MPatchItemProviderAdapterFactory;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMPatchApplier
implements IMPatchApplication {
    protected static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected static final ComposedAdapterFactory ADAPTER_FACTORY = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private static final String LABEL = "Generic Application Engine";
    protected List<IndepChange> orderedChanges;
    protected final EObject deletionContainer = ExtEcoreUtils.wrapInGenericContainer(Collections.emptyList());
    protected final EList<EObject> deletedSubmodels = (EList)this.deletionContainer.eGet(this.deletionContainer.eClass().getEStructuralFeature("children"));
    protected final Collection<EObject> flatDeletions = new ArrayList<EObject>();
    protected final Map<EObject, IndepAddRemElementChange> addedElementToChangeMap = new LinkedHashMap<EObject, IndepAddRemElementChange>();
    protected final Map<IElementReference, Set<EObject>> addedElementSymrefToElementsMap = new LinkedHashMap<IElementReference, Set<EObject>>();
    protected final Map<EObject, IModelDescriptor> addedElementToModelDescriptorMap = new LinkedHashMap<EObject, IModelDescriptor>();
    protected final Map<EObject, SubModelBinding> addedElementToSubModelBindingMap = new LinkedHashMap<EObject, SubModelBinding>();
    protected Map<Integer, Boolean> options;
    boolean respectApplied;

    static {
        ADAPTER_FACTORY.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        ADAPTER_FACTORY.addAdapterFactory((AdapterFactory)new MPatchItemProviderAdapterFactory());
        ADAPTER_FACTORY.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        ADAPTER_FACTORY.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public String getLabel() {
        return LABEL;
    }

    public MPatchApplicationResult applyMPatch(ResolvedSymbolicReferences mapping, Map<Integer, Boolean> options) {
        boolean forward;
        LinkedList<IndepChange> successfulChanges = new LinkedList<IndepChange>();
        LinkedList<IndepChange> boundChanges = new LinkedList<IndepChange>();
        LinkedList<IndepChange> failedReferenceChanges = new LinkedList<IndepChange>();
        LinkedList<IndepChange> failedChanges = new LinkedList<IndepChange>();
        this.addedElementToChangeMap.clear();
        this.addedElementSymrefToElementsMap.clear();
        this.addedElementToModelDescriptorMap.clear();
        this.deletedSubmodels.clear();
        mapping.getMPatchModelBinding().getChangeBindings().clear();
        this.addedElementToSubModelBindingMap.clear();
        this.options = options;
        this.respectApplied = options.get(OPTION_MATCH_APPLIED_CHANGES) == null ? false : options.get(OPTION_MATCH_APPLIED_CHANGES);
        boolean bl = forward = mapping.getDirection() == 1;
        if (!forward) {
            throw new UnsupportedOperationException("Only forward application of MPatch is supported so far! Please use the Reversal transformation of MPatch for reversing changes.");
        }
        this.orderedChanges = MPatchValidator.orderChanges(mapping.getResolutionByChange().keySet(), (boolean)forward);
        for (IndepChange indepChange : this.orderedChanges) {
            try {
                switch (this.applyChange(indepChange, mapping)) {
                    case SUCCESSFUL: {
                        successfulChanges.add(indepChange);
                        break;
                    }
                    case BOUND: {
                        boundChanges.add(indepChange);
                        break;
                    }
                    case REFERENCES: {
                        failedReferenceChanges.add(indepChange);
                        break;
                    }
                    case FAILED: {
                        failedChanges.add(indepChange);
                    }
                }
            }
            catch (Exception exception) {
                failedChanges.add(indepChange);
            }
        }
        this.restoreCrossReferences(successfulChanges, failedReferenceChanges, mapping);
        MPatchApplicationResult.ApplicationStatus status = failedChanges.isEmpty() ? (failedReferenceChanges.isEmpty() ? MPatchApplicationResult.ApplicationStatus.SUCCESSFUL : MPatchApplicationResult.ApplicationStatus.REFERENCES) : MPatchApplicationResult.ApplicationStatus.FAILURE;
        MPatchApplicationResult result = new MPatchApplicationResult(status, successfulChanges, boundChanges, failedReferenceChanges, failedChanges);
        if (options.get(OPTION_STORE_BINDING).booleanValue()) {
            this.addNotesToBinding(mapping, result);
        }
        return result;
    }

    private void addNotesToBinding(ResolvedSymbolicReferences mapping, MPatchApplicationResult result) {
        AdapterFactoryLabelProvider labels = new AdapterFactoryLabelProvider((AdapterFactory)ADAPTER_FACTORY);
        BindingFactory factory = BindingFactory.eINSTANCE;
        factory.createNote((NoteElement)mapping.getMPatchModelBinding(), "Binding was created on " + TIME_FORMAT.format(new Date()) + " by '" + LABEL + "'.\n" + "Application result:\n" + result.getMessage((AdapterFactory)ADAPTER_FACTORY));
        for (ChangeBinding changeBinding : mapping.getMPatchModelBinding().getChangeBindings()) {
            UpdateReferenceChangeBinding updateReferenceChangeBinding;
            ElementChangeBinding elementChangeBinding3;
            factory.createNote((NoteElement)changeBinding, "Binding for change: " + labels.getText((Object)changeBinding.getChange()));
            if (!result.successful.contains(changeBinding.getChange())) continue;
            String validation = result.successful.contains(changeBinding.getChange()) ? "applied to" : (result.bound.contains(changeBinding.getChange()) ? "was already applied" : (result.crossReferences.contains(changeBinding.getChange()) ? "applied but not all cross references could be restored" : "was not applied successfully"));
            for (ElementChangeBinding elementChangeBinding2 : changeBinding.getCorrespondingElements()) {
                factory.createNote((NoteElement)elementChangeBinding2, "Change " + validation + ": " + labels.getText((Object)elementChangeBinding2.getModelElement()) + "\n" + "Resolved by: " + labels.getText((Object)elementChangeBinding2.getElementReference()));
            }
            if (changeBinding instanceof AddReferenceChangeBinding) {
                AddReferenceChangeBinding addReferenceChangeBinding = (AddReferenceChangeBinding)changeBinding;
                for (ElementChangeBinding elementChangeBinding3 : addReferenceChangeBinding.getChangedReference()) {
                    factory.createNote((NoteElement)elementChangeBinding3, "Reference added to: " + labels.getText((Object)elementChangeBinding3.getModelElement()) + "\n" + "Resolved by: " + labels.getText((Object)elementChangeBinding3.getElementReference()));
                }
            }
            if (changeBinding instanceof UpdateReferenceChangeBinding && (elementChangeBinding3 = (updateReferenceChangeBinding = (UpdateReferenceChangeBinding)changeBinding).getNewReference()) != null) {
                factory.createNote((NoteElement)elementChangeBinding3, "Reference added to: " + labels.getText((Object)elementChangeBinding3.getModelElement()) + "\n" + "Resolved by: " + labels.getText((Object)elementChangeBinding3.getElementReference()));
            }
            if (changeBinding instanceof MoveElementChangeBinding) {
                MoveElementChangeBinding moveElementChangeBinding = (MoveElementChangeBinding)changeBinding;
                elementChangeBinding3 = moveElementChangeBinding.getNewParent();
                factory.createNote((NoteElement)elementChangeBinding3, "Moved to: " + labels.getText((Object)elementChangeBinding3.getModelElement()) + "\n" + "Resolved by: " + labels.getText((Object)elementChangeBinding3.getElementReference()));
            }
            if (!(changeBinding instanceof AddElementChangeBinding)) continue;
            AddElementChangeBinding compoundBinding = (AddElementChangeBinding)changeBinding;
            this.addNotesToSubModelBinding((EList<? extends ElementChangeBinding>)compoundBinding.getSubModelReferences(), (ILabelProvider)labels);
        }
    }

    private void addNotesToSubModelBinding(EList<? extends ElementChangeBinding> subModelReferences, ILabelProvider labels) {
        for (ElementChangeBinding binding : subModelReferences) {
            if (binding instanceof SubModelBinding) {
                SubModelBinding subModelBinding = (SubModelBinding)binding;
                BindingFactory.eINSTANCE.createNote((NoteElement)binding, "Added model element: " + labels.getText((Object)subModelBinding.getSelfElement()) + "\n" + "Parent: " + labels.getText((Object)binding.getModelElement()));
                this.addNotesToSubModelBinding((EList<? extends ElementChangeBinding>)subModelBinding.getSubModelReferences(), labels);
                continue;
            }
            BindingFactory.eINSTANCE.createNote((NoteElement)binding, "Cross-reference restored to: " + labels.getText((Object)binding.getModelElement()) + "\n" + "Resolved by: " + labels.getText((Object)binding.getElementReference()));
        }
    }

    protected void restoreCrossReferences(Collection<IndepChange> successfulChanges, Collection<IndepChange> failedReferenceChanges, ResolvedSymbolicReferences binding) {
        ArrayList<EObject> failedSymrefRestoredElements = new ArrayList<EObject>();
        for (EObject addedElement : this.addedElementToModelDescriptorMap.keySet()) {
            SubModelBinding subModelBinding;
            IModelDescriptor descriptor = this.addedElementToModelDescriptorMap.get(addedElement);
            EList crossReferences = descriptor.getCrossReferences();
            if (crossReferences.isEmpty()) continue;
            BasicEMap crossReferenceResolutions = new BasicEMap();
            for (IElementReference crossRef : crossReferences) {
                Collection<EObject> resolution = this.resolveSymbolicReference(binding, this.flatDeletions, crossRef);
                crossReferenceResolutions.put((Object)crossRef, (Object)new BasicEList(resolution));
            }
            EList failedReferences = descriptor.applyCrossReferences(addedElement, (EMap)crossReferenceResolutions);
            if (failedReferences.size() > 0) {
                failedSymrefRestoredElements.add(addedElement);
            }
            if ((subModelBinding = this.addedElementToSubModelBindingMap.get(addedElement)) == null) continue;
            for (IElementReference ref : crossReferenceResolutions.keySet()) {
                for (EObject obj : (EList)crossReferenceResolutions.get((Object)ref)) {
                    subModelBinding.getSubModelReferences().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(ref, obj));
                }
            }
        }
        for (EObject failedElement : failedSymrefRestoredElements) {
            IndepChange change = (IndepChange)this.addedElementToChangeMap.get(failedElement);
            if (successfulChanges.remove(change)) {
                if (failedReferenceChanges.add(change)) continue;
                throw new IllegalStateException("For some reason, the following change cannot be moved to another collection: " + change);
            }
            if (failedReferenceChanges.contains(change)) continue;
            throw new IllegalStateException("If the change is in not listed in any statistics collection: " + change);
        }
    }

    protected ApplicationResult applyChange(IndepChange indepChange, ResolvedSymbolicReferences binding) throws IllegalArgumentException {
        ApplicationResult result;
        if (indepChange instanceof UnknownChange) {
            return ApplicationResult.FAILED;
        }
        Collection correspondingElements = (Collection)((Map)binding.getResolutionByChange().get(indepChange)).get(indepChange.getCorrespondingElement());
        ChangeBinding changeBinding = null;
        if (this.options.get(OPTION_STORE_BINDING).booleanValue()) {
            changeBinding = BindingFactory.eINSTANCE.createChangeBindingForChange(indepChange);
            binding.getMPatchModelBinding().getChangeBindings().add((Object)changeBinding);
        }
        if (correspondingElements.size() == 0) {
            return ApplicationResult.FAILED;
        }
        if (indepChange instanceof IndepAddElementChange) {
            result = this.applyAddElementChange((IndepAddRemElementChange)indepChange, correspondingElements, binding, (AddElementChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepRemoveElementChange) {
            result = this.applyRemoveElementChange((IndepAddRemElementChange)indepChange, correspondingElements, binding, (RemoveElementChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepMoveElementChange) {
            result = this.applyMoveElementChange((IndepMoveElementChange)indepChange, correspondingElements, binding, (MoveElementChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepAddAttributeChange) {
            result = this.applyAddAttributeChange((IndepAddRemAttributeChange)indepChange, correspondingElements, (AttributeChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepRemoveAttributeChange) {
            result = this.applyRemoveAttributeChange((IndepAddRemAttributeChange)indepChange, correspondingElements, (AttributeChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepUpdateAttributeChange) {
            result = this.applyUpdateAttributeChange((IndepUpdateAttributeChange)indepChange, correspondingElements, (AttributeChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepAddReferenceChange) {
            result = this.applyAddReferenceChange((IndepAddRemReferenceChange)indepChange, correspondingElements, binding, (AddReferenceChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepRemoveReferenceChange) {
            result = this.applyRemoveReferenceChange((IndepAddRemReferenceChange)indepChange, correspondingElements, binding, (RemoveReferenceChangeBinding)changeBinding);
        } else if (indepChange instanceof IndepUpdateReferenceChange) {
            result = this.applyUpdateReferenceChange((IndepUpdateReferenceChange)indepChange, correspondingElements, binding, (UpdateReferenceChangeBinding)changeBinding);
        } else {
            throw new UnsupportedOperationException("Unknown change type: " + indepChange);
        }
        return result;
    }

    protected ApplicationResult applyUpdateReferenceChange(IndepUpdateReferenceChange referenceChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, UpdateReferenceChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        IElementReference objectReference = referenceChange.getNewReference();
        EObject referencedObject = null;
        if (objectReference != null) {
            Collection<EObject> references = this.resolveSymbolicReference(binding, this.flatDeletions, objectReference);
            if (references == null || references.size() != 1) {
                return result;
            }
            referencedObject = references.iterator().next();
            if (changeBinding != null) {
                changeBinding.setNewReference(BindingFactory.eINSTANCE.createElementChangeBinding(objectReference, referencedObject));
            }
        }
        for (EObject element : correspondingElements) {
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(referenceChange.getCorrespondingElement(), element));
            }
            if (objectReference == null) {
                if (element.eGet((EStructuralFeature)referenceChange.getReference()) == null) {
                    result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
                }
                element.eSet((EStructuralFeature)referenceChange.getReference(), null);
                if (element.eGet((EStructuralFeature)referenceChange.getReference()) != null) continue;
                result = ApplicationResult.SUCCESSFUL;
                continue;
            }
            if (referencedObject != null && referencedObject.equals(element.eGet((EStructuralFeature)referenceChange.getReference()))) {
                result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
            }
            element.eSet((EStructuralFeature)referenceChange.getReference(), (Object)referencedObject);
            if (referencedObject == null || !referencedObject.equals(element.eGet((EStructuralFeature)referenceChange.getReference()))) continue;
            result = ApplicationResult.SUCCESSFUL;
        }
        return result;
    }

    protected ApplicationResult applyRemoveReferenceChange(IndepAddRemReferenceChange referenceChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, RemoveReferenceChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        for (EObject element : correspondingElements) {
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(referenceChange.getCorrespondingElement(), element));
            }
            EList list = (EList)element.eGet((EStructuralFeature)referenceChange.getReference());
            Collection<EObject> changedReferenceResolution = this.resolveSymbolicReference(binding, this.flatDeletions, referenceChange.getChangedReference());
            for (EObject removedObject : changedReferenceResolution) {
                if (removedObject == null) continue;
                if (list.remove((Object)removedObject)) {
                    result = ApplicationResult.SUCCESSFUL;
                    continue;
                }
                if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                ApplicationResult applicationResult = result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
            }
        }
        return result;
    }

    protected ApplicationResult applyAddReferenceChange(IndepAddRemReferenceChange referenceChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, AddReferenceChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        Collection<EObject> addedObjects = this.resolveSymbolicReference(binding, this.flatDeletions, referenceChange.getChangedReference());
        if (addedObjects == null) {
            return result;
        }
        if (changeBinding != null) {
            for (EObject modelElement : addedObjects) {
                changeBinding.getChangedReference().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(referenceChange.getChangedReference(), modelElement));
            }
        }
        for (EObject element : correspondingElements) {
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(referenceChange.getCorrespondingElement(), element));
            }
            EList list = (EList)element.eGet((EStructuralFeature)referenceChange.getReference());
            for (EObject addedObject : addedObjects) {
                if (addedObject == null) continue;
                if (list.contains((Object)addedObject) && this.respectApplied) {
                    if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                    result = ApplicationResult.BOUND;
                    continue;
                }
                if (list.contains((Object)addedObject) && this.respectApplied || !list.add((Object)addedObject)) continue;
                result = ApplicationResult.SUCCESSFUL;
            }
        }
        return result;
    }

    protected ApplicationResult applyUpdateAttributeChange(IndepUpdateAttributeChange attributeChange, Collection<EObject> correspondingElements, AttributeChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        for (EObject element : correspondingElements) {
            Object attributeValue;
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(attributeChange.getCorrespondingElement(), element));
            }
            if ((attributeValue = attributeChange.getNewValue()) == null && element.eGet((EStructuralFeature)attributeChange.getChangedAttribute()) == null || attributeValue != null && attributeValue.equals(element.eGet((EStructuralFeature)attributeChange.getChangedAttribute()))) {
                if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
                continue;
            }
            element.eSet((EStructuralFeature)attributeChange.getChangedAttribute(), attributeValue);
            if ((attributeValue != null || element.eGet((EStructuralFeature)attributeChange.getChangedAttribute()) != null) && (attributeValue == null || !attributeValue.equals(element.eGet((EStructuralFeature)attributeChange.getChangedAttribute())))) continue;
            result = ApplicationResult.SUCCESSFUL;
        }
        return result;
    }

    protected ApplicationResult applyRemoveAttributeChange(IndepAddRemAttributeChange attributeChange, Collection<EObject> correspondingElements, AttributeChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        for (EObject element : correspondingElements) {
            EList list;
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(attributeChange.getCorrespondingElement(), element));
            }
            if ((list = (EList)element.eGet((EStructuralFeature)attributeChange.getChangedAttribute())).remove(attributeChange.getValue())) {
                result = ApplicationResult.SUCCESSFUL;
                continue;
            }
            if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
            ApplicationResult applicationResult = result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
        }
        return result;
    }

    protected ApplicationResult applyAddAttributeChange(IndepAddRemAttributeChange attributeChange, Collection<EObject> correspondingElements, AttributeChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        for (EObject element : correspondingElements) {
            Object changedValue;
            EList list;
            if (element == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(attributeChange.getCorrespondingElement(), element));
            }
            if ((list = (EList)element.eGet((EStructuralFeature)attributeChange.getChangedAttribute())).contains(changedValue = attributeChange.getValue()) && this.respectApplied) {
                if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                result = ApplicationResult.BOUND;
                continue;
            }
            if (list.contains(changedValue) && this.respectApplied || !list.add(changedValue)) continue;
            result = ApplicationResult.SUCCESSFUL;
        }
        return result;
    }

    protected ApplicationResult applyMoveElementChange(IndepMoveElementChange elementChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, MoveElementChangeBinding changeBinding) {
        EObject newParent;
        ApplicationResult result = ApplicationResult.FAILED;
        IElementReference newParentReference = elementChange.getNewParent();
        Collection<EObject> newParents = this.resolveSymbolicReference(binding, this.flatDeletions, newParentReference);
        if (newParents != null && newParents.size() == 1 && (newParent = newParents.iterator().next()) != null) {
            EObject moveElement;
            EReference containment;
            if (changeBinding != null) {
                changeBinding.setNewParent(BindingFactory.eINSTANCE.createElementChangeBinding(newParentReference, newParent));
            }
            if ((containment = elementChange.getNewContainment()).isMany()) {
                EList list = (EList)newParent.eGet((EStructuralFeature)containment);
                for (EObject moveElement2 : correspondingElements) {
                    if (moveElement2 == null) continue;
                    if (list.contains((Object)moveElement2)) {
                        if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                        result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
                        continue;
                    }
                    if (!list.add((Object)moveElement2)) continue;
                    result = ApplicationResult.SUCCESSFUL;
                    if (changeBinding == null) continue;
                    changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(elementChange.getCorrespondingElement(), moveElement2));
                }
            } else if (correspondingElements.size() == 1 && !newParent.eIsSet((EStructuralFeature)containment) && (moveElement = correspondingElements.iterator().next()) != null) {
                if (moveElement.equals(newParent.eGet((EStructuralFeature)containment))) {
                    if (!ApplicationResult.SUCCESSFUL.equals((Object)result)) {
                        ApplicationResult applicationResult = result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
                    }
                    if (changeBinding != null) {
                        changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(elementChange.getCorrespondingElement(), moveElement));
                    }
                } else {
                    newParent.eSet((EStructuralFeature)containment, (Object)moveElement);
                    if (moveElement.equals(newParent.eGet((EStructuralFeature)containment))) {
                        result = ApplicationResult.SUCCESSFUL;
                        if (changeBinding != null) {
                            changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(elementChange.getCorrespondingElement(), moveElement));
                        }
                    }
                }
            }
        }
        return result;
    }

    protected ApplicationResult applyRemoveElementChange(IndepAddRemElementChange elementChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, RemoveElementChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        for (EObject parent : correspondingElements) {
            if (parent == null) continue;
            if (changeBinding != null) {
                changeBinding.getCorrespondingElements().add((Object)BindingFactory.eINSTANCE.createElementChangeBinding(elementChange.getCorrespondingElement(), parent));
            }
            Collection<EObject> resolvedElements = this.resolveSymbolicReference(binding, this.flatDeletions, elementChange.getSubModel().getSelfReference());
            ArrayList<EObject> elementsToRemove = new ArrayList<EObject>();
            for (EObject element : resolvedElements) {
                if (!parent.equals(element.eContainer())) continue;
                elementsToRemove.add(element);
            }
            for (EObject element : elementsToRemove) {
                EcoreUtil.delete((EObject)element);
                if (this.deletedSubmodels.add((Object)element)) {
                    result = ApplicationResult.SUCCESSFUL;
                    continue;
                }
                if (ApplicationResult.SUCCESSFUL.equals((Object)result)) continue;
                ApplicationResult applicationResult = result = this.respectApplied ? ApplicationResult.BOUND : ApplicationResult.SUCCESSFUL;
            }
            this.flatDeletions.addAll(ExtEcoreUtils.flattenEObjects(elementsToRemove));
        }
        return result;
    }

    protected ApplicationResult applyAddElementChange(IndepAddRemElementChange elementChange, Collection<EObject> correspondingElements, ResolvedSymbolicReferences binding, AddElementChangeBinding changeBinding) {
        ApplicationResult result = ApplicationResult.FAILED;
        LinkedHashMap<EObject, EMap> addedElements = new LinkedHashMap<EObject, EMap>();
        if (this.respectApplied) {
            Collection maybeAddedElements = (Collection)((Map)binding.getResolutionByChange().get(elementChange)).get(elementChange.getSubModelReference());
            for (EObject added : maybeAddedElements) {
                EMap descriptors = elementChange.getSubModel().isDescriptorFor(added, false);
                if (descriptors == null) continue;
                addedElements.put(added, descriptors);
            }
        }
        for (EObject parent : correspondingElements) {
            EMap submodelDescriptors;
            if (parent == null) continue;
            boolean found = false;
            for (EObject added : addedElements.keySet()) {
                if (!parent.equals(added.eContainer())) continue;
                if (!ApplicationResult.SUCCESSFUL.equals((Object)result)) {
                    result = ApplicationResult.BOUND;
                }
                EMap submodelDescriptors2 = (EMap)addedElements.get(added);
                for (EObject element : submodelDescriptors2.keySet()) {
                    IElementReference selfReference = ((IModelDescriptor)submodelDescriptors2.get((Object)element)).getSelfReference();
                    GenericMPatchApplier.addElementToSetMap(selfReference, element, this.addedElementSymrefToElementsMap);
                }
                if (changeBinding != null) {
                    SubModelBinding subBinding = BindingFactory.eINSTANCE.createSubModelBinding(submodelDescriptors2, added, elementChange.getCorrespondingElement(), parent, this.addedElementToSubModelBindingMap);
                    changeBinding.getSubModelReferences().add((Object)subBinding);
                }
                found = true;
            }
            if (found || (submodelDescriptors = elementChange.getSubModel().applyStructure(parent, elementChange.getContainment())) == null || submodelDescriptors.isEmpty()) continue;
            result = ApplicationResult.SUCCESSFUL;
            for (EObject element : submodelDescriptors.keySet()) {
                IElementReference selfReference = ((IModelDescriptor)submodelDescriptors.get((Object)element)).getSelfReference();
                GenericMPatchApplier.addElementToSetMap(selfReference, element, this.addedElementSymrefToElementsMap);
                this.addedElementToChangeMap.put(element, elementChange);
                this.addedElementToModelDescriptorMap.put(element, (IModelDescriptor)submodelDescriptors.get((Object)element));
                if (!selfReference.equals(elementChange.getSubModel().getSelfReference()) || changeBinding == null) continue;
                SubModelBinding subBinding = BindingFactory.eINSTANCE.createSubModelBinding(submodelDescriptors, element, elementChange.getCorrespondingElement(), parent, this.addedElementToSubModelBindingMap);
                changeBinding.getSubModelReferences().add((Object)subBinding);
            }
        }
        return result;
    }

    protected static <T, S> void addElementToSetMap(T key, S element, Map<T, Set<S>> map) {
        Set<S> set = map.get(key);
        if (set == null) {
            set = new HashSet<S>();
            map.put(key, set);
        }
        set.add(element);
    }

    protected Collection<EObject> resolveSymbolicReference(ResolvedSymbolicReferences binding, Collection<EObject> flatDeletions, IElementReference symref) {
        IModelDescriptor descriptor;
        Set<EObject> elements;
        if (symref instanceof ModelDescriptorReference && (elements = this.addedElementSymrefToElementsMap.get((descriptor = ((ModelDescriptorReference)symref).getResolvesTo()).getSelfReference())) != null) {
            return elements;
        }
        Map changeResolutions = (Map)binding.getResolutionByChange().get(MPatchUtil.getChangeFor((IElementReference)symref));
        if (changeResolutions != null && changeResolutions.containsKey(symref) && !((List)changeResolutions.get(symref)).isEmpty()) {
            return (Collection)changeResolutions.get(symref);
        }
        Collection rawResult = (Collection)binding.getRawResolution().get(symref);
        HashSet<EObject> result = new HashSet<EObject>();
        if (rawResult != null) {
            for (EObject obj : rawResult) {
                if (flatDeletions.contains(obj)) continue;
                result.add(obj);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ApplicationResult {
        SUCCESSFUL,
        BOUND,
        FAILED,
        REFERENCES;

    }
}

