/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class ApplyAction
implements IObjectActionDelegate,
IEditorActionDelegate {
    private IStructuredSelection selection;
    private Shell shell;
    private IWorkbench workbench;

    public void run(IAction action) {
        ApplyWizard wizard = new ApplyWizard();
        wizard.init(this.workbench, this.selection);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.selection = null;
        if (selection instanceof IStructuredSelection && ((structuredSelection = (IStructuredSelection)selection).size() == 1 || structuredSelection.size() == 2)) {
            for (Object obj : structuredSelection) {
                IFile file;
                if (obj instanceof IFile) {
                    file = (IFile)obj;
                    if (!"mpatch".equals(file.getFileExtension())) continue;
                    this.selection = structuredSelection;
                    return;
                }
                if (obj instanceof EObject) {
                    IFile file2;
                    EObject root = EcoreUtil.getRootContainer((EObject)((EObject)obj));
                    if (!(root instanceof MPatchModel) || root.eResource() == null || (file2 = ApplyAction.getFileFromResource(root.eResource())) == null) continue;
                    this.selection = new StructuredSelection((Object)file2);
                    continue;
                }
                if (!(obj instanceof Resource) || (file = ApplyAction.getFileFromResource((Resource)obj)) == null) continue;
                this.selection = new StructuredSelection((Object)file);
            }
        }
        action.setEnabled(this.selection != null);
    }

    private static IFile getFileFromResource(Resource obj) {
        URI uri = obj.getURI();
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        String[] segments = uri.segments();
        if (segments != null && segments.length > 1) {
            String[] newSegments = new String[segments.length - 1];
            System.arraycopy(segments, 1, newSegments, 0, newSegments.length);
            Path path = new Path("/" + CommonUtils.join((String[])newSegments, (CharSequence)"/"));
            IFile file = ws.getFile((IPath)path);
            if (file != null && file.exists()) {
                return file;
            }
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.workbench = targetPart.getSite().getWorkbenchWindow().getWorkbench();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
            this.workbench = targetEditor.getSite().getWorkbenchWindow().getWorkbench();
        }
    }
}

