/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.service.MergeFactory;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.util.DiffAdapterFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.ui.AbstractCompareAction;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.ICompareEditorPartListener;
import org.eclipse.emf.compare.ui.ICompareInputDetailsProvider;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeContentProvider;
import org.eclipse.emf.compare.ui.viewer.content.part.AbstractCenterPart;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContentMergeViewer
extends ContentMergeViewer {
    public static final String BUNDLE_NAME = "org.eclipse.emf.compare.ui.viewer.content.ModelMergeViewerResources";
    public static final int CENTER_WIDTH = 34;
    static Map<String, RGB> colors = new EMFCompareMap();
    private static boolean drawDiffMarkers;
    protected int activeTabIndex;
    protected ModelContentMergeTabFolder ancestorPart;
    protected final List<DiffElement> currentSelection = new ArrayList<DiffElement>();
    protected ModelContentMergeTabFolder leftPart;
    protected ModelContentMergeTabFolder rightPart;
    protected final CompareConfiguration configuration;
    protected boolean isThreeWay;
    private AbstractCenterPart canvas;
    private Action copyDiffLeftToRight;
    private Action copyDiffRightToLeft;
    private boolean leftDirty;
    private EditorPartListener partListener;
    private final IPropertyChangeListener preferenceListener;
    private boolean rightDirty;
    private final IPropertyChangeListener structureSelectionListener;

    public ModelContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.configuration = config;
        this.buildControl(parent);
        this.updatePreferences();
        IMergeViewerContentProvider contentProvider = this.createMergeViewerContentProvider();
        if (contentProvider != null) {
            this.setContentProvider((IContentProvider)contentProvider);
        } else {
            this.setContentProvider((IContentProvider)new ModelContentMergeContentProvider(this.configuration));
        }
        this.switchCopyState(false);
        this.structureSelectionListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("structure.selection.changed")) {
                    Object newValues = event.getNewValue();
                    List elements = newValues instanceof IStructuredSelection ? ((IStructuredSelection)newValues).toList() : (List)event.getNewValue();
                    ArrayList<DiffElement> selectedDiffs = new ArrayList<DiffElement>();
                    int i = 0;
                    while (i < elements.size()) {
                        if (elements.get(i) instanceof DiffElement && (!(elements.get(i) instanceof DiffGroup) || ((DiffGroup)elements.get(i)).getSubDiffElements().size() != 0)) {
                            selectedDiffs.add((DiffElement)elements.get(i));
                        }
                        ++i;
                    }
                    ModelContentMergeViewer.this.setSelection(selectedDiffs);
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.structureSelectionListener);
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().matches(".*(color|differences)")) {
                    ModelContentMergeViewer.this.updatePreferences();
                }
            }
        };
        EMFCompareUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public static final RGB getColor(String key) {
        return colors.get(key);
    }

    public static boolean shouldDrawDiffMarkers() {
        return drawDiffMarkers;
    }

    public Canvas getCenterPart() {
        if (this.canvas == null && !this.getControl().isDisposed()) {
            this.canvas = this.getCenterCanvas();
        }
        if (this.canvas != null) {
            this.canvas.moveAbove(null);
        }
        return this.canvas;
    }

    protected CenterCanvas getCenterCanvas() {
        return new CenterCanvas((Composite)this.getControl());
    }

    public CompareConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput && ((ICompareInput)input).getAncestor() != null) {
            this.isThreeWay = true;
        }
        ModelComparator comparator = input instanceof ICompareInput ? ModelComparator.getComparator(this.configuration, (ICompareInput)input) : ModelComparator.getComparator(this.configuration);
        if (input instanceof ComparisonResourceSnapshot) {
            ComparisonResourceSnapshot snapshot = (ComparisonResourceSnapshot)input;
            super.setInput((Object)this.createModelCompareInput(comparator, (ComparisonSnapshot)snapshot));
        } else if (input instanceof ComparisonResourceSetSnapshot) {
            ComparisonResourceSetSnapshot snapshot = (ComparisonResourceSetSnapshot)input;
            super.setInput((Object)this.createModelCompareInput(comparator, (ComparisonSnapshot)snapshot));
        } else if (input instanceof ModelCompareInput) {
            super.setInput(input);
        } else if (input instanceof ICompareInput) {
            comparator.loadResources((ICompareInput)input);
            ComparisonSnapshot snapshot = comparator.compare(this.configuration);
            super.setInput((Object)this.createModelCompareInput(comparator, snapshot));
            this.configuration.setProperty("content.input.changed", (Object)snapshot);
        } else {
            super.setInput(input);
        }
    }

    protected ModelCompareInput createModelCompareInput(ICompareInputDetailsProvider provider, ComparisonSnapshot snapshot) {
        if (snapshot instanceof ComparisonResourceSetSnapshot) {
            return new ModelCompareInput(((ComparisonResourceSetSnapshot)snapshot).getMatchResourceSet(), ((ComparisonResourceSetSnapshot)snapshot).getDiffResourceSet(), provider);
        }
        return new ModelCompareInput(((ComparisonResourceSnapshot)snapshot).getMatch(), ((ComparisonResourceSnapshot)snapshot).getDiff(), provider);
    }

    public void setSelection(DiffElement diff) {
        ArrayList<DiffElement> diffs = new ArrayList<DiffElement>();
        diffs.add(diff);
        this.setSelection(diffs);
    }

    public void setSelection(List<DiffElement> diffs) {
        this.currentSelection.clear();
        if (diffs.size() > 0) {
            this.currentSelection.addAll(diffs);
            if (this.leftPart != null) {
                this.leftPart.navigateToDiff(diffs);
            }
            if (this.rightPart != null) {
                this.rightPart.navigateToDiff(diffs);
            }
            if (this.isThreeWay && this.ancestorPart != null) {
                this.ancestorPart.navigateToDiff(diffs.get(0));
            }
            this.switchCopyState(true);
        }
    }

    public void update() {
        if (this.isThreeWay && this.ancestorPart != null) {
            this.ancestorPart.layout();
        }
        if (this.rightPart != null) {
            this.rightPart.layout();
        }
        if (this.leftPart != null) {
            this.leftPart.layout();
        }
        this.updateCenter();
        this.updateToolItems();
    }

    public void updateCenter() {
        if (this.getCenterPart() != null) {
            this.getCenterPart().redraw();
        }
    }

    protected void copy(boolean leftToRight) {
        if (((ModelCompareInput)this.getInput()).getDiffAsList().size() > 0) {
            this.setRightDirty(false);
            this.setLeftDirty(false);
            ((ModelCompareInput)this.getInput()).copy(leftToRight);
            if (((ModelCompareInput)this.getInput()).getDiff() instanceof DiffModel) {
                ComparisonResourceSnapshot snap = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
                snap.setDiff((DiffModel)((ModelCompareInput)this.getInput()).getDiff());
                snap.setMatch((MatchModel)((ModelCompareInput)this.getInput()).getMatch());
                this.configuration.setProperty("content.input.changed", (Object)snap);
            } else {
                ComparisonResourceSetSnapshot snap = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
                snap.setDiffResourceSet((DiffResourceSet)((ModelCompareInput)this.getInput()).getDiff());
                snap.setMatchResourceSet((MatchResourceSet)((ModelCompareInput)this.getInput()).getMatch());
                this.configuration.setProperty("content.input.changed", (Object)snap);
            }
            this.leftDirty |= !leftToRight;
            this.rightDirty |= leftToRight;
            this.setLeftDirty(this.leftDirty);
            this.setRightDirty(this.rightDirty);
            this.update();
        }
    }

    protected void copy(List<DiffElement> diffs, boolean leftToRight) {
        if (diffs.size() > 0) {
            this.setRightDirty(false);
            this.setLeftDirty(false);
            ((ModelCompareInput)this.getInput()).copy(diffs, leftToRight);
            if (((ModelCompareInput)this.getInput()).getDiff() instanceof DiffModel) {
                ComparisonResourceSnapshot snap = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
                snap.setDiff((DiffModel)((ModelCompareInput)this.getInput()).getDiff());
                snap.setMatch((MatchModel)((ModelCompareInput)this.getInput()).getMatch());
                this.configuration.setProperty("content.input.changed", (Object)snap);
            } else {
                ComparisonResourceSetSnapshot snap = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
                snap.setDiffResourceSet((DiffResourceSet)((ModelCompareInput)this.getInput()).getDiff());
                snap.setMatchResourceSet((MatchResourceSet)((ModelCompareInput)this.getInput()).getMatch());
                this.configuration.setProperty("content.input.changed", (Object)snap);
            }
            this.leftDirty |= !leftToRight && this.configuration.isLeftEditable();
            this.rightDirty |= leftToRight && this.configuration.isRightEditable();
            this.setLeftDirty(this.leftDirty);
            this.setRightDirty(this.rightDirty);
            this.update();
        }
    }

    protected void copyDiffLeftToRight() {
        if (this.currentSelection != null) {
            this.copy(this.currentSelection, true);
        }
        this.currentSelection.clear();
        this.switchCopyState(false);
    }

    protected void copyDiffRightToLeft() {
        if (this.currentSelection != null) {
            this.copy(this.currentSelection, false);
        }
        this.currentSelection.clear();
        this.switchCopyState(false);
    }

    protected void createControls(Composite composite) {
        this.leftPart = this.createModelContentMergeTabFolder(composite, 1);
        this.rightPart = this.createModelContentMergeTabFolder(composite, 2);
        this.ancestorPart = this.createModelContentMergeTabFolder(composite, 3);
        this.partListener = new EditorPartListener(this.leftPart, this.rightPart, this.ancestorPart);
        this.leftPart.addCompareEditorPartListener(this.partListener);
        this.rightPart.addCompareEditorPartListener(this.partListener);
        this.ancestorPart.addCompareEditorPartListener(this.partListener);
        this.createPropertiesSyncHandlers(this.leftPart, this.rightPart, this.ancestorPart);
        this.createTreeSyncHandlers(this.leftPart, this.rightPart, this.ancestorPart);
    }

    protected IMergeViewerContentProvider createMergeViewerContentProvider() {
        return new ModelContentMergeContentProvider(this.configuration);
    }

    protected ModelContentMergeTabFolder createModelContentMergeTabFolder(Composite composite, int side) {
        return new ModelContentMergeTabFolder(this, composite, side);
    }

    protected void createToolItems(ToolBarManager tbm) {
        if (this.getCompareConfiguration().isRightEditable()) {
            this.copyDiffLeftToRight = new AbstractCompareAction(ResourceBundle.getBundle(BUNDLE_NAME), "action.CopyDiffLeftToRight."){

                public void run() {
                    ModelContentMergeViewer.this.copyDiffLeftToRight();
                }
            };
            ActionContributionItem copyLeftToRightContribution = new ActionContributionItem((IAction)this.copyDiffLeftToRight);
            copyLeftToRightContribution.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)copyLeftToRightContribution);
        }
        if (this.getCompareConfiguration().isLeftEditable()) {
            this.copyDiffRightToLeft = new AbstractCompareAction(ResourceBundle.getBundle(BUNDLE_NAME), "action.CopyDiffRightToLeft."){

                public void run() {
                    ModelContentMergeViewer.this.copyDiffRightToLeft();
                }
            };
            ActionContributionItem copyRightToLeftContribution = new ActionContributionItem((IAction)this.copyDiffRightToLeft);
            copyRightToLeftContribution.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)copyRightToLeftContribution);
        }
        AbstractCompareAction nextDiff = new AbstractCompareAction(ResourceBundle.getBundle(BUNDLE_NAME), "action.NextDiff."){

            public void run() {
                ModelContentMergeViewer.this.navigate(true);
            }
        };
        ActionContributionItem nextDiffContribution = new ActionContributionItem((IAction)nextDiff);
        nextDiffContribution.setVisible(true);
        tbm.appendToGroup("navigation", (IContributionItem)nextDiffContribution);
        AbstractCompareAction previousDiff = new AbstractCompareAction(ResourceBundle.getBundle(BUNDLE_NAME), "action.PrevDiff."){

            public void run() {
                ModelContentMergeViewer.this.navigate(false);
            }
        };
        ActionContributionItem previousDiffContribution = new ActionContributionItem((IAction)previousDiff);
        previousDiffContribution.setVisible(true);
        tbm.appendToGroup("navigation", (IContributionItem)previousDiffContribution);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
    }

    protected byte[] getContents(boolean left) {
        byte[] contents = null;
        Object input = left ? ((IMergeViewerContentProvider)this.getContentProvider()).getLeftContent(this.getInput()) : ((IMergeViewerContentProvider)this.getContentProvider()).getRightContent(this.getInput());
        Resource resource = input instanceof TypedElementWrapper ? ((TypedElementWrapper)input).getObject().eResource() : (input instanceof List ? (Resource)((List)input).get(0) : (Resource)input);
        if (resource != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                resource.save((OutputStream)stream, null);
                contents = stream.toByteArray();
            }
            catch (IOException e) {
                EMFComparePlugin.log((Exception)e, (boolean)false);
            }
        }
        return contents;
    }

    protected List<DiffElement> getVisibleDiffs() {
        List<DiffElement> diffs = ((ModelCompareInput)this.getInput()).getDiffAsList();
        ArrayList<DiffElement> visibleDiffs = new ArrayList<DiffElement>(diffs.size());
        int i = 0;
        while (i < diffs.size()) {
            if (!DiffAdapterFactory.shouldBeHidden((EObject)((EObject)diffs.get(i)))) {
                visibleDiffs.add(diffs.get(i));
            }
            ++i;
        }
        return visibleDiffs;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.configuration.removePropertyChangeListener(this.structureSelectionListener);
        EMFCompareUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        if (this.leftPart != null) {
            this.leftPart.removeCompareEditorPartListener(this.partListener);
            this.leftPart.dispose();
            this.leftPart = null;
        }
        if (this.rightPart != null) {
            this.rightPart.removeCompareEditorPartListener(this.partListener);
            this.rightPart.dispose();
            this.rightPart = null;
        }
        if (this.ancestorPart != null) {
            this.ancestorPart.removeCompareEditorPartListener(this.partListener);
            this.ancestorPart.dispose();
            this.ancestorPart = null;
        }
        if (this.canvas != null) {
            this.canvas.dispose();
            this.canvas = null;
        }
        this.currentSelection.clear();
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        this.ancestorPart.setBounds(x, y, width, height);
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        if (this.getCenterPart() != null) {
            this.getCenterPart().setBounds(leftWidth - 17, y, 34, height);
        }
        this.leftPart.setBounds(x, y, leftWidth - 17, height);
        this.rightPart.setBounds(x + leftWidth + 17, y, rightWidth - 17, height);
        this.update();
    }

    protected void navigate(boolean down) {
        List<DiffElement> diffs = this.getVisibleDiffs();
        if (diffs.size() != 0) {
            DiffElement theDiff = this.currentSelection.size() > 0 && !(this.currentSelection.get(0) instanceof DiffGroup) ? this.currentSelection.get(0) : (diffs.size() == 1 ? diffs.get(0) : (down ? diffs.get(diffs.size() - 1) : diffs.get(1)));
            int i = 0;
            while (i < diffs.size()) {
                if (diffs.get(i).equals(theDiff) && down) {
                    DiffElement next = diffs.get(0);
                    if (diffs.size() > i + 1) {
                        next = diffs.get(i + 1);
                    }
                    if (next != null && !DiffAdapterFactory.shouldBeHidden((EObject)next)) {
                        this.setSelection(next);
                        break;
                    }
                } else if (diffs.get(i).equals(theDiff) && !down) {
                    DiffElement previous = diffs.get(diffs.size() - 1);
                    if (i > 0) {
                        previous = diffs.get(i - 1);
                    }
                    if (previous != null && !DiffAdapterFactory.shouldBeHidden((EObject)previous)) {
                        this.setSelection(previous);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    protected void switchCopyState(boolean enabled) {
        ModelComparator comparator = ModelComparator.getComparator(this.configuration);
        boolean leftEditable = this.configuration.isLeftEditable();
        if (comparator != null) {
            leftEditable = leftEditable && !comparator.isLeftRemote();
        }
        boolean rightEditable = this.configuration.isRightEditable();
        if (comparator != null) {
            rightEditable = rightEditable && !comparator.isRightRemote();
        }
        boolean canCopyLeftToRight = true;
        boolean canCopyRightToLeft = true;
        if (this.currentSelection.size() == 1) {
            IMerger merger = MergeFactory.createMerger((DiffElement)this.currentSelection.get(0));
            canCopyLeftToRight = merger.canUndoInTarget();
            canCopyRightToLeft = merger.canApplyInOrigin();
        }
        if (this.copyDiffLeftToRight != null) {
            this.copyDiffLeftToRight.setEnabled(rightEditable && enabled && canCopyLeftToRight);
        }
        if (this.copyDiffRightToLeft != null) {
            this.copyDiffRightToLeft.setEnabled(leftEditable && enabled && canCopyRightToLeft);
        }
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        Object ancestorObject = ancestor;
        Object leftObject = left;
        Object rightObject = right;
        if (ancestorObject instanceof TypedElementWrapper) {
            ancestorObject = ((TypedElementWrapper)ancestorObject).getObject() == null ? null : this.getInputObject((TypedElementWrapper)ancestorObject);
        }
        if (leftObject instanceof TypedElementWrapper) {
            leftObject = this.getInputObject((TypedElementWrapper)leftObject);
        }
        if (rightObject instanceof TypedElementWrapper) {
            rightObject = this.getInputObject((TypedElementWrapper)rightObject);
        }
        if (ancestorObject != null) {
            this.ancestorPart.setInput(ancestorObject);
        }
        if (leftObject != null) {
            this.leftPart.setInput(leftObject);
        }
        if (rightObject != null) {
            this.rightPart.setInput(rightObject);
        }
        this.update();
    }

    protected void updatePreferences() {
        IPreferenceStore comparePreferences = EMFCompareUIPlugin.getDefault().getPreferenceStore();
        this.updateColors(comparePreferences);
        this.updateDrawDiffMarkers(comparePreferences);
    }

    protected void updateToolItems() {
        super.updateToolItems();
        CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent()).update(true);
    }

    private void createPropertiesSyncHandlers(ModelContentMergeTabFolder ... parts) {
        if (parts.length < 2) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ModelContentMergeViewer.illegalSync"));
        }
        this.handleHSync(this.leftPart.getPropertyPart(), this.rightPart.getPropertyPart(), this.ancestorPart.getPropertyPart());
        this.handleHSync(this.ancestorPart.getPropertyPart(), this.rightPart.getPropertyPart(), this.leftPart.getPropertyPart());
        this.handleHSync(this.rightPart.getPropertyPart(), this.leftPart.getPropertyPart(), this.ancestorPart.getPropertyPart());
        this.handleVSync(this.leftPart.getPropertyPart(), this.rightPart.getPropertyPart(), this.ancestorPart.getPropertyPart());
        this.handleVSync(this.rightPart.getPropertyPart(), this.leftPart.getPropertyPart(), this.ancestorPart.getPropertyPart());
        this.handleVSync(this.ancestorPart.getPropertyPart(), this.rightPart.getPropertyPart(), this.leftPart.getPropertyPart());
    }

    private void createTreeSyncHandlers(ModelContentMergeTabFolder ... parts) {
        if (parts.length < 2) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ModelContentMergeViewer.illegalSync"));
        }
        this.handleHSync(this.leftPart.getTreePart(), this.rightPart.getTreePart(), this.ancestorPart.getTreePart());
        this.handleHSync(this.rightPart.getTreePart(), this.leftPart.getTreePart(), this.ancestorPart.getTreePart());
        this.handleHSync(this.ancestorPart.getTreePart(), this.rightPart.getTreePart(), this.leftPart.getTreePart());
    }

    protected final Object getInputObject(TypedElementWrapper elementWrapper) {
        Resource resource = elementWrapper.getObject().eResource();
        if (resource != null) {
            return resource.getResourceSet();
        }
        return elementWrapper;
    }

    private void handleHSync(IModelContentMergeViewerTab ... parts) {
        Scrollable scroll1 = (Scrollable)parts[0].getControl();
        final Scrollable scroll2 = (Scrollable)parts[1].getControl();
        final Scrollable scroll3 = parts.length > 2 ? (Scrollable)parts[2].getControl() : null;
        final ScrollBar scrollBar1 = scroll1.getHorizontalBar();
        scrollBar1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int max = scrollBar1.getMaximum() - scrollBar1.getThumb();
                double v = 0.0;
                if (max > 0) {
                    v = (double)scrollBar1.getSelection() / (double)max;
                }
                if (scroll2.isVisible()) {
                    ScrollBar scrollBar2 = scroll2.getHorizontalBar();
                    scrollBar2.setSelection((int)((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * v));
                }
                if (scroll3 != null && scroll3.isVisible()) {
                    ScrollBar scrollBar3 = scroll3.getHorizontalBar();
                    scrollBar3.setSelection((int)((double)(scrollBar3.getMaximum() - scrollBar3.getThumb()) * v));
                }
                if ("carbon".equals(SWT.getPlatform()) && ModelContentMergeViewer.this.getControl() != null && !ModelContentMergeViewer.this.getControl().isDisposed()) {
                    ModelContentMergeViewer.this.getControl().getDisplay().update();
                }
            }
        });
    }

    private void handleVSync(IModelContentMergeViewerTab ... parts) {
        Scrollable table1 = (Scrollable)parts[0].getControl();
        final Scrollable table2 = (Scrollable)parts[1].getControl();
        final Scrollable table3 = parts.length > 2 ? (Scrollable)parts[2].getControl() : null;
        final ScrollBar scrollBar1 = table1.getVerticalBar();
        scrollBar1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int max = scrollBar1.getMaximum() - scrollBar1.getThumb();
                double v = 0.0;
                if (max > 0) {
                    v = (double)scrollBar1.getSelection() / (double)max;
                }
                if (table2.isVisible()) {
                    ScrollBar scrollBar2 = table2.getVerticalBar();
                    scrollBar2.setSelection((int)((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * v));
                }
                if (table3 != null && table3.isVisible()) {
                    ScrollBar scrollBar3 = table3.getVerticalBar();
                    scrollBar3.setSelection((int)((double)(scrollBar3.getMaximum() - scrollBar3.getThumb()) * v));
                }
                if ("carbon".equals(SWT.getPlatform()) && ModelContentMergeViewer.this.getControl() != null && !ModelContentMergeViewer.this.getControl().isDisposed()) {
                    ModelContentMergeViewer.this.getControl().getDisplay().update();
                }
            }
        });
    }

    private void updateColors(IPreferenceStore comparePreferences) {
        RGB highlightColor = PreferenceConverter.getColor((IPreferenceStore)comparePreferences, (String)"highlight.color");
        RGB changedColor = PreferenceConverter.getColor((IPreferenceStore)comparePreferences, (String)"changed.color");
        RGB conflictingColor = PreferenceConverter.getColor((IPreferenceStore)comparePreferences, (String)"conflicting.color");
        RGB addedColor = PreferenceConverter.getColor((IPreferenceStore)comparePreferences, (String)"added.color");
        RGB removedColor = PreferenceConverter.getColor((IPreferenceStore)comparePreferences, (String)"removed.color");
        colors.put("highlight.color", highlightColor);
        colors.put("changed.color", changedColor);
        colors.put("conflicting.color", conflictingColor);
        colors.put("added.color", addedColor);
        colors.put("removed.color", removedColor);
    }

    private void updateDrawDiffMarkers(IPreferenceStore comparePreferences) {
        drawDiffMarkers = comparePreferences.getBoolean("viewer.draw.differences");
    }

    public class CenterCanvas
    extends AbstractCenterPart {
        public CenterCanvas(Composite parent) {
            super(parent);
        }

        public void doPaint(GC gc) {
            if (!ModelContentMergeViewer.shouldDrawDiffMarkers() || ModelContentMergeViewer.this.getInput() == null) {
                return;
            }
            List<ModelContentMergeTabItem> leftVisible = ModelContentMergeViewer.this.leftPart.getVisibleElements();
            List<ModelContentMergeTabItem> rightVisible = ModelContentMergeViewer.this.rightPart.getVisibleElements();
            List<DiffElement> visibleDiffs = this.retainVisibleDiffs(leftVisible, rightVisible);
            if (ModelContentMergeViewer.this.currentSelection.size() > 0 && ModelContentMergeViewer.this.currentSelection.get(0).eContainer() != null) {
                visibleDiffs.addAll(ModelContentMergeViewer.this.currentSelection);
            }
            for (DiffElement diff : visibleDiffs) {
                if (!this.hasLineBeDrawn(diff)) continue;
                ModelContentMergeTabItem leftUIItem = ModelContentMergeViewer.this.leftPart.getUIItem(diff);
                ModelContentMergeTabItem rightUIItem = ModelContentMergeViewer.this.rightPart.getUIItem(diff);
                this.drawLine(gc, leftUIItem, rightUIItem);
            }
        }

        protected boolean hasLineBeDrawn(DiffElement diff) {
            if (!(diff instanceof DiffGroup)) {
                ModelContentMergeTabItem leftUIItem = ModelContentMergeViewer.this.leftPart.getUIItem(diff);
                ModelContentMergeTabItem rightUIItem = ModelContentMergeViewer.this.rightPart.getUIItem(diff);
                return leftUIItem != null && rightUIItem != null;
            }
            return false;
        }
    }

    private class EditorPartListener
    implements ICompareEditorPartListener {
        private final ModelContentMergeTabFolder[] viewerParts;

        public EditorPartListener(ModelContentMergeTabFolder ... parts) {
            this.viewerParts = parts;
        }

        public void selectedTabChanged(int newIndex) {
            int i = 0;
            while (i < this.viewerParts.length) {
                this.viewerParts[i].setSelectedTab(newIndex);
                ++i;
            }
            this.updateCenter();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ModelContentMergeViewer.this.fireSelectionChanged(event);
        }

        public void updateCenter() {
            ModelContentMergeViewer.this.updateCenter();
        }
    }
}

