/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.Emfdiff2mpatchActivator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.TransformationLauncher;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.wizards.EmfdiffExportWizardTransformationPage;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractEmfdiffExportWizard
extends Wizard
implements INewWizard {
    private ComparisonSnapshot input = null;
    private EmfdiffExportWizardTransformationPage transformationPage;
    private MPatchModel mPatch;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Save as MPatch");
        this.setNeedsProgressMonitor(true);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ComparisonSnapshot) {
                ComparisonSnapshot inputSnapshot;
                this.input = inputSnapshot = (ComparisonSnapshot)obj;
            }
            ++n2;
        }
        if (this.input == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"No emfdiff given!", (String)"Cannot transform an emfdiff to MPatch if there is no emfdiff given!");
            throw new RuntimeException("Cannot transform an emfdiff to MPatch if there is no emfdiff given!");
        }
        this.initializeDefaultPageImageDescriptor();
    }

    protected abstract void initializeDefaultPageImageDescriptor();

    public boolean performFinish() {
        final boolean[] returnValue = new boolean[]{true};
        this.mPatch = null;
        final StringBuffer details = new StringBuffer();
        final List<IMPatchTransformation> transformations = this.transformationPage.getTransformations();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Creating...", 6 + transformations.size() * 2 + 2 + 2);
                    monitor.worked(2);
                    try {
                        AbstractEmfdiffExportWizard.this.mPatch = TransformationLauncher.transform(AbstractEmfdiffExportWizard.this.input, details, AbstractEmfdiffExportWizard.this.transformationPage.getSymbolicReferenceCreator(), AbstractEmfdiffExportWizard.this.transformationPage.getModelDescriptorCreator());
                    }
                    catch (Exception e) {
                        Emfdiff2mpatchActivator.getDefault().logError("Could not export MPatch!\n" + details.toString(), e);
                        MessageDialog.openError((Shell)AbstractEmfdiffExportWizard.this.getShell(), (String)"Transformation failed", (String)("The Transformation failed! Please see the error log for details.\nError message: " + e.getMessage()));
                        returnValue[0] = false;
                    }
                    monitor.worked(4);
                    if (returnValue[0]) {
                        StringBuffer result = new StringBuffer();
                        for (IMPatchTransformation transformation : transformations) {
                            try {
                                int transformationResult = transformation.transform(AbstractEmfdiffExportWizard.this.mPatch);
                                result.append(String.valueOf(transformation.getLabel()) + ": " + transformationResult + "\n");
                                monitor.worked(2);
                            }
                            catch (Exception e) {
                                Emfdiff2mpatchActivator.getDefault().logError("Error in Transformation: " + transformation.getLabel(), e);
                                result.append(String.valueOf(transformation.getLabel()) + ": " + e.getMessage() + "\n");
                            }
                        }
                        if (!AbstractEmfdiffExportWizard.this.validateMPatchWithMessage(AbstractEmfdiffExportWizard.this.mPatch, "MPatch cannot be validated successfully")) {
                            result.append("\nWarning: Validation of MPatch failed!\n");
                        }
                        monitor.worked(2);
                        if (result.length() > 0) {
                            result.insert(0, "Transformation results:\n\n");
                            result.append("\nContinue saving the resulting MPatch?\n('No' returns to the wizard)");
                            if (!MessageDialog.openQuestion((Shell)AbstractEmfdiffExportWizard.this.getShell(), (String)"MPatch creation results", (String)result.toString())) {
                                returnValue[0] = false;
                            }
                        }
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return returnValue[0];
    }

    protected final MPatchModel getMPatch() {
        return this.mPatch;
    }

    private boolean validateMPatchWithMessage(MPatchModel mpatch, String title) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)mpatch);
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            DiagnosticDialog.openProblem((Shell)this.getShell(), (String)title, (String)title, (Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.transformationPage = new EmfdiffExportWizardTransformationPage("MPatch Configuration");
        this.addPage((IWizardPage)this.transformationPage);
    }
}

