/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChangeKind implements Enumerator
{
    ADDITION(0, "Addition", "Addition"),
    DELETION(1, "Deletion", "Deletion"),
    CHANGE(2, "Change", "Change"),
    MOVE(3, "Move", "Move"),
    GROUP(4, "Group", "Group"),
    UNKNOWN(5, "Unknown", "Unknown");

    public static final String copyright = "Copyright (c) 2010, 2011 Technical University of Denmark.\r\nAll rights reserved. This program and the accompanying materials \r\nare made available under the terms of the Eclipse Public License v1.0 \r\nwhich accompanies this distribution, and is available at \r\nhttp://www.eclipse.org/legal/epl-v10.html \r\n\r\nContributors:\r\n   Patrick Koenemann, DTU Informatics - initial API and implementation";
    public static final int ADDITION_VALUE = 0;
    public static final int DELETION_VALUE = 1;
    public static final int CHANGE_VALUE = 2;
    public static final int MOVE_VALUE = 3;
    public static final int GROUP_VALUE = 4;
    public static final int UNKNOWN_VALUE = 5;
    private static final ChangeKind[] VALUES_ARRAY;
    public static final List<ChangeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChangeKind[]{ADDITION, DELETION, CHANGE, MOVE, GROUP, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChangeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeKind get(int value) {
        switch (value) {
            case 0: {
                return ADDITION;
            }
            case 1: {
                return DELETION;
            }
            case 2: {
                return CHANGE;
            }
            case 3: {
                return MOVE;
            }
            case 4: {
                return GROUP;
            }
            case 5: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ChangeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

