/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchScope
implements IMatchScope {
    private final Set<Resource> resourcesInScope = new LinkedHashSet<Resource>();
    private final Set<EObject> eObjectsInScope = new LinkedHashSet<EObject>();

    public GenericMatchScope(EObject eObject) {
        this.eObjectsInScope.add(eObject);
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            this.eObjectsInScope.add(next);
            if (next.eResource() == null || this.resourcesInScope.contains(next.eResource())) continue;
            this.resolveAll(next.eResource().getResourceSet());
            this.addToScope(next.eResource());
        }
    }

    public GenericMatchScope(Resource scope) {
        this.resolveAll(scope.getResourceSet());
        this.addToScope(scope);
    }

    public GenericMatchScope(ResourceSet scope) {
        this.resolveAll(scope);
        for (Resource res : scope.getResources()) {
            this.addToScope(res);
        }
    }

    @Override
    public boolean isInScope(EObject eObject) {
        if (this.eObjectsInScope.contains(eObject)) {
            return true;
        }
        Resource resource = this.getContainingResource(eObject);
        if (resource == null) {
            return false;
        }
        boolean inScope = this.isInScope(resource);
        if (inScope) {
            this.eObjectsInScope.add(eObject);
        }
        return inScope;
    }

    protected void addToScope(Resource newResource) {
        this.resourcesInScope.add(newResource);
    }

    private Resource getContainingResource(EObject eObject) {
        if (eObject.eResource() != null) {
            return eObject.eResource();
        }
        for (Resource resourceInScope : this.resourcesInScope) {
            if (!ModelUtils.contains((Resource)resourceInScope, (EObject)eObject)) continue;
            return resourceInScope;
        }
        return null;
    }

    @Override
    public boolean isInScope(Resource resource) {
        return this.resourcesInScope.contains(resource);
    }

    public List<Resource> getResourcesInScope() {
        return new ArrayList<Resource>(this.resourcesInScope);
    }

    protected void resolveAll(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return;
        }
        HashSet<Object> originalSet = new HashSet<Resource>((Collection<Resource>)resourceSet.getResources());
        this.resolveAll(originalSet);
        HashSet newSet = new HashSet(resourceSet.getResources());
        Sets.SetView delta = Sets.difference(newSet, originalSet);
        while (delta.size() > 0) {
            originalSet = newSet;
            this.resolveAll((Set<Resource>)delta);
            newSet = new HashSet(resourceSet.getResources());
            delta = Sets.difference(newSet, originalSet);
        }
    }

    private void resolveAll(Set<Resource> resources) {
        for (Resource current : resources) {
            for (EObject eObject : current.getContents()) {
                this.resolveCrossReferences(eObject);
                TreeIterator childContent = eObject.eAllContents();
                while (childContent.hasNext()) {
                    EObject child = (EObject)childContent.next();
                    if (child.eResource() != current) {
                        childContent.prune();
                        continue;
                    }
                    this.resolveCrossReferences(child);
                }
            }
        }
    }

    private void resolveCrossReferences(EObject eObject) {
        Iterator objectChildren = eObject.eCrossReferences().iterator();
        while (objectChildren.hasNext()) {
            objectChildren.next();
        }
    }
}

