/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.mergeviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiagramShowHideElement;
import org.eclipse.emf.compare.diagram.ui.GMFComparePlugin;
import org.eclipse.emf.compare.diagram.ui.mergeviewer.GMFContentMergeTabFolder;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFContentMergeViewerTab
implements IModelContentMergeViewerTab {
    private static final double ZOOM_FACTOR = 0.7;
    protected GMFContentMergeTabFolder contentMergeTabFolderParent;
    private DiagramGraphicalViewer viewer;
    private int partSide;
    private Diagram currentDiag;
    private DiagramEditDomain editDomain;

    public GMFContentMergeViewerTab(Composite parent, int side, GMFContentMergeTabFolder parentFolder) {
        this.contentMergeTabFolderParent = parentFolder;
        this.partSide = side;
        this.editDomain = new DiagramEditDomain(null);
        this.editDomain.setCommandStack((CommandStack)new DiagramCommandStack((IDiagramEditDomain)this.editDomain));
        this.createDiagramGraphicalViewer(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void dispose() {
        this.currentDiag = null;
        this.editDomain = null;
        this.viewer = null;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public List<? extends Item> getSelectedElements() {
        return this.contentMergeTabFolderParent.getTreePart().getSelectedElements();
    }

    public ModelContentMergeTabItem getUIItem(EObject data) {
        return this.contentMergeTabFolderParent.getTreePart().getUIItem(data);
    }

    public List<ModelContentMergeTabItem> getVisibleElements() {
        return this.contentMergeTabFolderParent.getTreePart().getVisibleElements();
    }

    public void redraw() {
        this.viewer.getControl().redraw();
        if (this.viewer.getContents() != null) {
            this.viewer.getContents().refresh();
        }
    }

    public void setReflectiveInput(Object input) {
        String inputName = this.getName(input);
        Resource resource = this.loadResource(input, inputName);
        if (resource == null) {
            return;
        }
        this.displayDiagram(this.getDiagramFromResource(resource));
        this.contentMergeTabFolderParent.getTreePart().setReflectiveInput(input);
        this.contentMergeTabFolderParent.getPropertyPart().setReflectiveInput(input);
        this.redraw();
    }

    public void showItems(List<DiffElement> items) {
        this.viewer.deselectAll();
        ArrayList<EditPart> datas = new ArrayList<EditPart>();
        for (DiffElement diffElement : items) {
            EditPart part;
            EObject eobj = null;
            if (!(diffElement instanceof DiffGroup)) {
                if (this.partSide == 3) {
                    eobj = this.getAncestorElement(diffElement);
                } else if (this.partSide == 1) {
                    eobj = this.getLeftElement(diffElement);
                } else if (this.partSide == 2) {
                    eobj = this.getRightElement(diffElement);
                }
            }
            if ((part = this.findEditPart(eobj)) == null) continue;
            while (!part.isSelectable()) {
                part = part.getParent();
            }
            datas.add(part);
        }
        if (!datas.isEmpty()) {
            this.viewer.setSelection((ISelection)new StructuredSelection(datas));
            this.viewer.reveal((EditPart)datas.get(0));
        }
        this.redraw();
    }

    public EditPart findEditPart(EObject eobj) {
        if (eobj instanceof View) {
            Diagram d = ((View)eobj).getDiagram();
            this.checkAndDisplayDiagram(d);
        }
        return (EditPart)this.viewer.getEditPartRegistry().get(eobj);
    }

    private void checkAndDisplayDiagram(Diagram d) {
        if (d != null && !d.equals(this.currentDiag)) {
            this.currentDiag = d;
            this.displayDiagram(d);
        }
    }

    private EObject getRightElement(DiffElement diffElement) {
        EObject eobj = EMFCompareEObjectUtils.getRightElement((EObject)diffElement);
        if (!GMFComparePlugin.isValid(eobj)) {
            if (diffElement instanceof BusinessDiagramShowHideElement) {
                eobj = ((BusinessDiagramShowHideElement)diffElement).getRightView();
            } else if (eobj instanceof Diagram) {
                this.checkAndDisplayDiagram((Diagram)eobj);
            } else {
                return null;
            }
        }
        return eobj;
    }

    private EObject getLeftElement(DiffElement diffElement) {
        EObject eobj = EMFCompareEObjectUtils.getLeftElement((EObject)diffElement);
        if (!GMFComparePlugin.isValid(eobj)) {
            if (diffElement instanceof BusinessDiagramShowHideElement) {
                eobj = ((BusinessDiagramShowHideElement)diffElement).getLeftView();
            } else if (eobj instanceof Diagram) {
                this.checkAndDisplayDiagram((Diagram)eobj);
            } else {
                return null;
            }
        }
        return eobj;
    }

    private EObject getAncestorElement(DiffElement diffElement) {
        EObject eobj = EMFCompareEObjectUtils.getAncestorElement((EObject)this.contentMergeTabFolderParent.findMatchFromElement(EMFCompareEObjectUtils.getLeftElement((EObject)diffElement)));
        if (!GMFComparePlugin.isValid(eobj)) {
            if (eobj instanceof Diagram) {
                this.checkAndDisplayDiagram((Diagram)eobj);
            } else {
                return null;
            }
        }
        return eobj;
    }

    private void createDiagramGraphicalViewer(Composite composite) {
        this.viewer = new DiagramGraphicalViewer();
        this.viewer.createControl(composite);
        this.viewer.setEditDomain((EditDomain)this.editDomain);
        this.viewer.setEditPartFactory((EditPartFactory)EditPartService.getInstance());
        this.viewer.getControl().setBackground(ColorConstants.listBackground);
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public Diagram getDiagramFromResource(Resource resource) {
        for (Object rootElement : resource.getContents()) {
            if (!(rootElement instanceof Diagram)) continue;
            return (Diagram)rootElement;
        }
        return null;
    }

    private Resource loadResource(Object object, String objectName) {
        Resource res = null;
        if (object instanceof List && !((List)object).isEmpty()) {
            res = this.loadResource(((List)object).get(0), objectName);
        } else if (object instanceof Resource) {
            res = (Resource)object;
        } else {
            EMFComparePlugin.log((String)"unsupported unput type", (boolean)false);
        }
        return res;
    }

    private String getName(Object object) {
        String res = "";
        if (object instanceof ResourceNode) {
            res = URI.createPlatformResourceURI((String)((ResourceNode)object).getResource().getFullPath().toString(), (boolean)true).toString();
        } else if (object instanceof Resource) {
            res = ((Resource)object).getURI().lastSegment();
        } else if (object instanceof ITypedElement) {
            res = ((ITypedElement)object).getName();
        } else if (object instanceof List && !((List)object).isEmpty()) {
            res = this.getName(((List)object).get(0));
        }
        return res;
    }

    protected final void displayDiagram(Diagram diag) {
        if (diag == null) {
            return;
        }
        this.currentDiag = diag;
        DiagramRootEditPart rootEditPart = new DiagramRootEditPart(diag.getMeasurementUnit());
        this.viewer.setRootEditPart((RootEditPart)rootEditPart);
        this.viewer.setContents((Object)diag);
        this.disableEditMode((DiagramEditPart)this.viewer.getContents());
        rootEditPart.getZoomManager().setZoomAnimationStyle(0);
        rootEditPart.getZoomManager().setZoom(0.7);
    }

    private void disableEditMode(DiagramEditPart diagEditPart) {
        diagEditPart.disableEditMode();
        for (Object obj : diagEditPart.getPrimaryEditParts()) {
            if (!(obj instanceof IGraphicalEditPart)) continue;
            this.disableEditMode((IGraphicalEditPart)obj);
        }
    }

    private void disableEditMode(IGraphicalEditPart obj) {
        obj.disableEditMode();
        obj.removeEditPolicy((Object)"OpenPolicy");
        for (Object child : obj.getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            this.disableEditMode((IGraphicalEditPart)child);
        }
    }

    public ISelectionProvider getViewer() {
        return this.viewer;
    }
}

