/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.internal.wizard;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class SaveDeltaWizard
extends BasicNewFileResourceWizard {
    private final String fileExtension;
    private ComparisonSnapshot input;

    public SaveDeltaWizard(String extension) {
        this.fileExtension = extension == null ? "emfdiff" : extension;
    }

    public void addPages() {
        super.addPages();
        WizardNewFileCreationPage wizardNewFileCreationPage = (WizardNewFileCreationPage)this.getPage("newFilePage1");
        wizardNewFileCreationPage.setFileName("result." + this.fileExtension);
        wizardNewFileCreationPage.setAllowExistingResources(true);
    }

    public void init(IWorkbench workbench, ComparisonSnapshot inputSnapshot) {
        super.init(workbench, (IStructuredSelection)new StructuredSelection());
        this.input = (ComparisonSnapshot)EcoreUtil.copy((EObject)inputSnapshot);
    }

    public boolean performFinish() {
        IFile createdFile;
        boolean result = false;
        String fileName = ((WizardNewFileCreationPage)this.getPage("newFilePage1")).getFileName();
        if (!fileName.endsWith(this.fileExtension)) {
            ((WizardNewFileCreationPage)this.getPage("newFilePage1")).setFileName(String.valueOf(fileName) + '.' + this.fileExtension);
        }
        if ((createdFile = ((WizardNewFileCreationPage)this.getPage("newFilePage1")).createNewFile()) != null) {
            try {
                if (this.input instanceof ComparisonResourceSnapshot) {
                    ComparisonResourceSnapshot modelInputSnapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
                    modelInputSnapshot.setDiff(((ComparisonResourceSnapshot)this.input).getDiff());
                    modelInputSnapshot.setMatch(((ComparisonResourceSnapshot)this.input).getMatch());
                    modelInputSnapshot.setDate(Calendar.getInstance(Locale.getDefault()).getTime());
                    ModelUtils.save((EObject)modelInputSnapshot, (String)createdFile.getLocation().toOSString());
                } else {
                    ComparisonResourceSetSnapshot modelInputSnapshot = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
                    modelInputSnapshot.setDiffResourceSet(((ComparisonResourceSetSnapshot)this.input).getDiffResourceSet());
                    modelInputSnapshot.setMatchResourceSet(((ComparisonResourceSetSnapshot)this.input).getMatchResourceSet());
                    modelInputSnapshot.setDate(Calendar.getInstance(Locale.getDefault()).getTime());
                    ModelUtils.save((EObject)modelInputSnapshot, (String)createdFile.getLocation().toOSString());
                }
                createdFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                EMFComparePlugin.log((Exception)e, (boolean)false);
            }
            catch (CoreException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
            result = true;
        }
        return result;
    }
}

