/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.impl;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.impl.AttributeChangeImpl;
import org.eclipse.emf.compare.impl.ConflictImpl;
import org.eclipse.emf.compare.impl.DiffImpl;
import org.eclipse.emf.compare.impl.EquivalenceImpl;
import org.eclipse.emf.compare.impl.MatchImpl;
import org.eclipse.emf.compare.impl.MatchResourceImpl;
import org.eclipse.emf.compare.impl.ReferenceChangeImpl;
import org.eclipse.emf.compare.impl.ResourceAttachmentChangeImpl;
import org.eclipse.emf.compare.internal.spec.ComparisonSpec;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class CompareFactoryImpl
extends EFactoryImpl
implements CompareFactory {
    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";

    public static CompareFactory init() {
        try {
            CompareFactory theCompareFactory = (CompareFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/compare");
            if (theCompareFactory != null) {
                return theCompareFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CompareFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createComparison();
            }
            case 1: {
                return this.createMatchResource();
            }
            case 2: {
                return this.createMatch();
            }
            case 3: {
                return this.createDiff();
            }
            case 4: {
                return this.createResourceAttachmentChange();
            }
            case 5: {
                return this.createReferenceChange();
            }
            case 6: {
                return this.createAttributeChange();
            }
            case 7: {
                return this.createConflict();
            }
            case 8: {
                return this.createEquivalence();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createDifferenceKindFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createDifferenceSourceFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertDifferenceKindToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertDifferenceSourceToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Comparison createComparison() {
        ComparisonSpec comparison = new ComparisonSpec();
        return comparison;
    }

    public MatchResource createMatchResource() {
        MatchResourceImpl matchResource = new MatchResourceImpl();
        return matchResource;
    }

    public Match createMatch() {
        MatchImpl match = new MatchImpl();
        return match;
    }

    public Diff createDiff() {
        DiffImpl diff = new DiffImpl();
        return diff;
    }

    public ResourceAttachmentChange createResourceAttachmentChange() {
        ResourceAttachmentChangeImpl resourceAttachmentChange = new ResourceAttachmentChangeImpl();
        return resourceAttachmentChange;
    }

    public ReferenceChange createReferenceChange() {
        ReferenceChangeImpl referenceChange = new ReferenceChangeImpl();
        return referenceChange;
    }

    public AttributeChange createAttributeChange() {
        AttributeChangeImpl attributeChange = new AttributeChangeImpl();
        return attributeChange;
    }

    public Conflict createConflict() {
        ConflictImpl conflict = new ConflictImpl();
        return conflict;
    }

    public Equivalence createEquivalence() {
        EquivalenceImpl equivalence = new EquivalenceImpl();
        return equivalence;
    }

    public DifferenceKind createDifferenceKindFromString(EDataType eDataType, String initialValue) {
        DifferenceKind result = DifferenceKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDifferenceKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DifferenceSource createDifferenceSourceFromString(EDataType eDataType, String initialValue) {
        DifferenceSource result = DifferenceSource.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDifferenceSourceToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ComparePackage getComparePackage() {
        return (ComparePackage)this.getEPackage();
    }

    @Deprecated
    public static ComparePackage getPackage() {
        return ComparePackage.eINSTANCE;
    }
}

