/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.ComparisonImpl;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSpec
extends ComparisonImpl {
    @Override
    public EList<Diff> getDifferences() {
        Iterable diffIterable = Lists.newArrayList();
        EList<Match> mappings = this.getMatches();
        int i = 0;
        while (i < mappings.size()) {
            diffIterable = Iterables.concat((Iterable)diffIterable, ComparisonSpec.getDifferences((Match)mappings.get(i)));
            ++i;
        }
        BasicEList allDifferences = new BasicEList();
        for (Diff diff : diffIterable) {
            ((AbstractEList)allDifferences).addUnique((Object)diff);
        }
        return allDifferences;
    }

    @Override
    public EList<Diff> getDifferences(EObject element) {
        return this.getMatch(element).getDifferences();
    }

    @Override
    public void addDiff(EObject element, Diff newDiff) {
        Match match = this.getMatch(element);
        match.getDifferences().add((Object)newDiff);
    }

    @Override
    public Match getMatch(EObject element) {
        if (element == null) {
            return null;
        }
        ArrayList path = Lists.newArrayList((Object[])new EObject[]{element});
        EObject container = element.eContainer();
        while (container != null) {
            path.add(container);
            container = container.eContainer();
        }
        ListIterator pathIterator = path.listIterator(path.size());
        EObject currentEObject = (EObject)pathIterator.previous();
        EList<Match> rootMatches = this.getMatches();
        Match currentMatch = null;
        int i = 0;
        while (i < rootMatches.size() && currentMatch == null) {
            Match root = (Match)rootMatches.get(i);
            if (root.getLeft() == currentEObject || root.getRight() == currentEObject || root.getOrigin() == currentEObject) {
                currentMatch = root;
            }
            ++i;
        }
        while (pathIterator.hasPrevious() && currentMatch != null) {
            currentEObject = (EObject)pathIterator.previous();
            currentMatch = ComparisonSpec.getMatch(currentMatch, currentEObject);
        }
        return currentMatch;
    }

    private static Match getMatch(Match parent, EObject element) {
        Match submatch = null;
        int i = 0;
        while (i < parent.getSubMatches().size() && submatch == null) {
            Match child = (Match)parent.getSubMatches().get(i);
            if (child.getLeft() == element || child.getRight() == element || child.getOrigin() == element) {
                submatch = child;
            }
            ++i;
        }
        return submatch;
    }

    private static Iterable<Diff> getDifferences(Match match) {
        Iterable differences = Lists.newArrayList(match.getDifferences());
        EList<Match> submappings = match.getSubMatches();
        int i = 0;
        while (i < submappings.size()) {
            differences = Iterables.concat((Iterable)differences, ComparisonSpec.getDifferences((Match)submappings.get(i)));
            ++i;
        }
        return differences;
    }
}

