/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.ResourceMapping;
import org.eclipse.emf.compare.match.resource.StrategyResourceMatcher;
import org.eclipse.emf.compare.scope.AbstractComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractMatchEngine {
    private Comparison comparison;
    private final AbstractComparisonScope scope;

    public AbstractMatchEngine(AbstractComparisonScope scope) {
        this.scope = scope;
    }

    public Comparison match() {
        Notifier left = this.getScope().getLeft();
        Notifier right = this.getScope().getRight();
        Notifier origin = this.getScope().getOrigin();
        this.match(left, right, origin);
        return this.getComparison();
    }

    protected void match(Notifier left, Notifier right, Notifier origin) {
        throw new UnsupportedOperationException();
    }

    protected void match(ResourceSet left, ResourceSet right, ResourceSet origin) {
        Iterator<? extends Resource> leftChildren = this.getScope().getChildren(left);
        Iterator<? extends Resource> rightChildren = this.getScope().getChildren(right);
        Object originChildren = origin != null ? this.getScope().getChildren(origin) : Iterators.emptyIterator();
        IResourceMatcher matcher = this.getResourceMatcher();
        Iterable<ResourceMapping> mappings = matcher.createMappings(leftChildren, rightChildren, (Iterator<? extends Resource>)originChildren);
        for (ResourceMapping mapping : mappings) {
            MatchResource matchResource = CompareFactory.eINSTANCE.createMatchResource();
            if (mapping.getLeft() != null && mapping.getLeft().getURI() != null) {
                matchResource.setLeftURI(mapping.getLeft().getURI().toString());
            }
            if (mapping.getRight() != null && mapping.getRight().getURI() != null) {
                matchResource.setRightURI(mapping.getRight().getURI().toString());
            }
            if (mapping.getOrigin() != null && mapping.getOrigin().getURI() != null) {
                matchResource.setOriginURI(mapping.getOrigin().getURI().toString());
            }
            this.getComparison().getMatchedResources().add((Object)matchResource);
            this.match(mapping.getLeft(), mapping.getRight(), mapping.getOrigin());
        }
    }

    protected void match(Resource left, Resource right, Resource origin) {
        if (AbstractMatchEngine.atLeastTwo(left == null, right == null, origin == null)) {
            return;
        }
        Object leftEObjects = left != null ? this.getScope().getChildren(left) : Iterators.emptyIterator();
        Object rightEObjects = right != null ? this.getScope().getChildren(right) : Iterators.emptyIterator();
        Object originEObjects = origin != null ? this.getScope().getChildren(origin) : Iterators.emptyIterator();
        IEObjectMatcher matcher = this.createEObjectMatcher();
        matcher.createMatches((Iterator<? extends EObject>)leftEObjects, (Iterator<? extends EObject>)rightEObjects, (Iterator<? extends EObject>)originEObjects);
    }

    protected void match(EObject left, EObject right, EObject origin) {
        if (left == null || right == null) {
            throw new IllegalArgumentException();
        }
        Iterator<? extends EObject> leftEObjects = this.getScope().getChildren(left);
        Iterator<? extends EObject> rightEObjects = this.getScope().getChildren(right);
        Object originEObjects = origin != null ? this.getScope().getChildren(origin) : Iterators.emptyIterator();
        IEObjectMatcher matcher = this.createEObjectMatcher();
        matcher.createMatches(leftEObjects, rightEObjects, (Iterator<? extends EObject>)originEObjects);
    }

    protected IResourceMatcher getResourceMatcher() {
        return new StrategyResourceMatcher();
    }

    protected IEObjectMatcher createEObjectMatcher() {
        return new IdentifierEObjectMatcher();
    }

    protected Comparison getComparison() {
        if (this.comparison == null) {
            this.comparison = CompareFactory.eINSTANCE.createComparison();
        }
        return this.comparison;
    }

    protected AbstractComparisonScope getScope() {
        return this.scope;
    }

    protected static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }
}

