/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.compare.match.resource.NameMatchingStrategy;
import org.eclipse.emf.compare.match.resource.ResourceMapping;
import org.eclipse.emf.compare.match.resource.RootIDMatchingStrategy;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyResourceMatcher
implements IResourceMatcher {
    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<ResourceMapping> createMappings(Iterator<? extends Resource> leftResources, Iterator<? extends Resource> rightResources, Iterator<? extends Resource> originResources) {
        List<Object> mappings;
        ArrayList leftCopy = Lists.newArrayList(leftResources);
        ArrayList rightCopy = Lists.newArrayList(rightResources);
        ArrayList originCopy = Lists.newArrayList(originResources);
        IResourceMatchingStrategy[] strategies = this.getResourceMatchingStrategies();
        if (strategies.length == 1) {
            mappings = strategies[0].matchResources(leftCopy, rightCopy, originCopy);
            for (ResourceMapping resourceMapping : mappings) {
                leftCopy.remove(resourceMapping.getLeft());
                rightCopy.remove(resourceMapping.getRight());
                originCopy.remove(resourceMapping.getOrigin());
            }
        } else {
            void var9_12;
            mappings = Lists.newArrayList();
            boolean bl = false;
            while (var9_12 < strategies.length && !StrategyResourceMatcher.atLeastTwo(leftCopy.isEmpty(), rightCopy.isEmpty(), originCopy.isEmpty())) {
                List<ResourceMapping> newMappings = strategies[var9_12].matchResources(leftCopy, rightCopy, originCopy);
                for (ResourceMapping newMapping : newMappings) {
                    leftCopy.remove(newMapping.getLeft());
                    rightCopy.remove(newMapping.getRight());
                    originCopy.remove(newMapping.getOrigin());
                }
                mappings.addAll(newMappings);
                ++var9_12;
            }
        }
        for (Resource resource : leftCopy) {
            mappings.add(new ResourceMapping(resource, null, null));
        }
        for (Resource resource : rightCopy) {
            mappings.add(new ResourceMapping(null, resource, null));
        }
        for (Resource resource : originCopy) {
            mappings.add(new ResourceMapping(null, null, resource));
        }
        return mappings;
    }

    protected static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }

    protected IResourceMatchingStrategy[] getResourceMatchingStrategies() {
        NameMatchingStrategy nameStrategy = new NameMatchingStrategy();
        RootIDMatchingStrategy idStrategy = new RootIDMatchingStrategy();
        return new IResourceMatchingStrategy[]{nameStrategy, idStrategy};
    }
}

