/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";

    private ModelUtils() {
    }

    public static EObject load(File file, ResourceSet resourceSet) throws IOException {
        return ModelUtils.load(URI.createFileURI((String)file.getPath()), resourceSet);
    }

    public static EObject load(InputStream stream, String fileName, ResourceSet resourceSet) throws IOException {
        if (stream == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullInputStream"));
        }
        EObject result = null;
        Resource modelResource = resourceSet.createResource(URI.createURI((String)fileName));
        modelResource.load(stream, Collections.emptyMap());
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static EObject load(String path, ResourceSet resourceSet) throws IOException {
        EObject result;
        if (path == null || "".equals(path)) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("ModelUtils.NullPath"));
        }
        if (path.startsWith("platform")) {
            result = ModelUtils.load(URI.createURI((String)path), resourceSet);
        } else {
            EObject temp = null;
            try {
                temp = ModelUtils.load(URI.createPlatformPluginURI((String)path, (boolean)true), resourceSet);
            }
            catch (IOException iOException) {
                try {
                    temp = ModelUtils.load(URI.createPlatformResourceURI((String)path, (boolean)true), resourceSet);
                }
                catch (IOException iOException2) {}
            }
            result = temp;
        }
        if (result == null) {
            throw new IOException(EMFCompareMessages.getString("ModelUtils.LoadFailure", path));
        }
        return result;
    }

    public static EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        EObject result = null;
        Resource modelResource = resourceSet.getResource(modelURI, true);
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullSaveRoot"));
        }
        EObject copyRoot = EcoreUtil.copy((EObject)root);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource newResource = resourceSet.createResource(URI.createFileURI((String)"resource.xml"));
        newResource.getContents().add((Object)copyRoot);
        StringWriter writer = new StringWriter();
        HashMap options = Maps.newHashMap();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        ((XMLResource)copyRoot.eResource()).save((Writer)writer, (Map)options);
        String result = writer.toString();
        writer.flush();
        return result;
    }
}

