/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EObjectMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IEObjectAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class EObjectContentMergeViewer
extends ContentMergeViewer {
    private static final String BUNDLE_NAME = "org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EObjectContentMergeViewer";
    private TreeViewer fAncestorViewer;
    private TreeViewer fLeftViewer;
    private TreeViewer fRightViewer;
    private final AdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public EObjectContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new EObjectMergeViewerContentProvider(config));
    }

    protected void createControls(Composite parent) {
        this.fAncestorViewer = this.createViewer(parent);
        this.fLeftViewer = this.createViewer(parent);
        this.fRightViewer = this.createViewer(parent);
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent);
        viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.fAdapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.fAdapterFactory));
        return viewer;
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.fAncestorViewer.getControl().setVisible(true);
            this.fAncestorViewer.getControl().setBounds(x, y, width, height);
        } else {
            this.fAncestorViewer.getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeftViewer.getControl().setBounds(x, y, width1, height);
        this.fRightViewer.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        if (ancestor instanceof IEObjectAccessor) {
            EObject ancestorEObject = ((IEObjectAccessor)ancestor).getEObject();
            this.fAncestorViewer.setInput(EObjectContentMergeViewer.doGetInput(ancestorEObject));
        } else {
            this.fAncestorViewer.setInput(null);
        }
        if (left instanceof IEObjectAccessor) {
            EObject leftEObject = ((IEObjectAccessor)left).getEObject();
            this.fLeftViewer.setInput(EObjectContentMergeViewer.doGetInput(leftEObject));
        } else {
            this.fLeftViewer.setInput(null);
        }
        if (right instanceof IEObjectAccessor) {
            EObject rightEObject = ((IEObjectAccessor)right).getEObject();
            this.fRightViewer.setInput(EObjectContentMergeViewer.doGetInput(rightEObject));
        } else {
            this.fRightViewer.setInput(null);
        }
    }

    private static Object doGetInput(EObject eObject) {
        Object input = null;
        if (eObject != null) {
            input = eObject.eContainer() != null ? eObject.eContainer() : eObject.eResource();
        }
        return input;
    }

    protected void copy(boolean leftToRight) {
    }

    protected byte[] getContents(boolean left) {
        return null;
    }
}

