/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffElement;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEDiffContainer
extends AbstractEDiffElement
implements IDiffContainer {
    private static final IDiffElement[] EMPTY_ARRAY__DIFF_ELEMENT = new IDiffElement[0];
    private final Predicate<Object> fNeedDisplay = new Predicate<Object>(){

        public boolean apply(Object input) {
            if (input instanceof IDiffContainer) {
                return ((IDiffContainer)input).hasChildren();
            }
            return true;
        }
    };

    public AbstractEDiffContainer(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public boolean hasChildren() {
        Adapter treeItemContentProvider;
        boolean ret = false;
        if (this.target instanceof EObject && (treeItemContentProvider = this.getAdapterFactory().adapt(this.target, ITreeItemContentProvider.class)) instanceof ITreeItemContentProvider) {
            ArrayList children = Lists.newArrayList((Object[])this.getChildren());
            Iterable notMatchChildren = Iterables.filter((Iterable)children, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(MatchNode.class)));
            ret = !Iterables.isEmpty((Iterable)notMatchChildren) ? true : AbstractEDiffContainer.hasChildren(notMatchChildren);
        }
        return ret;
    }

    private static boolean hasChildren(Iterable<IDiffElement> elements) {
        boolean ret = false;
        for (IDiffElement child : elements) {
            if (!(child instanceof IDiffContainer) || !((IDiffContainer)child).hasChildren()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public IDiffElement[] getChildren() {
        Adapter treeItemContentProvider;
        IDiffElement[] ret = EMPTY_ARRAY__DIFF_ELEMENT;
        if (this.target instanceof EObject && (treeItemContentProvider = this.getAdapterFactory().adapt(this.target, ITreeItemContentProvider.class)) instanceof ITreeItemContentProvider) {
            Collection children = ((ITreeItemContentProvider)treeItemContentProvider).getChildren((Object)this.target);
            Iterable childrenToDisplay = Iterables.filter((Iterable)children, this.fNeedDisplay);
            ret = (IDiffElement[])Iterables.toArray(AbstractEDiffContainer.adapt(childrenToDisplay, this.getAdapterFactory(), IDiffElement.class), IDiffElement.class);
        }
        return ret;
    }

    public void add(IDiffElement child) {
        throw new UnsupportedOperationException();
    }

    public void removeToRoot(IDiffElement child) {
        throw new UnsupportedOperationException();
    }

    private static <T> Iterable<T> adapt(Iterable<?> iterable, final AdapterFactory adapterFactory, final Class<T> type) {
        Function<Object, Object> adaptFunction = new Function<Object, Object>(){

            public Object apply(Object input) {
                return adapterFactory.adapt(input, (Object)type);
            }
        };
        return Iterables.filter((Iterable)Iterables.transform(iterable, (Function)adaptFunction), type);
    }
}

