/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractEDiffElement
extends AdapterImpl
implements IDiffElement {
    private final AdapterFactory fAdapterFactory;

    public AbstractEDiffElement(AdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.fAdapterFactory;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    public String getName() {
        String ret = null;
        Adapter adapter = this.getAdapterFactory().adapt(this.target, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            ret = ((IItemLabelProvider)adapter).getText((Object)this.target);
        }
        return ret;
    }

    public Image getImage() {
        Image ret = null;
        Adapter adapter = this.getAdapterFactory().adapt(this.target, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            Object imageObject = ((IItemLabelProvider)adapter).getImage((Object)this.target);
            ret = ExtendedImageRegistry.getInstance().getImage(imageObject);
        }
        return ret;
    }

    public String getType() {
        return null;
    }

    public int getKind() {
        return 0;
    }

    public IDiffContainer getParent() {
        Adapter treeItemContentProvider;
        IDiffContainer ret = null;
        if (this.target instanceof EObject && (treeItemContentProvider = this.getAdapterFactory().adapt(this.target, ITreeItemContentProvider.class)) instanceof ITreeItemContentProvider) {
            ret = this.getParentAndAdaptAsIDiffContainer((ITreeItemContentProvider)treeItemContentProvider);
        }
        return ret;
    }

    private IDiffContainer getParentAndAdaptAsIDiffContainer(ITreeItemContentProvider treeItemContentProvider) {
        Object diffContainer;
        IDiffContainer ret = null;
        Object parent = treeItemContentProvider.getParent((Object)this.target);
        if (parent instanceof EObject && (diffContainer = this.getAdapterFactory().adapt(parent, IDiffContainer.class)) instanceof IDiffContainer) {
            ret = (IDiffContainer)diffContainer;
        }
        return ret;
    }

    public void setParent(IDiffContainer parent) {
        throw new UnsupportedOperationException();
    }
}

