/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static IResource findIResource(Resource eResource) {
        URI uri = eResource.getURI();
        IResource iResource = null;
        if (uri != null) {
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.trimFragment().toPlatformString(true));
                iResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            } else {
                Path path = new Path(uri.trimFragment().path());
                iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            }
        }
        return iResource;
    }

    public static Resource loadResource(IFile file) {
        return ResourceUtil.loadResource(file, (ResourceSet)new ResourceSetImpl());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource loadResource(IFile file, ResourceSet resourceSet) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource existing = resourceSet.getResource(uri, false);
        if (existing != null) {
            return existing;
        }
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = resourceSet.createResource(uri);
            stream = file.getContents();
            resource.load(stream, Collections.emptyMap());
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }
}

