/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.logical;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.compare.ide.internal.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.logical.EMFResourceMapping;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public class EMFModelProvider
extends ModelProvider {
    public static final String PROVIDER_ID = "org.eclipse.emf.compare.model.provider";
    public static final String SYNCHRONIZATION_CACHE_KEY = "org.eclipse.emf.compare.model.provider.sync.cache";
    private static final String EMF_ADDITIONAL_MAPPINGS = "org.eclipse.emf.compare.model.provider.additional.mappings";

    public static void cacheAdditionalMappings(ISynchronizationContext context, ResourceMapping[] additionalMappings) {
        context.getCache().put(EMF_ADDITIONAL_MAPPINGS, (Object)additionalMappings);
    }

    public static ResourceMapping[] getAdditionalMappings(ISynchronizationContext context) {
        return (ResourceMapping[])context.getCache().get(EMF_ADDITIONAL_MAPPINGS);
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (resource instanceof IFile && resource.exists() && resource.isAccessible()) {
            IFile file = (IFile)resource;
            ArrayList<EMFResourceMapping> mappings = new ArrayList<EMFResourceMapping>();
            ResourceSetImpl logicalResourceSet = new ResourceSetImpl();
            Resource eResource = ResourceUtil.loadResource(file, (ResourceSet)logicalResourceSet);
            if (eResource != null) {
                mappings.add(new EMFResourceMapping(file, eResource, PROVIDER_ID));
            }
            return mappings.toArray(new ResourceMapping[mappings.size()]);
        }
        return super.getMappings(resource, context, monitor);
    }

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        return super.validateChange(delta, monitor);
    }
}

