/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.logical;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.internal.extension.EMFCompareExtensionRegistry;
import org.eclipse.emf.compare.ide.internal.extension.ModelResolverDescriptor;
import org.eclipse.emf.compare.ide.internal.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.ModelIdentifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFResourceMapping
extends ResourceMapping {
    public static final String REMOTE_RESOURCE_SCHEME = "remote";
    private final IFile file;
    private final Resource emfResource;
    private ResourceSet localResourceSet;
    private ResourceSet remoteResourceSet;
    private ResourceSet originResourceSet;
    private final String providerId;
    private Set<IResource> iResourcesInScope;
    private boolean isResolved;

    public EMFResourceMapping(IFile file, Resource emfResource, String providerId) {
        this.file = file;
        this.emfResource = emfResource;
        this.providerId = providerId;
        this.localResourceSet = emfResource.getResourceSet();
    }

    public Object getModelObject() {
        return this.emfResource;
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public IProject[] getProjects() {
        Set<IResource> physicalResources = this.resolvePhysicalResources();
        LinkedHashSet projects = Sets.newLinkedHashSet();
        for (IResource iResource : physicalResources) {
            projects.add(iResource.getProject());
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (!this.isResolved) {
            this.isResolved = true;
            this.resolveResourceSets(context, monitor);
        }
        ResourceTraversal traversal = new ResourceTraversal(this.iResourcesInScope.toArray(new IResource[this.iResourcesInScope.size()]), 1, 0);
        return new ResourceTraversal[]{traversal};
    }

    public void forceResolving(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        this.isResolved = false;
        this.remoteResourceSet = null;
        this.originResourceSet = null;
        this.iResourcesInScope = null;
        this.getTraversals(context, monitor);
    }

    public ResourceSet getLocalResourceSet() {
        return this.localResourceSet;
    }

    public ResourceSet getRemoteResourceSet() {
        return this.remoteResourceSet;
    }

    public ResourceSet getOriginResourceSet() {
        return this.originResourceSet;
    }

    private void resolveResourceSets(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        this.resolveLocalResourceSet();
        if (context instanceof RemoteResourceMappingContext) {
            RemoteResourceMappingContext remoteContext = (RemoteResourceMappingContext)context;
            for (Resource eResource : this.localResourceSet.getResources()) {
                RevisionedURIConverter converter;
                IFile localFile = eResource == this.emfResource ? this.file : (IFile)ResourceUtil.findIResource(eResource);
                IStorage remoteContents = remoteContext.fetchRemoteContents(localFile, monitor);
                IStorage originContents = remoteContext.fetchBaseContents(localFile, monitor);
                if (remoteContents != null) {
                    if (this.remoteResourceSet == null) {
                        this.remoteResourceSet = EMFResourceMapping.createRemoteResourceSet((IResource)localFile, remoteContents);
                    } else {
                        converter = (RevisionedURIConverter)this.remoteResourceSet.getURIConverter();
                        converter.setStorage(remoteContents);
                    }
                    EMFResourceMapping.loadRemoteResource(eResource.getURI(), remoteContents, this.remoteResourceSet);
                }
                if (originContents == null) continue;
                if (this.originResourceSet == null) {
                    this.originResourceSet = EMFResourceMapping.createRemoteResourceSet((IResource)localFile, originContents);
                } else {
                    converter = (RevisionedURIConverter)this.originResourceSet.getURIConverter();
                    converter.setStorage(originContents);
                }
                EMFResourceMapping.loadRemoteResource(eResource.getURI(), originContents, this.originResourceSet);
            }
            if (this.remoteResourceSet != null) {
                EcoreUtil.resolveAll((ResourceSet)this.remoteResourceSet);
            }
            if (this.originResourceSet != null) {
                EcoreUtil.resolveAll((ResourceSet)this.originResourceSet);
            }
        }
        this.resolvePhysicalResources();
    }

    private Set<IResource> resolvePhysicalResources() {
        IResource iResource;
        if (this.iResourcesInScope != null) {
            return this.iResourcesInScope;
        }
        this.iResourcesInScope = Sets.newLinkedHashSet();
        for (Resource eResource : this.localResourceSet.getResources()) {
            if (eResource == this.emfResource) {
                this.iResourcesInScope.add((IResource)this.file);
                continue;
            }
            iResource = ResourceUtil.findIResource(eResource);
            if (iResource == null) continue;
            this.iResourcesInScope.add(iResource);
        }
        if (this.remoteResourceSet != null) {
            for (Resource eResource : this.remoteResourceSet.getResources()) {
                iResource = ResourceUtil.findIResource(eResource);
                if (iResource == null) continue;
                this.iResourcesInScope.add(iResource);
            }
        }
        if (this.originResourceSet != null) {
            for (Resource eResource : this.originResourceSet.getResources()) {
                iResource = ResourceUtil.findIResource(eResource);
                if (iResource == null) continue;
                this.iResourcesInScope.add(iResource);
            }
        }
        return this.iResourcesInScope;
    }

    private void resolveLocalResourceSet() {
        Iterator<ModelResolverDescriptor> modelResolverIterator = EMFCompareExtensionRegistry.getRegisteredModelResolvers().iterator();
        boolean resolved = false;
        while (!resolved && modelResolverIterator.hasNext()) {
            ModelResolverDescriptor descriptor = modelResolverIterator.next();
            if (!descriptor.canResolve(new ModelIdentifier(new Resource[]{this.emfResource}))) continue;
            descriptor.getModelResolver().resolve(this.file, this.emfResource);
            resolved = true;
        }
        if (!resolved) {
            EcoreUtil.resolveAll((ResourceSet)this.localResourceSet);
        }
    }

    private static void loadRemoteResource(URI resourceURI, IStorage storage, ResourceSet resourceSet) throws CoreException {
        block15: {
            String resourcePath = resourceURI.path();
            if (resourceURI.isPlatform()) {
                resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
            }
            URI actualURI = URI.createURI((String)("remote:/" + resourcePath));
            Resource resource = resourceSet.createResource(actualURI);
            InputStream remoteStream = null;
            try {
                try {
                    remoteStream = storage.getContents();
                    resource.load(remoteStream, Collections.emptyMap());
                }
                catch (IOException iOException) {
                    if (remoteStream != null) {
                        try {
                            remoteStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (remoteStream != null) {
                    try {
                        remoteStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (remoteStream != null) {
                try {
                    remoteStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ResourceSet createRemoteResourceSet(IResource baseResource, IStorage storage) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(resourceSet.getURIConverter(), storage));
        return resourceSet;
    }
}

