/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiffEngine
implements IDiffEngine {
    protected static final Object UNMATCHED_VALUE = new Object();
    private Comparison currentComparison;
    private IDiffProcessor diffProcessor;

    @Override
    public void diff(Comparison comparison) {
        this.currentComparison = comparison;
        this.diffProcessor = this.createDiffProcessor();
        for (Match rootMatch : comparison.getMatches()) {
            this.checkForDifferences(rootMatch);
        }
    }

    protected void checkForDifferences(Match match) {
        FeatureFilter featureFilter = this.createFeatureFilter();
        Iterator<EReference> references = featureFilter.getReferencesToCheck(match);
        while (references.hasNext()) {
            EReference reference = references.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)reference);
            if (reference.isContainment()) {
                this.computeContainmentDifference(match, reference, considerOrdering);
                continue;
            }
            this.computeDifferences(match, reference, considerOrdering);
        }
        Iterator<EAttribute> attributes = featureFilter.getAttributesToCheck(match);
        while (attributes.hasNext()) {
            EAttribute attribute = attributes.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)attribute);
            this.computeDifferences(match, attribute, considerOrdering);
        }
        for (Match submatch : match.getSubmatches()) {
            this.checkForDifferences(submatch);
        }
    }

    protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
        if (match.getOrigin() == null && (match.getLeft() == null || match.getRight() == null)) {
            return;
        }
        if (!attribute.isMany()) {
            this.computeSingleValuedAttributeDifference(match, attribute);
        } else {
            this.computeMultiValuedAttributeDifferences(match, attribute, checkOrdering);
        }
    }

    protected void computeSingleValuedAttributeDifference(Match match, EAttribute attribute) {
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = match.getLeft().eGet((EStructuralFeature)attribute);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = match.getRight().eGet((EStructuralFeature)attribute);
        }
        if (this.matchingValues(leftValue, rightValue)) {
            return;
        }
        if (match.getOrigin() != null) {
            Object originValue = match.getOrigin().eGet((EStructuralFeature)attribute);
            if (this.matchingValues(leftValue, originValue)) {
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            } else if (this.matchingValues(rightValue, originValue)) {
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            } else {
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else {
            this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
        }
    }

    protected void computeMultiValuedAttributeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
        Iterable<Object> leftValues = DefaultDiffEngine.getValue(match.getLeft(), (EStructuralFeature)attribute);
        LinkedHashSet rightValues = Sets.newLinkedHashSet(DefaultDiffEngine.getValue(match.getRight(), (EStructuralFeature)attribute));
        LinkedHashSet originValues = Sets.newLinkedHashSet(DefaultDiffEngine.getValue(match.getOrigin(), (EStructuralFeature)attribute));
        for (Object left : leftValues) {
            Object rightMatch = this.findMatch(left, rightValues);
            if (rightMatch == UNMATCHED_VALUE) {
                Object originMatch = this.findMatch(left, originValues);
                if (originMatch != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, left, DifferenceKind.DELETE, DifferenceSource.RIGHT);
                    originValues.remove(originMatch);
                    continue;
                }
                this.getDiffProcessor().attributeChange(match, attribute, left, DifferenceKind.ADD, DifferenceSource.LEFT);
                continue;
            }
            rightValues.remove(rightMatch);
            originValues.remove(this.findMatch(left, originValues));
        }
        for (Object right : rightValues) {
            Object originMatch = this.findMatch(right, originValues);
            if (originMatch != UNMATCHED_VALUE || !this.getComparison().isThreeWay()) {
                this.getDiffProcessor().attributeChange(match, attribute, right, DifferenceKind.DELETE, DifferenceSource.LEFT);
                continue;
            }
            this.getDiffProcessor().attributeChange(match, attribute, right, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
    }

    protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
        Match valueMatch;
        Iterable leftValues = Iterables.filter(DefaultDiffEngine.getValue(match.getLeft(), (EStructuralFeature)reference), EObject.class);
        LinkedHashSet rightValues = Sets.newLinkedHashSet((Iterable)Iterables.filter(DefaultDiffEngine.getValue(match.getRight(), (EStructuralFeature)reference), EObject.class));
        HashSet originValues = Sets.newHashSet((Iterable)Iterables.filter(DefaultDiffEngine.getValue(match.getOrigin(), (EStructuralFeature)reference), EObject.class));
        for (EObject value : leftValues) {
            valueMatch = this.getComparison().getMatch(value);
            if (valueMatch == null) continue;
            EObject rightMatch = valueMatch.getRight();
            if (rightMatch == null || !rightValues.contains(rightMatch)) {
                boolean originHasMatch = originValues.contains(valueMatch.getOrigin());
                DifferenceKind kind = !reference.isMany() ? DifferenceKind.CHANGE : (originHasMatch ? DifferenceKind.DELETE : DifferenceKind.ADD);
                if (originHasMatch) {
                    this.getDiffProcessor().referenceChange(match, reference, value, kind, DifferenceSource.RIGHT);
                    continue;
                }
                this.getDiffProcessor().referenceChange(match, reference, value, kind, DifferenceSource.LEFT);
                continue;
            }
            rightValues.remove(rightMatch);
        }
        for (EObject value : rightValues) {
            valueMatch = this.getComparison().getMatch(value);
            if (valueMatch == null) continue;
            boolean originHasMatch = originValues.contains(valueMatch.getOrigin());
            if (!reference.isMany()) {
                this.getDiffProcessor().referenceChange(match, reference, value, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                continue;
            }
            if (originHasMatch || !this.getComparison().isThreeWay()) {
                this.getDiffProcessor().referenceChange(match, reference, value, DifferenceKind.DELETE, DifferenceSource.LEFT);
                continue;
            }
            this.getDiffProcessor().referenceChange(match, reference, value, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
    }

    protected void computeContainmentDifference(Match match, EReference reference, boolean checkOrdering) {
        Iterable leftValues = Iterables.filter(DefaultDiffEngine.getValue(match.getLeft(), (EStructuralFeature)reference), EObject.class);
        for (EObject leftValue : leftValues) {
            Match valueMatch = this.getComparison().getMatch(leftValue);
            if (valueMatch == null) continue;
            this.computeContainmentDiffForLeftValue(match, reference, valueMatch, checkOrdering);
        }
        Iterable rightValues = Iterables.filter(DefaultDiffEngine.getValue(match.getRight(), (EStructuralFeature)reference), EObject.class);
        for (EObject rightValue : rightValues) {
            Match valueMatch = this.getComparison().getMatch(rightValue);
            if (valueMatch == null || valueMatch.getLeft() != null && DefaultDiffEngine.isContainedBy(match.getLeft(), reference, valueMatch.getLeft())) continue;
            this.computeContainmentDiffForRightValue(match, reference, valueMatch, checkOrdering);
        }
    }

    protected void computeContainmentDiffForLeftValue(Match parent, EReference reference, Match value, boolean checkOrdering) {
        EObject leftValue = value.getLeft();
        EObject rightValue = value.getRight();
        EObject originValue = value.getOrigin();
        if (rightValue == null) {
            if (originValue == null) {
                this.getDiffProcessor().referenceChange(parent, reference, leftValue, DifferenceKind.ADD, DifferenceSource.LEFT);
            } else if (DefaultDiffEngine.isContainedBy(parent.getOrigin(), reference, originValue)) {
                this.getDiffProcessor().referenceChange(parent, reference, leftValue, DifferenceKind.DELETE, DifferenceSource.RIGHT);
            } else {
                this.getDiffProcessor().referenceChange(parent, reference, leftValue, DifferenceKind.MOVE, DifferenceSource.LEFT);
            }
        } else if (originValue == null) {
            if (!DefaultDiffEngine.isContainedBy(parent.getRight(), reference, rightValue)) {
                this.getDiffProcessor().referenceChange(parent, reference, leftValue, DifferenceKind.ADD, DifferenceSource.LEFT);
            }
        } else if (!DefaultDiffEngine.isContainedBy(parent.getRight(), reference, rightValue) && !DefaultDiffEngine.isContainedBy(parent.getOrigin(), reference, originValue)) {
            this.getDiffProcessor().referenceChange(parent, reference, leftValue, DifferenceKind.MOVE, DifferenceSource.LEFT);
        }
    }

    protected void computeContainmentDiffForRightValue(Match parent, EReference reference, Match value, boolean checkOrdering) {
        EObject leftValue = value.getLeft();
        EObject rightValue = value.getRight();
        EObject originValue = value.getOrigin();
        if (leftValue == null) {
            if (originValue == null && this.getComparison().isThreeWay()) {
                this.getDiffProcessor().referenceChange(parent, reference, rightValue, DifferenceKind.ADD, DifferenceSource.RIGHT);
            } else if (originValue == null || DefaultDiffEngine.isContainedBy(parent.getOrigin(), reference, originValue)) {
                this.getDiffProcessor().referenceChange(parent, reference, rightValue, DifferenceKind.DELETE, DifferenceSource.LEFT);
            } else {
                this.getDiffProcessor().referenceChange(parent, reference, rightValue, DifferenceKind.MOVE, DifferenceSource.RIGHT);
            }
        } else if (originValue == null && this.getComparison().isThreeWay()) {
            this.getDiffProcessor().referenceChange(parent, reference, rightValue, DifferenceKind.ADD, DifferenceSource.RIGHT);
        } else if (this.getComparison().isThreeWay() && !DefaultDiffEngine.isContainedBy(parent.getOrigin(), reference, originValue)) {
            this.getDiffProcessor().referenceChange(parent, reference, rightValue, DifferenceKind.MOVE, DifferenceSource.RIGHT);
        }
    }

    protected static boolean isContainedBy(EObject container, EReference containmentReference, EObject value) {
        return container == value.eContainer() && containmentReference == value.eContainmentFeature();
    }

    protected static Iterable<Object> getValue(EObject object, EStructuralFeature feature) {
        if (object != null) {
            Object value = object.eGet(feature, false);
            Set<Object> asList = value instanceof Iterable ? (Set<Object>)value : Collections.singleton(value);
            return asList;
        }
        return Collections.emptyList();
    }

    protected IDiffProcessor createDiffProcessor() {
        return new DiffBuilder();
    }

    protected final IDiffProcessor getDiffProcessor() {
        return this.diffProcessor;
    }

    protected FeatureFilter createFeatureFilter() {
        return new FeatureFilter();
    }

    protected Comparison getComparison() {
        return this.currentComparison;
    }

    protected Object findMatch(Object reference, Iterable<Object> candidates) {
        for (Object candidate : candidates) {
            if (!this.matchingValues(reference, candidate)) continue;
            return candidate;
        }
        return UNMATCHED_VALUE;
    }

    protected boolean matchingValues(Object object1, Object object2) {
        boolean equal;
        if (object1 == object2) {
            equal = true;
        } else if (object1 instanceof EEnumLiteral && object2 instanceof EEnumLiteral) {
            EEnumLiteral literal1 = (EEnumLiteral)object1;
            EEnumLiteral literal2 = (EEnumLiteral)object2;
            String value1 = String.valueOf(literal1.getLiteral()) + literal1.getValue();
            String value2 = String.valueOf(literal2.getLiteral()) + literal2.getValue();
            equal = value1.equals(value2);
        } else {
            Match match;
            equal = object1 instanceof EObject && object2 instanceof EObject ? (match = this.getComparison().getMatch((EObject)object1)).getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2 : (object1 != null && object1.getClass().isArray() && object2 != null && object2.getClass().isArray() ? this.matchingArrays(object1, object2) : object1 != null && object1.equals(object2));
        }
        return equal;
    }

    private boolean matchingArrays(Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = true;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(element1, element2);
                ++i;
            }
        }
        return equal;
    }
}

