/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelIdentifier {
    private static final String DEFAULT_EXTENSION = "ecore";
    private static final String EXTENSIONS_WILDCARD = "*";
    private final String namespace;
    private final String extension;

    public ModelIdentifier(Resource ... resources) {
        ArrayList<URI> uris = new ArrayList<URI>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                uris.add(resources[i].getURI());
            }
            ++i;
        }
        URI[] uriArray = uris.toArray(new URI[uris.size()]);
        this.namespace = ModelIdentifier.getCommonNamespace(resources);
        String ext = ModelIdentifier.getCommonExtension(uriArray);
        this.extension = ext != null ? ext : (this.namespace == null ? DEFAULT_EXTENSION : null);
    }

    public boolean matchExtension(String extensions) {
        if (this.extension == null || extensions == null) {
            return false;
        }
        boolean match = false;
        String[] extensionsArray = extensions.split(",");
        int i = 0;
        while (i < extensionsArray.length && !match) {
            String candidate = extensionsArray[i].trim();
            match = this.extension.equals(candidate) || EXTENSIONS_WILDCARD.equals(candidate);
            ++i;
        }
        return match;
    }

    public boolean matchNamespace(String candidate) {
        if (this.namespace == null || candidate == null) {
            return false;
        }
        return this.namespace.matches(candidate.trim());
    }

    private static String getCommonExtension(URI ... uris) {
        String extension = null;
        int i = 0;
        while (i < uris.length) {
            if (uris[i] != null) {
                String fileExtension = uris[i].fileExtension();
                if (extension == null && fileExtension != null) {
                    extension = fileExtension;
                } else if (fileExtension != null && !fileExtension.equals(extension)) {
                    return null;
                }
            }
            ++i;
        }
        return extension;
    }

    private static String getCommonNamespace(Resource ... resources) {
        String namespace = null;
        int i = 0;
        while (i < resources.length) {
            EObject rootContainer;
            if (resources[i] != null && !resources[i].getContents().isEmpty() && (rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)resources[i].getContents().get(0)).eClass())) instanceof EPackage) {
                String nsURI = ((EPackage)rootContainer).getNsURI();
                if (namespace == null && nsURI != null) {
                    namespace = nsURI;
                } else if (nsURI == null || !nsURI.equals(namespace)) {
                    return null;
                }
            }
            ++i;
        }
        return namespace;
    }
}

