/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.scope;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterComparisonScope
implements IComparisonScope {
    protected Predicate<? super EObject> eObjectContentFilter = Predicates.alwaysTrue();
    protected Predicate<? super EObject> resourceContentFilter = Predicates.alwaysTrue();
    protected Predicate<? super Resource> resourceSetContentFilter = Predicates.alwaysTrue();
    private final Notifier left;
    private final Notifier right;
    private final Notifier origin;

    public FilterComparisonScope(Notifier left, Notifier right, Notifier origin) {
        this.left = left;
        this.right = right;
        this.origin = origin;
    }

    @Override
    public Notifier getLeft() {
        return this.left;
    }

    @Override
    public Notifier getRight() {
        return this.right;
    }

    @Override
    public Notifier getOrigin() {
        return this.origin;
    }

    @Override
    public Iterator<? extends Resource> getCoveredResources(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return Iterators.emptyIterator();
        }
        Iterator allResources = resourceSet.getResources().iterator();
        UnmodifiableIterator filter = Iterators.filter((Iterator)allResources, this.resourceSetContentFilter);
        return Iterators.unmodifiableIterator((Iterator)filter);
    }

    @Override
    public Iterator<? extends EObject> getCoveredEObjects(Resource resource) {
        if (resource == null) {
            return Iterators.emptyIterator();
        }
        UnmodifiableIterator properContent = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)false), EObject.class);
        UnmodifiableIterator filter = Iterators.filter((Iterator)properContent, this.resourceContentFilter);
        return Iterators.unmodifiableIterator((Iterator)filter);
    }

    @Override
    public Iterator<? extends EObject> getChildren(EObject eObject) {
        if (eObject == null) {
            return Iterators.emptyIterator();
        }
        UnmodifiableIterator properContent = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)eObject, (boolean)false), EObject.class);
        UnmodifiableIterator filter = Iterators.filter((Iterator)properContent, this.eObjectContentFilter);
        return Iterators.unmodifiableIterator((Iterator)filter);
    }

    public void setEObjectContentFilter(Predicate<? super EObject> newContentFilter) {
        this.eObjectContentFilter = newContentFilter;
    }

    public void setResourceContentFilter(Predicate<? super EObject> resourceContentFilter) {
        this.resourceContentFilter = resourceContentFilter;
    }

    public void setResourceSetContentFilter(Predicate<? super Resource> resourceSetContentFilter) {
        this.resourceSetContentFilter = resourceSetContentFilter;
    }
}

