/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public final class SimilarityUtil {
    private SimilarityUtil() {
    }

    public static double diceCoefficient(String first, String second) {
        double coefficient;
        char[] str2;
        char[] str1 = first.toLowerCase().toCharArray();
        if (str1.equals(str2 = second.toLowerCase().toCharArray())) {
            coefficient = 1.0;
        } else if (str1.length <= 2 || str2.length <= 2) {
            int equalChars = 0;
            int i = 0;
            while (i < Math.min(str1.length, str2.length)) {
                if (str1[i] == str2[i]) {
                    ++equalChars;
                }
                ++i;
            }
            int union = str1.length + str2.length;
            coefficient = str1.length != str2.length ? (double)equalChars / (double)union : (double)equalChars * 2.0 / (double)union;
        } else {
            char[] chars;
            HashSet s1Bigrams = Sets.newHashSet();
            HashSet s2Bigrams = Sets.newHashSet();
            int i = 0;
            while (i < str1.length - 1) {
                chars = new char[]{str1[i], str1[i + 1]};
                s1Bigrams.add(String.valueOf(chars));
                ++i;
            }
            i = 0;
            while (i < str2.length - 1) {
                chars = new char[]{str2[i], str2[i + 1]};
                s2Bigrams.add(String.valueOf(chars));
                ++i;
            }
            Sets.SetView intersection = Sets.intersection((Set)s1Bigrams, (Set)s2Bigrams);
            coefficient = 2 * intersection.size() / (s1Bigrams.size() + s2Bigrams.size());
        }
        return coefficient;
    }
}

