/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.actions.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class DifferenceFilter
extends ViewerFilter {
    private Set<DifferenceKind> differenceKind = Sets.newHashSet();
    private List<TreeViewer> viewers = Lists.newArrayList();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = false;
        if (this.differenceKind.isEmpty()) {
            result = true;
        } else if (element instanceof DiffNode) {
            Diff diff = ((DiffNode)((Object)element)).getTarget();
            result = diff.getState() == DifferenceState.UNRESOLVED && this.differenceKind.contains(diff.getKind());
        } else if (element instanceof MatchNode) {
            Iterator differences = ((MatchNode)((Object)element)).getTarget().getAllDifferences().iterator();
            while (!result && differences.hasNext()) {
                result = this.differenceKind.contains(((Diff)differences.next()).getKind());
            }
        }
        return result;
    }

    public void addFilter(DifferenceKind diffKind) {
        boolean changed = this.differenceKind.add(diffKind);
        if (changed) {
            this.refreshViewers();
        }
    }

    public void removeFilter(DifferenceKind diffKind) {
        boolean changed = this.differenceKind.remove(diffKind);
        if (changed) {
            this.refreshViewers();
        }
    }

    private void refreshViewers() {
        for (TreeViewer viewer : this.viewers) {
            TreePath[] paths = viewer.getExpandedTreePaths();
            viewer.refresh();
            viewer.setExpandedTreePaths(paths);
        }
    }

    public void install(final TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this);
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DifferenceFilter.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(TreeViewer viewer) {
        viewer.removeFilter((ViewerFilter)this);
        this.viewers.remove(viewer);
    }
}

