/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.actions.group;

import com.google.common.collect.Iterables;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroup;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffNode;
import org.eclipse.swt.graphics.Image;

public class DifferenceGroupNode
extends AbstractEDiffNode {
    private final Comparison parent;
    private final DifferenceGroup group;

    public DifferenceGroupNode(Comparison comparison, AdapterFactory factory, DifferenceGroup group) {
        super(factory);
        this.parent = comparison;
        this.group = group;
    }

    public IDiffElement[] getChildren() {
        Iterable<? extends Diff> diffs = this.group.getDifferences();
        Iterable<IDiffElement> children = DifferenceGroupNode.adapt(diffs, this.getAdapterFactory(), IDiffElement.class);
        return (IDiffElement[])Iterables.toArray(children, IDiffElement.class);
    }

    public Image getImage() {
        Image groupImage = this.group.getImage();
        if (groupImage != null) {
            return groupImage;
        }
        return EMFCompareIDEUIPlugin.getDefault().getImage("icons/full/toolb16/group.gif");
    }

    public String getName() {
        return this.group.getName();
    }

    public IDiffContainer getParent() {
        return (IDiffContainer)this.getAdapterFactory().adapt((Notifier)this.parent, IDiffContainer.class);
    }

    public boolean hasChildren() {
        return !Iterables.isEmpty(this.group.getDifferences());
    }
}

