/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.actions.group;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroup;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroupNode;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGroupProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DifferenceGrouper {
    private DifferenceGroupProvider provider;
    private List<TreeViewer> viewers = Lists.newArrayList();

    public Iterable<? extends IDiffElement> getGroups(final Comparison comparison, final AdapterFactory factory) {
        if (this.provider == null) {
            return null;
        }
        Predicate<DifferenceGroup> nonEmptyGroups = new Predicate<DifferenceGroup>(){

            public boolean apply(DifferenceGroup input) {
                return input != null && !Iterables.isEmpty(input.getDifferences());
            }
        };
        Function<DifferenceGroup, IDiffElement> groupWrapper = new Function<DifferenceGroup, IDiffElement>(){

            public IDiffElement apply(DifferenceGroup input) {
                return new DifferenceGroupNode(comparison, factory, input);
            }
        };
        Iterable<? extends DifferenceGroup> groups = this.provider.getGroups(comparison);
        Iterable filteredGroups = Iterables.filter(groups, (Predicate)nonEmptyGroups);
        return Iterables.transform((Iterable)filteredGroups, (Function)groupWrapper);
    }

    public void setProvider(DifferenceGroupProvider provider) {
        if (this.provider != provider) {
            this.provider = provider;
            this.refreshViewers();
        }
    }

    private void refreshViewers() {
        for (TreeViewer viewer : this.viewers) {
            TreePath[] paths = viewer.getExpandedTreePaths();
            viewer.refresh();
            viewer.setExpandedTreePaths(paths);
        }
    }

    public void install(final TreeViewer viewer) {
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DifferenceGrouper.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(TreeViewer viewer) {
        this.viewers.remove(viewer);
    }
}

