/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.actions.mergeway;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.CompareConfigurationExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeWayAction
extends Action {
    private final CompareConfiguration fCompareConfiguration;

    public MergeWayAction(CompareConfiguration compareConfiguration) {
        this.fCompareConfiguration = compareConfiguration;
        this.setId(MergeWayAction.class.getName());
        this.update();
    }

    private void update() {
        boolean rightToLeft = this.getRightToLeft();
        this.setRightToLeft(rightToLeft);
        this.setToolTipText(MergeWayAction.doGetToolTipText(rightToLeft));
        this.setImageDescriptor(MergeWayAction.doGetImageDescriptor(rightToLeft));
    }

    private boolean getRightToLeft() {
        return CompareConfigurationExtension.getBoolean(this.fCompareConfiguration, "org.eclipse.emf.compare.ide.ui.MERGE_TIP_RIGHT_TO_LEFT", true);
    }

    private void setRightToLeft(boolean rightToLeft) {
        this.fCompareConfiguration.setProperty("org.eclipse.emf.compare.ide.ui.MERGE_TIP_RIGHT_TO_LEFT", (Object)rightToLeft);
    }

    private static String doGetToolTipText(boolean rightToLeft) {
        if (rightToLeft) {
            return "Consider merging from right to left";
        }
        return "Consider merging from left to right";
    }

    public static ImageDescriptor doGetImageDescriptor(boolean rightToLeft) {
        if (rightToLeft) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_rl.gif");
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_lr.gif");
    }

    public void run() {
        this.update();
    }
}

