/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeViewer<C extends Composite>
implements IMergeViewer<C> {
    private final ListenerList fSelectionChangedListeners;
    private final IMergeViewer.MergeViewerSide fSide;
    private final StructuredViewer fStructuredViewer;
    private final ForwardingViewerSelectionListener fForwardingSelectionListener;

    public AbstractMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        this.fStructuredViewer = this.createStructuredViewer(parent);
        this.fSide = side;
        this.fSelectionChangedListeners = new ListenerList();
        this.fForwardingSelectionListener = new ForwardingViewerSelectionListener();
        this.fStructuredViewer.addSelectionChangedListener((ISelectionChangedListener)this.fForwardingSelectionListener);
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1);

    protected StructuredViewer getStructuredViewer() {
        return this.fStructuredViewer;
    }

    public void dispose() {
        this.fStructuredViewer.removeSelectionChangedListener((ISelectionChangedListener)this.fForwardingSelectionListener);
    }

    @Override
    public IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.getStructuredViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        Object control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.getStructuredViewer().setSelection(selection, true);
        ISelection sel = this.getSelection();
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, sel));
    }

    private void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        this.getStructuredViewer().setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.getStructuredViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    private class ForwardingViewerSelectionListener
    implements ISelectionChangedListener {
        private ForwardingViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractMergeViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractMergeViewer.this, event.getSelection()));
        }
    }
}

