/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.AbstractBufferedCanvas;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DiffInsertionPoint;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener {
    private static final String NORMAL_CURSOR = "fNormalCursor";
    private static final String H_SASH_CURSOR = "fHSashCursor";
    private static final String HV_SASH_CURSOR = "fHVSashCursor";
    private static final String V_SASH_CURSOR = "fVSashCursor";
    protected static final int HORIZONTAL = 1;
    protected static final int VERTICAL = 2;
    protected static final double HSPLIT = 0.5;
    protected static final double VSPLIT = 0.3;
    protected static final int CENTER_WIDTH = 34;
    protected final boolean fIsMotif;
    protected final boolean fIsCarbon;
    protected final boolean fIsMac;
    private CompareHandlerService fHandlerService;
    private IMergeViewer<? extends Composite> fAncestor;
    private IMergeViewer<? extends Composite> fLeft;
    private IMergeViewer<? extends Composite> fRight;
    private final DynamicObject fDynamicObject;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private final Comparison fComparison;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        super(style, bundle, cc);
        this.fIsMotif = Util.isMotif();
        this.fIsCarbon = Util.isCarbon();
        this.fIsMac = Util.isMac();
        this.fDynamicObject = new DynamicObject((Object)this);
        this.fComparison = ((ComparisonNode)((Object)cc.getProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT"))).getTarget();
    }

    public EMFCompareColor getColors() {
        return this.fColors;
    }

    protected final Comparison getComparison() {
        return this.fComparison;
    }

    public boolean isThreeWay() {
        return super.isThreeWay();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        this.fLeft.setSelection(left);
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener(this);
        this.fLeft = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener(this);
        this.fLeft.getControl().getVerticalBar().setVisible(false);
        this.fRight = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener(this);
        this.fRight.getControl().getVerticalBar().setVisible(false);
        this.fColors = new EMFCompareColor(this, null, this.getCompareConfiguration());
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        Action a;
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.getLeftMergeViewer().getControl().getShell());
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            a = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            a = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)a, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyRightToLeft");
        }
    }

    protected abstract void copyDiffRightToLeft();

    protected abstract void copyDiffLeftToRight();

    protected void setCurrentDiff(Object d, boolean revealAndSelect) {
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract IMergeViewer<? extends Scrollable> createMergeViewer(Composite var1, IMergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected void setCenterControl(Control center) {
        this.fDynamicObject.set("fCenter", center);
    }

    protected CLabel getAncestorLabel() {
        return (CLabel)this.fDynamicObject.get("fAncestorLabel");
    }

    protected CLabel getLeftLabel() {
        return (CLabel)this.fDynamicObject.get("fLeftLabel");
    }

    protected CLabel getRightLabel() {
        return (CLabel)this.fDynamicObject.get("fRightLabel");
    }

    protected Cursor getVSashCursor() {
        return (Cursor)this.fDynamicObject.get(V_SASH_CURSOR);
    }

    protected Cursor getHVSashCursor() {
        return (Cursor)this.fDynamicObject.get(HV_SASH_CURSOR);
    }

    protected double getHSplit() {
        return this.fDynamicObject.getDouble("fHSplit");
    }

    protected double getVSplit() {
        return this.fDynamicObject.getDouble("fVSplit");
    }

    protected void setHSplit(double value) {
        this.fDynamicObject.setDouble("fHSplit", value);
    }

    protected void getVSplit(double value) {
        this.fDynamicObject.setDouble("fVSplit", value);
    }

    protected void setVSplit(double value) {
        this.fDynamicObject.setDouble("fVSplit", value);
    }

    protected Cursor getHSashCursor() {
        return (Cursor)this.fDynamicObject.get(H_SASH_CURSOR);
    }

    protected Cursor getNormalCursor() {
        return (Cursor)this.fDynamicObject.get(NORMAL_CURSOR);
    }

    protected void setVSashCursor(Cursor cursor) {
        this.fDynamicObject.set(V_SASH_CURSOR, cursor);
    }

    protected void setHVSashCursor(Cursor cursor) {
        this.fDynamicObject.set(HV_SASH_CURSOR, cursor);
    }

    protected void setHSashCursor(Cursor cursor) {
        this.fDynamicObject.set(H_SASH_CURSOR, cursor);
    }

    protected void setNormalCursor(Cursor cursor) {
        this.fDynamicObject.set(NORMAL_CURSOR, cursor);
    }

    protected void updateCursor_(Control c, int dir) {
        if (!(c instanceof Sash)) {
            Cursor cursor = null;
            switch (dir) {
                case 2: {
                    if (this.isAncestorVisible()) {
                        if (this.getVSashCursor() == null) {
                            this.setVSashCursor(new Cursor((Device)c.getDisplay(), 7));
                        }
                        cursor = this.getVSashCursor();
                        break;
                    }
                    if (this.getNormalCursor() == null) {
                        this.setNormalCursor(new Cursor((Device)c.getDisplay(), 0));
                    }
                    cursor = this.getNormalCursor();
                    break;
                }
                case 1: {
                    if (this.getHSashCursor() == null) {
                        this.setHSashCursor(new Cursor((Device)c.getDisplay(), 9));
                    }
                    cursor = this.getHSashCursor();
                    break;
                }
                case 3: {
                    if (this.isAncestorVisible()) {
                        if (this.getHVSashCursor() == null) {
                            this.setHVSashCursor(new Cursor((Device)c.getDisplay(), 5));
                        }
                        cursor = this.getHVSashCursor();
                        break;
                    }
                    if (this.getHSashCursor() == null) {
                        this.setHSashCursor(new Cursor((Device)c.getDisplay(), 9));
                    }
                    cursor = this.getHSashCursor();
                }
            }
            if (cursor != null) {
                c.setCursor(cursor);
            }
        }
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(Composite parent) {
        AbstractBufferedCanvas canvas = new AbstractBufferedCanvas(parent, 0){

            public void doPaint(GC gc) {
                EMFCompareContentMergeViewer.this.paintCenter(this, gc);
            }
        };
        new Resizer((Control)canvas, 1);
        if (this.getNormalCursor() == null) {
            this.setNormalCursor(new Cursor((Device)canvas.getDisplay(), 0));
        }
        return canvas;
    }

    protected abstract void paintCenter(Canvas var1, GC var2);

    protected IMergeViewer<? extends Scrollable> getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected IMergeViewer<? extends Scrollable> getLeftMergeViewer() {
        return this.fLeft;
    }

    protected IMergeViewer<? extends Scrollable> getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                Object firstElement;
                Object match;
                ISelectionProvider selectionProvider = event.getSelectionProvider();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (match = (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof DiffInsertionPoint ? ((DiffInsertionPoint)firstElement).getMatch() : (firstElement instanceof EObject ? this.getComparison().getMatch((EObject)firstElement) : null)) != null) {
                    this.synchronizeSelection(selectionProvider, (Match)match);
                }
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    private void synchronizeSelection(ISelectionProvider selectionProvider, Match match) {
        if (selectionProvider == this.fLeft) {
            this.fRight.setSelection(match);
            this.fAncestor.setSelection(match);
        } else if (selectionProvider == this.fRight) {
            this.fLeft.setSelection(match);
            this.fAncestor.setSelection(match);
        } else {
            this.fLeft.setSelection(match);
            this.fRight.setSelection(match);
        }
    }

    protected class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public Resizer(Control c, int dir) {
            this.fDirection = dir;
            this.fControl = c;
            this.fLiveResize = !(this.fControl instanceof Sash);
            EMFCompareContentMergeViewer.this.updateCursor_(c, dir);
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Resizer.this.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
            if ((this.fDirection & 1) != 0) {
                EMFCompareContentMergeViewer.this.setHSplit(-1.0);
            }
            if ((this.fDirection & 2) != 0) {
                EMFCompareContentMergeViewer.this.setVSplit(0.3);
            }
            EMFCompareContentMergeViewer.this.getControl().layout(true);
        }

        public void mouseDown(MouseEvent e) {
            Composite parent = this.fControl.getParent();
            Point s = parent.getSize();
            Point as = EMFCompareContentMergeViewer.this.getAncestorLabel().getSize();
            Point ys = EMFCompareContentMergeViewer.this.getLeftLabel().getSize();
            Point ms = EMFCompareContentMergeViewer.this.getRightLabel().getSize();
            this.fWidth1 = ys.x;
            this.fWidth2 = ms.x;
            this.fHeight1 = EMFCompareContentMergeViewer.this.getLeftLabel().getLocation().y - as.y;
            this.fHeight2 = s.y - (EMFCompareContentMergeViewer.this.getLeftLabel().getLocation().y + ys.y);
            this.fX = e.x;
            this.fY = e.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent e) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(e);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(e);
            }
        }

        private void resize(MouseEvent e) {
            int dx = e.x - this.fX;
            int dy = e.y - this.fY;
            int centerWidth = ((EMFCompareContentMergeViewer)EMFCompareContentMergeViewer.this).getCenterControl().getSize().x;
            if (this.fWidth1 + dx > centerWidth && this.fWidth2 - dx > centerWidth) {
                this.fWidth1 += dx;
                this.fWidth2 -= dx;
                if ((this.fDirection & 1) != 0) {
                    EMFCompareContentMergeViewer.this.setHSplit((double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2));
                }
            }
            if (this.fHeight1 + dy > centerWidth && this.fHeight2 - dy > centerWidth) {
                this.fHeight1 += dy;
                this.fHeight2 -= dy;
                if ((this.fDirection & 2) != 0) {
                    EMFCompareContentMergeViewer.this.setVSplit((double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2));
                }
            }
            EMFCompareContentMergeViewer.this.getControl().layout(true);
            this.fControl.getDisplay().update();
        }
    }
}

