/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.IStructuralFeatureAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffAccessor
implements IStructuralFeatureAccessor,
ITypedElement {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final ImmutableList<Diff> fDiffFromThisSide;
    private final ImmutableList<Diff> fDiffFromTheOtherSide;
    private final ImmutableList<Diff> fDiffFromAncestor;

    public AbstractDiffAccessor(Diff diff, IMergeViewer.MergeViewerSide side) {
        this.fDiff = diff;
        this.fSide = side;
        EList siblingDifferences = diff.getMatch().getDifferences();
        ImmutableList.Builder thisSide = ImmutableList.builder();
        ImmutableList.Builder otherSide = ImmutableList.builder();
        ImmutableList.Builder ancestorSide = ImmutableList.builder();
        this.fillSiblingDifferencesLists((List<Diff>)siblingDifferences, (ImmutableList.Builder<Diff>)thisSide, (ImmutableList.Builder<Diff>)otherSide, (ImmutableList.Builder<Diff>)ancestorSide);
        this.fDiffFromThisSide = thisSide.build();
        this.fDiffFromTheOtherSide = otherSide.build();
        this.fDiffFromAncestor = ancestorSide.build();
    }

    private EObject getEObject(Diff diff) {
        EObject eObject;
        Match match = diff.getMatch();
        switch (this.fSide) {
            case ANCESTOR: {
                eObject = match.getOrigin();
                break;
            }
            case LEFT: {
                eObject = match.getLeft();
                break;
            }
            case RIGHT: {
                eObject = match.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return eObject;
    }

    private void fillSiblingDifferencesLists(List<Diff> siblingDifferences, ImmutableList.Builder<Diff> thisSide, ImmutableList.Builder<Diff> otherSide, ImmutableList.Builder<Diff> ancestorSide) {
        for (Diff siblingDiff : siblingDifferences) {
            EStructuralFeature feature = this.getEStructuralFeature(siblingDiff);
            if (feature != this.getEStructuralFeature()) continue;
            switch (siblingDiff.getKind()) {
                case ADD: 
                case CHANGE: 
                case MOVE: {
                    this.addToSideList(siblingDiff, thisSide, otherSide, ancestorSide);
                    break;
                }
                case DELETE: {
                    this.addToSideList(siblingDiff, otherSide, thisSide, ancestorSide);
                }
            }
        }
    }

    @Override
    public EStructuralFeature getEStructuralFeature() {
        return this.getEStructuralFeature(this.fDiff);
    }

    @Override
    public Diff getDiff() {
        return this.fDiff;
    }

    @Override
    public Object getValue() {
        return this.getValue(this.fDiff);
    }

    private EStructuralFeature getEStructuralFeature(Diff siblingDiff) {
        Object feature = siblingDiff instanceof ReferenceChange ? ((ReferenceChange)siblingDiff).getReference() : (siblingDiff instanceof AttributeChange ? ((AttributeChange)siblingDiff).getAttribute() : null);
        return feature;
    }

    private void addToSideList(Diff diff, ImmutableList.Builder<Diff> boxSide, ImmutableList.Builder<Diff> lineSide, ImmutableList.Builder<Diff> ancestorSide) {
        DifferenceSource source = diff.getSource();
        if (source == DifferenceSource.LEFT && this.fSide == IMergeViewer.MergeViewerSide.LEFT) {
            boxSide.add((Object)diff);
        } else if (source == DifferenceSource.RIGHT && this.fSide == IMergeViewer.MergeViewerSide.RIGHT) {
            boxSide.add((Object)diff);
        } else if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
            lineSide.add((Object)diff);
        } else {
            ancestorSide.add((Object)diff);
        }
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public List<?> getValues() {
        EObject eObject = this.getEObject(this.fDiff);
        if (eObject != null) {
            EStructuralFeature eStructuralFeature = this.getEStructuralFeature(this.fDiff);
            Object value = eObject.eGet(eStructuralFeature);
            if (eStructuralFeature.isMany()) {
                return (List)value;
            }
            return ImmutableList.of((Object)value);
        }
        return ImmutableList.of();
    }

    @Override
    public ImmutableList<Diff> getDiffFromThisSide() {
        return this.fDiffFromThisSide;
    }

    @Override
    public ImmutableList<Diff> getDiffFromTheOtherSide() {
        return this.fDiffFromTheOtherSide;
    }

    @Override
    public ImmutableList<Diff> getDiffFromAncestor() {
        return this.fDiffFromAncestor;
    }
}

