/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider;

import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.IMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.AbstractDiffAccessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class AttributeChangeAccessor
extends AbstractDiffAccessor {
    public AttributeChangeAccessor(AttributeChange attributeChange, IMergeViewer.MergeViewerSide side) {
        super((Diff)attributeChange, side);
    }

    public Object getValue(Diff diff) {
        Object value;
        Match match = diff.getMatch();
        switch (this.getSide()) {
            case ANCESTOR: {
                value = match.getOrigin().eGet(this.getEStructuralFeature());
                break;
            }
            case LEFT: {
                value = match.getLeft().eGet(this.getEStructuralFeature());
                break;
            }
            case RIGHT: {
                value = match.getRight().eGet(this.getEStructuralFeature());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        String toString = EcoreUtil.convertToString((EDataType)((EAttribute)this.getEStructuralFeature()).getEAttributeType(), (Object)value);
        return toString;
    }

    public Diff getDiff(Object value, IMergeViewer.MergeViewerSide side) {
        AttributeChange ret = null;
        Iterable attributeChanges = Iterables.filter((Iterable)Iterables.concat(this.getDiffFromThisSide(), this.getDiffFromTheOtherSide(), this.getDiffFromAncestor()), AttributeChange.class);
        for (AttributeChange attributeChange : attributeChanges) {
            Object attributeChangeValue = attributeChange.getValue();
            if (attributeChangeValue != value) continue;
            ret = attributeChange;
            break;
        }
        return ret;
    }

    public Match getMatch() {
        return this.getMatch(this.getDiff());
    }

    private Match getMatch(Diff diff) {
        Match match = diff.getMatch();
        return match;
    }

    public String getName() {
        return AttributeChangeAccessor.class.getName();
    }

    public Image getImage() {
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EAttribute"));
    }

    public String getType() {
        return "objectlist";
    }
}

